using System;
namespace Volpe.Cafe.Model
{
    public sealed class FunctionInformation
    {
        #region 
        public static bool IsSupportedFunction(int fncType)
        {
            return ((fncType >= 1 && fncType <= 9) || fncType == 99);
        }
        public static bool IsFlatStandard(int fncType)
        {
            return (fncType == 1 || fncType == 99);
        }
        public static bool IsLogisticFunction(int fncType)
        {
            return (fncType == 2 || fncType == 4);
        }
        public static bool IsExponentialFunction(int fncType)
        {
            return (fncType == 3 || fncType == 5);
        }
        public static bool IsLinearFunction(int fncType)
        {
            return (fncType >= 6 && fncType <= 9);
        }
        public static bool IsAreaBasedFunction(int fncType)
        {
            return (fncType == 2 || fncType == 3 || fncType == 6 || fncType == 8);
        }
        public static bool IsWeightBasedFunction(int fncType)
        {
            return (fncType == 4 || fncType == 5 || fncType == 7 || fncType == 9);
        }
        public static int GetCoefficientsCount(int fncType)
        {
            if      (fncType == 1 || fncType == 99                               ) { return 1; }
            else if (fncType == 2 || fncType == 4 || fncType == 6 || fncType == 7) { return 4; }
            else if (fncType == 3 || fncType == 5 || fncType == 8 || fncType == 9) { return 3; }
            else { throw new NotSupportedException("The specified function type is not supported."); }
        }
        #endregion
    }
}

