using System;
using System.Globalization;
namespace Volpe.Cafe
{
    [Serializable]
    public class ModelYear : IComparable
    {
        #region 
        static ModelYear()
        {
            ModelYear.MinModelYear = new ModelYear(ModelYear.MinYear);
        }
        public ModelYear(int year)
        {
            this.Year = year;
        }
        #endregion
        #region 
        #region 
        public int CompareTo(object obj)
        {
            int year = 0;
            if      (obj is ModelYear     ) { year = ((ModelYear)obj).Year; }
            else if (Global.IsNumeric(obj)) { year = Global.GetInt32(obj);  }
            else    { throw new ArgumentException("The specified object is not a ModelYear instance or a numeric value."); }
            return this._modelYear.CompareTo(year);
        }
        #endregion
        #region 
        public override string ToString()
        {
            return this._modelYear.ToString();
        }
        public override int GetHashCode()
        {
            return this._modelYear.GetHashCode();
        }
        public override bool Equals(object obj)
        {
            if (obj == null)
            {
                throw new ArgumentNullException("obj");
            }
            return (this.CompareTo(obj) == 0);
        }
        public bool Equals(ModelYear year)
        {
            return (this._modelYear == year.Year);
        }
        public bool Equals(int year)
        {
            return (this._modelYear == year);
        }
        public bool EqualsIndex(int index)
        {
            return (this._modelYear - ModelYear.MinYear == index);
        }
        #endregion
        public static int ToIndex(int year)
        {
            if (year < ModelYear.MinYear)
            {
                throw new ArgumentOutOfRangeException("year", year,
                    "The value specified for model year cannot be less than " + ModelYear.MinYear + ".");
            }
            return year - ModelYear.MinYear;
        }
        public static int FromIndex(int index)
        {
            return index + ModelYear.MinYear;
        }
        public static bool IsValid(int year)
        {
            return (year >= ModelYear.MinYear);
        }
        #endregion
        #region 
        public int Index
        {
            get { return ModelYear.ToIndex(this._modelYear); }
            set { this._modelYear = ModelYear.FromIndex(value); }
        }
        public int Year
        {
            get { return this._modelYear; }
            set { this.Index = ModelYear.ToIndex(value); }
        }
        #endregion
        #region 
        public static readonly ModelYear MinModelYear;
        public const int MinYear = 2000;
        int _modelYear;
        #endregion
    }
}

