using System;
namespace Volpe.Utils
{
    [Serializable]
    public class XlTextAlignment
    {
        #region 
        public XlTextAlignment()
            : this(XlTextAlignment.DefaultHorizontal, XlTextAlignment.DefaultVertical)
        {
        }
        public XlTextAlignment(XlHAlign horizontal)
            : this(horizontal, XlTextAlignment.DefaultVertical)
        {
        }
        public XlTextAlignment(XlVAlign vertical)
            : this(XlTextAlignment.DefaultHorizontal, vertical)
        {
        }
        public XlTextAlignment(XlHAlign horizontal, XlVAlign vertical)
        {
            this._horizontal = horizontal;
            this._vertical = vertical;
        }
        #endregion
        #region 
        public override string ToString()
        {
            return "{Horizontal=" + this._horizontal.ToString() + ", Vertical=" + this._vertical.ToString() + "}";
        }
        #endregion
        #region 
        public XlHAlign Horizontal { get { return this._horizontal; } }
        public XlVAlign Vertical   { get { return this._vertical;   } }
        #endregion
        #region 
        public const XlHAlign DefaultHorizontal = XlHAlign.General;
        public const XlVAlign DefaultVertical = XlVAlign.Bottom;
        private XlHAlign _horizontal;
        private XlVAlign _vertical;
        #endregion
    }
}

