#region << Using Directives >>
using System;
#endregion
namespace Volpe.Cafe.Model.EIS
{
    [Serializable]
    class EisData : ICloneable
    {
        #region 
        [Serializable]
            public struct Data : ICloneable
        {
            #region 
            public Data(int length)
            {
                this.GasolineVMT     = new double[length, length];
                this.DieselVMT       = new double[length, length];
                this.GasolineGallons = new double[length, length];
                this.DieselGallons   = new double[length, length];
                this.Acetaldehyde    = new EmissionData(length);
                this.Acrolein        = new EmissionData(length);
                this.Benzene         = new EmissionData(length);
                this.Butadiene       = new EmissionData(length);
                this.CH4             = new EmissionData(length);
                this.CO              = new EmissionData(length);
                this.CO2             = new EmissionData(length);
                this.DieselPM        = new EmissionData(length);
                this.Formaldehyde    = new EmissionData(length);
                this.MTBE            = new EmissionData(length);
                this.N2O             = new EmissionData(length);
                this.NOx             = new EmissionData(length);
                this.PM              = new EmissionData(length);
                this.SO2             = new EmissionData(length);
                this.VOC             = new EmissionData(length);
            }
            #endregion
            #region 
            #region 
            object ICloneable.Clone()
            {
                return this.Clone();
            }
            public Data Clone()
            {
                int  length = this.GasolineVMT.Length;
                Data data   = new Data(length);
                int totalLength = length * length;
                Array.Copy(this.GasolineVMT      , 0, data.GasolineVMT      , 0, totalLength);
                Array.Copy(this.DieselVMT        , 0, data.DieselVMT        , 0, totalLength);
                Array.Copy(this.GasolineGallons  , 0, data.GasolineGallons  , 0, totalLength);
                Array.Copy(this.DieselGallons    , 0, data.DieselGallons    , 0, totalLength);
                data.Acetaldehyde = this.Acetaldehyde.Clone();
                data.Acrolein     = this.Acrolein    .Clone();
                data.Benzene      = this.Benzene     .Clone();
                data.Butadiene    = this.Butadiene   .Clone();
                data.CH4          = this.CH4         .Clone();
                data.CO           = this.CO          .Clone();
                data.CO2          = this.CO2         .Clone();
                data.DieselPM     = this.DieselPM    .Clone();
                data.Formaldehyde = this.Formaldehyde.Clone();
                data.MTBE         = this.MTBE        .Clone();
                data.N2O          = this.N2O         .Clone();
                data.NOx          = this.NOx         .Clone();
                data.PM           = this.PM          .Clone();
                data.SO2          = this.SO2         .Clone();
                data.VOC          = this.VOC         .Clone();
                return data;
            }
            #endregion
            #endregion
            public double[,] GasolineVMT;
            public double[,] DieselVMT;
            public double[,] GasolineGallons;
            public double[,] DieselGallons;
            public EmissionData Acetaldehyde;
            public EmissionData Acrolein;
            public EmissionData Benzene;
            public EmissionData Butadiene;
            public EmissionData CH4;
            public EmissionData CO;
            public EmissionData CO2;
            public EmissionData DieselPM;
            public EmissionData Formaldehyde;
            public EmissionData MTBE;
            public EmissionData N2O;
            public EmissionData NOx;
            public EmissionData PM;
            public EmissionData SO2;
            public EmissionData VOC;
        }
        [Serializable]
            public struct EmissionData : ICloneable
        {
            #region 
            public EmissionData(int length)
            {
                this.TailpipeEmissions = new double[length, length];
                this.UpstreamEmissions = new double[length, length];
                this.TotalEmissions    = new double[length, length];
            }
            #endregion
            #region 
            #region 
            object ICloneable.Clone()
            {
                return this.Clone();
            }
            public EmissionData Clone()
            {
                int          length = this.TailpipeEmissions.Length;
                EmissionData data   = new EmissionData(length);
                int totalLength = length * length;
                Array.Copy(this.TailpipeEmissions, 0, data.TailpipeEmissions, 0, totalLength);
                Array.Copy(this.UpstreamEmissions, 0, data.UpstreamEmissions, 0, totalLength);
                Array.Copy(this.TotalEmissions   , 0, data.TotalEmissions   , 0, totalLength);
                return data;
            }
            #endregion
            #endregion
            public double[,] TailpipeEmissions;
            public double[,] UpstreamEmissions;
            public double[,] TotalEmissions;
        }
        #endregion
        #region 
        private EisData()
        {
        }
        public EisData(int minYear, int maxYear)
            : this()
        {
            int length     = maxYear - minYear + 1;
            this.MinYear   = minYear;
            this.MaxYear   = maxYear;
            this.CarData   = new Data(length);
            this.TruckData = new Data(length);
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public EisData Clone()
        {
            EisData data = new EisData();
            data.MinYear   = this.MinYear;
            data.MaxYear   = this.MaxYear;
            data.CarData   = this.CarData.Clone();
            data.TruckData = this.TruckData.Clone();
            return data;
        }
        #endregion
        #endregion
        #region 
        public int MinYear;
        public int MaxYear;
        public Data CarData;
        public Data TruckData;
        #endregion
    }
}

