using System;
using System.Collections;
using Volpe.Cafe;
using Volpe.Cafe.Collections;
using Volpe.Cafe.Data;
using Volpe.Cafe.Settings;
namespace Volpe.Cafe.Model
{
    public class MarketSimulation
    {
        #region 
        public void AllocateCosts(Industry data, ModelingSettings settings, ModelYear year)
        {
            double    fineRate = settings.Parameters.EconomicValues.Kf;
            int       yrIndex  = year.Index;
            Vehicle[] allVehs  = this.GetModelYearVehicles(data, yrIndex);
            ManufacturerCollection mfrs = data.Manufacturers;
            for (int i = 0, mfrCount = mfrs.Count; i < mfrCount; i++)
            {
                ManufacturerModelingData mmd = mfrs[i].ModelingData;
                Vehicle[] mfrVehs     = this.GetModelYearVehicles(mfrs[i], yrIndex);
                int       mfrVehCount = mfrVehs.Length;
                double mfrSales = 0, mfrSalesRevenue = 0, mfrTechCost = 0;
                double mfrFines = mmd.Fines.Total;
                int mfrStrategy = mfrs[i].Description.CostAllocationStrategy;
                for (int j = 0; j < mfrVehCount; j++)
                {
                    VehicleDescription vd = mfrVehs[j].Description;
                    mfrSales        += vd.Sales[yrIndex];
                    mfrSalesRevenue += vd.Sales[yrIndex] * vd.Msrp[yrIndex];
                    mfrTechCost     += mfrVehs [j].ModelingData.TechCost;
                }
                if (mfrStrategy == 3)
                {   
                    for (int j = 0; j < mfrVehCount; j++)
                    {
                        mfrVehs[j].ModelingData.RegCost = (mfrTechCost + mfrFines) / mfrSales *
                            mfrVehs[j].Description.Sales[yrIndex];
                    }
                } 
                else if (mfrStrategy == 1 || (mfrTechCost == 0 && mfrFines > 0))
                {   
                    double pctIncrease = (mfrTechCost + mfrFines) / mfrSalesRevenue;
                    for (int j = 0; j < mfrVehCount; j++)
                    {
                        mfrVehs[j].ModelingData.RegCost = (pctIncrease * mfrVehs[j].Description.Msrp[yrIndex]) *
                            mfrVehs[j].Description.Sales[yrIndex];
                    }
                } 
                else
                {   
                    for (int j = 0; j < mfrVehCount; j++)
                    {
                        VehicleModelingData vmd = mfrVehs[j].ModelingData;
                        vmd.RegCost = vmd.TechCost;
                    }
                    if (mfrFines > 0)
                    {
                        double[] vehPseudoFines = new double[mfrVehCount];
                        double   mfrPseudoFines = 0;
                        for (int j = 0; j < mfrVehCount; j++)
                        {
                            vehPseudoFines[j] = this.GetPseudoFine(mfrs[i], mfrVehs[j], yrIndex, fineRate);
                            mfrPseudoFines   += vehPseudoFines[j];
                        }
                        for (int j = 0; j < mfrVehCount; j++)
                        {
                            mfrVehs[j].ModelingData.RegCost += (mfrFines * (vehPseudoFines[j] / mfrPseudoFines));
                        }
                    } 
                } 
                mmd.RegCost.Clear();
                for (int j = 0; j < mfrVehCount; j++)
                {
                    RegulatoryClass vehRc = mfrVehs[j].RegClass;
                    mmd.RegCost[vehRc]   += mfrVehs[j].ModelingData.RegCost;
                }
            } 
        }
        double GetPseudoFine(Manufacturer mfr, Vehicle veh, int yrIndex, double fineRate)
        {
            double vehSales = veh.Description.Sales[yrIndex];
            double vehFe    = veh.Description.FuelEconomy;
            double standard = mfr.ModelingData.Standard[veh.RegClass];
            return Math.Max(0, fineRate * vehSales * (standard - vehFe));
        }
        Vehicle[] GetModelYearVehicles(Industry data, int yrIndex)
        {
            return this.GetModelYearVehicles(data.GetVehicles(), yrIndex);
        }
        Vehicle[] GetModelYearVehicles(Manufacturer mfr, int yrIndex)
        {
            return this.GetModelYearVehicles(mfr.Vehicles, yrIndex);
        }
        Vehicle[] GetModelYearVehicles(VehicleCollection vehs, int yrIndex)
        {
            int allVehCount = vehs.Count;
            int vehCount    = 0;
            for (int i = 0; i < allVehCount; i++)
            {
                if (vehs[i].IsValid(yrIndex)) { vehCount++; }
            }
            Vehicle[] yrVehs = new Vehicle[vehCount];
            for (int i = 0, j = 0; i < allVehCount; i++)
            {
                if (vehs[i].IsValid(yrIndex)) { yrVehs[j++] = vehs[i]; }
            }
            return yrVehs;
        }
        #endregion
    }
}

