using System;
using System.Diagnostics;
using System.IO;
using System.Windows.Forms;
using Volpe.Ui;
namespace Volpe.Cafe.Ui
{
    public sealed class Program
    {
        #region 
        private Program()
        {
        }
        #endregion
        #region 
        [STAThread]
        public static void Main(string[] args)
        {
            #if !DEBUG
                string logPath = Path.GetDirectoryName(Application.StartupPath) + "\\logs\\";
                if (!Directory.Exists(logPath)) { Directory.CreateDirectory(logPath); }
                string logFile = logPath + DateTime.Now.Ticks + ".log";
                StreamWriter logSw = new StreamWriter(logFile, false);
                logSw.AutoFlush = true;
                Console.SetOut(logSw);
            #endif
            Console.WriteLine("Starting run at:  {0}", DateTime.Now.ToString());
            Program program = new Program();
            program.Run(args);
            Console.WriteLine("Exiting model at: {0}", DateTime.Now.ToString());
            #if !DEBUG
                logSw.Close();
            #endif
        }
        private void Run(string[] args)
        {
            try
            {
                ProgramArgs pa = new ProgramArgs();
                pa.Parse(args);
                if (pa.Uninstall)
                {   
                    Process.Start("msiexec.exe", "/x " + pa.UninstallProductKey + " /qf");
                }
                else
                {   
                    Cafe2d ui = Cafe2d.CreateInstance();
                    if (pa.NoWarn || Program.ShowWarningsAndNotice(pa.ShowNotice))
                    {   
                        ui.Start(pa);
                    }
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "CAFE Model Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                Console.WriteLine(ex.ToString());
            }
        }
        internal static bool ShowWarningsAndNotice(bool showNotice)
        {
            string warningsPath = "..\\warnings.rtf";
            string noticePath = "..\\notice.rtf";
            if (!File.Exists(warningsPath))
            {
                warningsPath = "..\\" + warningsPath;
                if (!File.Exists(warningsPath)) { return false; }
            }
            if (!File.Exists(noticePath)) { noticePath = "..\\" + noticePath; }
            if (RtfDialog.ShowDialogFromFile("CAFE Model - Warnings", warningsPath, PromptOption.OkCancel) == DialogResult.OK)
            {
                if (showNotice && File.Exists(noticePath))
                {
                    RtfDialog.ShowDialogFromFile("CAFE Model - Notice", noticePath, PromptOption.Ok);
                }
                return true;
            }
            return false;
        }
        internal static void ShowAbout()
        {
            string aboutPath = "..\\about.rtf";
            if (!File.Exists(aboutPath)) { aboutPath = "..\\" + aboutPath; }
            if (File.Exists(aboutPath))
            {
                RtfDialog.ShowDialogFromFile("About CAFE Model", aboutPath, PromptOption.Ok, true);
            }
            else
            {
                RtfDialog.ShowDialog("About CAFE Model",
                    "U.S. Department of Transportation\n\n" +
                    "System requirements:\n\n" +
                    "Intel compatible processor (1 GHz or faster, recommended)\n" +
                    "512 MB RAM (1 GB recommended)\n" +
                    "10 MB hard drive space for installation (additional disk space will be required during runtime)\n\n" +
                    "Microsoft Windows XP\n" +
                    "Microsoft .NET Framework 1.1\n" +
                    "Microsoft Visual J# 1.1 Redistributable\n" +
                    "Microsoft Office 2003\n\n" +
                    "Contact:\n\n" + Program.ContactName + "\nU.S. Department of Transportation\n" +
                    "Volpe National Transportation Systems Center\n55 Broadway\nCambridge, MA  02142\n\n" +
                    "Voice:\t" + Program.ContactPhone +
                    "\nFax:\t" + Program.ContactFax +
                    "\nE-Mail:\t" + Program.ContactEmail, PromptOption.Ok, true);
            }
        }
        #endregion
        #region 
        internal const string ContactName  = "Kevin Green";
        internal const string ContactEmail = "green@volpe.dot.gov";
        internal const string ContactPhone = "(617) 494-2106";
        internal const string ContactFax   = "(617) 494-3688";
        #endregion
    }
}

