using System;
using System.IO;
namespace Volpe.Cafe.Ui
{
    public class ProgramArgs
    {
        #region 
        internal void Parse(string[] args)
        {
            this.HasArgs = false;
            this.ArgCount = 0;
            int argCount = args.Length;
            if (argCount == 1)
            {   
                string path = args[0];
                if (File.Exists(path) && Path.GetExtension(path).ToUpper() == ".CMSD")
                {    
                    this.HasArgs      = true;
                    this.ArgCount     = 1;
                    this.Open         = true;
                    this.OpenNoPrompt = false;
                    this.OpenPath     = path;
                    return;
                }
            }
            for (int i = 0; i < argCount; i++)
            {
                bool foundArg = true;
                string[] argParts = args[i].Split('=');
                string argKey = argParts[0].ToLower();
                string argPrm = (argParts.Length == 2) ? argParts[1] : null;
                bool isLow, isAvg, isHigh, isVHigh;
                switch (argKey)
                {
                    case "/nowarn"        : this.NoWarn         = true; break;
                    case "/shownotice"    : this.ShowNotice     = true; break;
                    case "/autostartmodel": this.AutoStartModel = true; break;
                    case "/close"         : this.Close          = true; break;
                    case "/exit"          : this.Exit           = true; break;
                    case "/open":
                        if (argPrm != null && File.Exists(argPrm) && Path.GetExtension(argPrm).ToUpper() == ".CMSD")
                        {
                            this.Open         = true;
                            this.OpenNoPrompt = true;
                            this.OpenPath     = argPrm;
                        }
                        break;
                    case "/save":
                        this.Save = true;
                        if (argPrm != null)
                        {
                            argPrm = Global.RemoveSpecialChars(argPrm, '_');
                        }
                        this.SaveName = argPrm;
                        break;
                    case "/params_fuelpriceestimates":
                        argPrm = argPrm.ToLower();
                        isLow  = (argPrm == "low");
                        isAvg  = (argPrm == "average");
                        isHigh = (argPrm == "high");
                        if (isLow || isAvg || isHigh)
                        {
                            this.Params_FuelPriceEstimates = true;
                            this.Params_FuelPriceEstimatesValue = (isLow) ? Estimates.Low : (isAvg) ? Estimates.Average :
                                Estimates.High;
                        }
                        break;
                    case "/params_co2estimates":
                        argPrm  = argPrm.ToLower();
                        isLow   = (argPrm == "low");
                        isAvg   = (argPrm == "average");
                        isHigh  = (argPrm == "high");
                        isVHigh = (argPrm == "veryhigh");
                        if (isLow || isAvg || isHigh || isVHigh)
                        {
                            this.Params_CO2Estimates = true;
                            this.Params_CO2EstimatesValue = (isLow) ? CO2Estimates.Low : (isAvg) ? CO2Estimates.Average :
                                (isHigh) ? CO2Estimates.High : CO2Estimates.VeryHigh;
                        }
                        break;
                    case "/params_reboundeffect":
                        if (Global.IsNumeric(argPrm))
                        {
                            this.Params_ReboundEffect      = true;
                            this.Params_ReboundEffectValue = Global.GetDouble(argPrm);
                        }
                        break;
                    case "/params_discountrate":
                        if (Global.IsNumeric(argPrm))
                        {
                            this.Params_DiscountRate      = true;
                            this.Params_DiscountRateValue = Global.GetDouble(argPrm);
                        }
                        break;
                    case "/params_vehicletraveltimevalue":
                        if (Global.IsNumeric(argPrm))
                        {
                            this.Params_VehicleTravelTimeValue      = true;
                            this.Params_VehicleTravelTimeValueValue = Global.GetDouble(argPrm);
                        }
                        break;
                    case "/params_militarysecurity":
                        if (Global.IsNumeric(argPrm))
                        {
                            this.Params_MilitarySecurity      = true;
                            this.Params_MilitarySecurityValue = Global.GetDouble(argPrm);
                        }
                        break;
                    case "/params_consumerbenefits":
                        if (Global.IsNumeric(argPrm))
                        {
                            this.Params_ConsumerBenefits      = true;
                            this.Params_ConsumerBenefitsValue = Global.GetDouble(argPrm);
                        }
                        break;
                    case "/u":
                        if (argPrm != null)
                        {
                            this.Uninstall           = true;
                            this.UninstallProductKey = argPrm;
                        }
                        break;
                    default:
                        foundArg = false;
                        break;    
                }
                if (foundArg) { this.ArgCount++; }
            }
            this.HasArgs = (this.ArgCount > 0);
        }
        #endregion
        #region 
        internal bool   HasArgs;
        internal int    ArgCount;
        internal bool   NoWarn;
        internal bool   ShowNotice;
        internal bool   Open;
        internal bool   OpenNoPrompt;
        internal string OpenPath;
        internal bool   Save;
        internal string SaveName;
        internal bool   AutoStartModel;
        internal bool   Close;
        internal bool   Exit;
        internal bool         Params_FuelPriceEstimates;
        internal Estimates    Params_FuelPriceEstimatesValue;
        internal bool         Params_CO2Estimates;
        internal CO2Estimates Params_CO2EstimatesValue;
        internal bool         Params_ReboundEffect;
        internal double       Params_ReboundEffectValue;
        internal bool         Params_DiscountRate;
        internal double       Params_DiscountRateValue;
        internal bool         Params_VehicleTravelTimeValue;
        internal double       Params_VehicleTravelTimeValueValue;
        internal bool         Params_MilitarySecurity;
        internal double       Params_MilitarySecurityValue;
        internal bool         Params_ConsumerBenefits;
        internal double       Params_ConsumerBenefitsValue;
        internal bool   Uninstall;
        internal string UninstallProductKey;
        #endregion
    }
}

