#region << Using Directives >>
using System;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Windows.Forms;
using Volpe.Ui;
#endregion
namespace Volpe.Cafe.Ui
{
	public class RtfDialog : System.Windows.Forms.Form
	{
        #region 
		RtfDialog()
		{
			this.InitializeComponent();
		}
		protected override void Dispose(bool disposing)
		{
			base.Dispose(disposing);
		}
        #endregion
        #region 
		#region 
		void InitializeComponent()
		{
            System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(RtfDialog));
            this.ux_rtf = new System.Windows.Forms.RichTextBox();
            this.ux_buttons = new System.Windows.Forms.Panel();
            this.ux_noButton = new System.Windows.Forms.Button();
            this.ux_yesButton = new System.Windows.Forms.Button();
            this.ux_cancelButton = new System.Windows.Forms.Button();
            this.ux_okButton = new System.Windows.Forms.Button();
            this.ux_buildInfo = new System.Windows.Forms.Label();
            this.ux_buttons.SuspendLayout();
            this.SuspendLayout();
            this.ux_rtf.BackColor = System.Drawing.Color.White;
            this.ux_rtf.Dock = System.Windows.Forms.DockStyle.Fill;
            this.ux_rtf.Location = new System.Drawing.Point(0, 0);
            this.ux_rtf.Name = "ux_rtf";
            this.ux_rtf.ReadOnly = true;
            this.ux_rtf.Size = new System.Drawing.Size(474, 298);
            this.ux_rtf.TabIndex = 1;
            this.ux_rtf.TabStop = false;
            this.ux_rtf.Text = "";
            this.ux_buttons.Controls.Add(this.ux_noButton);
            this.ux_buttons.Controls.Add(this.ux_yesButton);
            this.ux_buttons.Controls.Add(this.ux_cancelButton);
            this.ux_buttons.Controls.Add(this.ux_okButton);
            this.ux_buttons.Controls.Add(this.ux_buildInfo);
            this.ux_buttons.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.ux_buttons.Location = new System.Drawing.Point(0, 298);
            this.ux_buttons.Name = "ux_buttons";
            this.ux_buttons.Size = new System.Drawing.Size(474, 37);
            this.ux_buttons.TabIndex = 0;
            this.ux_noButton.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_noButton.Location = new System.Drawing.Point(384, 8);
            this.ux_noButton.Name = "ux_noButton";
            this.ux_noButton.Size = new System.Drawing.Size(80, 21);
            this.ux_noButton.TabIndex = 2;
            this.ux_noButton.Text = "&No";
            this.ux_noButton.Click += new System.EventHandler(this.NoButton_Click);
            this.ux_yesButton.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_yesButton.Location = new System.Drawing.Point(296, 8);
            this.ux_yesButton.Name = "ux_yesButton";
            this.ux_yesButton.Size = new System.Drawing.Size(80, 21);
            this.ux_yesButton.TabIndex = 1;
            this.ux_yesButton.Text = "&Yes";
            this.ux_yesButton.Click += new System.EventHandler(this.YesButton_Click);
            this.ux_cancelButton.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_cancelButton.Location = new System.Drawing.Point(208, 8);
            this.ux_cancelButton.Name = "ux_cancelButton";
            this.ux_cancelButton.Size = new System.Drawing.Size(80, 21);
            this.ux_cancelButton.TabIndex = 3;
            this.ux_cancelButton.Text = "C&ancel";
            this.ux_cancelButton.Click += new System.EventHandler(this.CancelButton_Click);
            this.ux_okButton.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_okButton.Location = new System.Drawing.Point(120, 8);
            this.ux_okButton.Name = "ux_okButton";
            this.ux_okButton.Size = new System.Drawing.Size(80, 21);
            this.ux_okButton.TabIndex = 0;
            this.ux_okButton.Text = "&OK";
            this.ux_okButton.Click += new System.EventHandler(this.OkButton_Click);
            this.ux_buildInfo.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.ux_buildInfo.Location = new System.Drawing.Point(8, 4);
            this.ux_buildInfo.Name = "ux_buildInfo";
            this.ux_buildInfo.Size = new System.Drawing.Size(192, 29);
            this.ux_buildInfo.TabIndex = 4;
            this.ux_buildInfo.Text = "Build info:";
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 14);
            this.ClientSize = new System.Drawing.Size(474, 335);
            this.Controls.Add(this.ux_rtf);
            this.Controls.Add(this.ux_buttons);
            this.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "RtfDialog";
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
            this.Text = "CAFE Model";
            this.ux_buttons.ResumeLayout(false);
            this.ResumeLayout(false);
        }
		#endregion
        #region 
        public static DialogResult ShowDialog(string caption, string text)
        {
            return ShowDialog(caption, text, PromptOption.Ok);
        }
        public static DialogResult ShowDialog(string caption, string text, PromptOption promptOption)
        {
            return ShowDialog(caption, text, promptOption, false);
        }
        public static DialogResult ShowDialog(string caption, string text, PromptOption promptOption, bool showBuildInfo)
        {
            RtfDialog dlg = new RtfDialog();
            dlg.Initialize(caption, text, promptOption, showBuildInfo);
            return dlg.ShowDialog();
        }
        public static DialogResult ShowDialogFromFile(string caption, string path)
        {
            return ShowDialogFromFile(caption, path, PromptOption.Ok);
        }
        public static DialogResult ShowDialogFromFile(string caption, string path, PromptOption promptOption)
        {
            return ShowDialogFromFile(caption, path, promptOption, false);
        }
        public static DialogResult ShowDialogFromFile(string caption, string path, PromptOption promptOption, bool showBuildInfo)
        {
            RtfDialog dlg = new RtfDialog();
            dlg.Initialize(caption, string.Empty, promptOption, showBuildInfo);
            dlg.ux_rtf.LoadFile(path, RichTextBoxStreamType.RichText);
            return dlg.ShowDialog();
        }
        #endregion
        void Initialize(string caption, string text, PromptOption promptOption, bool showBuildInfo)
        {
            this.Text = caption;
            this.ux_rtf.Text = text;
            switch (promptOption)
            {
                case PromptOption.OkCancel:
                    this.SetupButtons(true, true, false, false, this.ux_okButton, this.ux_cancelButton);
                    this.ux_okButton    .Left = 296;
                    this.ux_cancelButton.Left = 384;
                    break;
                case PromptOption.YesNo:
                    this.SetupButtons(false, false, true, true, this.ux_yesButton, this.ux_noButton);
                    this.ux_yesButton.Left = 296;
                    this.ux_noButton .Left = 384;
                    break;
                case PromptOption.YesNoCancel:
                    this.SetupButtons(false, true, true, true, this.ux_yesButton, this.ux_cancelButton);
                    this.ux_yesButton   .Left = 208;
                    this.ux_noButton    .Left = 296;
                    this.ux_cancelButton.Left = 384;
                    break;
                default:    
                    this.SetupButtons(true, false, false, false, this.ux_okButton, this.ux_okButton);
                    this.ux_okButton.Left = 384;
                    break;
            }
            if (showBuildInfo)
            {
                string version  = Application.ProductVersion;
                string timstamp = File.GetLastWriteTime(Application.ExecutablePath).ToString("M/dd/yy H:mm:ss");
                this.ux_buildInfo.Text = "CAFE Model Version:  " + version + "\nBuild Date:  " + timstamp;
            }
            this.ux_buildInfo.Visible = showBuildInfo;
        }
        void SetupButtons(bool okVisbile, bool cancelVisbile, bool yesVisbile, bool noVisbile,
            Button acceptButton, Button cancelButton)
        {
            this.ux_okButton    .Visible = okVisbile;
            this.ux_cancelButton.Visible = cancelVisbile;
            this.ux_yesButton   .Visible = yesVisbile;
            this.ux_noButton    .Visible = noVisbile;
            this.AcceptButton = acceptButton;
            this.CancelButton = cancelButton;
        }
        void OkButton_Click(object sender, System.EventArgs e)
        {
            DialogResult = DialogResult.OK;
        }
        void CancelButton_Click(object sender, System.EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
        }
        void YesButton_Click(object sender, System.EventArgs e)
        {
            DialogResult = DialogResult.Yes;
        }
        void NoButton_Click(object sender, System.EventArgs e)
        {
            DialogResult = DialogResult.No;
        }
        #endregion
        #region 
        #region 
        System.Windows.Forms.RichTextBox ux_rtf;
        System.Windows.Forms.Panel ux_buttons;
        System.Windows.Forms.Button ux_okButton;
        System.Windows.Forms.Button ux_cancelButton;
        System.Windows.Forms.Button ux_yesButton;
        System.Windows.Forms.Button ux_noButton;
        System.Windows.Forms.Label ux_buildInfo;
        #endregion
        #endregion
	}
}

