using System;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public class ManufacturerDescription : ICloneable
    {
        #region 
        public ManufacturerDescription()
            : base()
        {
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public ManufacturerDescription Clone()
        {
            ManufacturerDescription md = new ManufacturerDescription();
            md.Code                     = this.Code;
            md.Name                     = this.Name;
            md.CostAllocationStrategy   = this.CostAllocationStrategy;
            md.AverageMY2002LtCw        = this.AverageMY2002LtCw;
            md.DiscountRate             = this.DiscountRate;
            md.Optimize                 = this.Optimize;
            md.WillingToPayFines        = (bool  [])Global.CloneArray(this.WillingToPayFines , typeof(bool  ));
            md.AvailableCreditsDA       = (double[])Global.CloneArray(this.AvailableCreditsDA, typeof(double));
            md.AvailableCreditsIA       = (double[])Global.CloneArray(this.AvailableCreditsIA, typeof(double));
            md.AvailableCreditsLT       = (double[])Global.CloneArray(this.AvailableCreditsLT, typeof(double));
            md.CreditsApplyToBaseline   = this.CreditsApplyToBaseline;
            md.AvailableACCreditsDA     = (double[])Global.CloneArray(this.AvailableACCreditsDA, typeof(double));
            md.AvailableACCreditsIA     = (double[])Global.CloneArray(this.AvailableACCreditsIA, typeof(double));
            md.AvailableACCreditsLT     = (double[])Global.CloneArray(this.AvailableACCreditsLT, typeof(double));
            md.ACCreditsApplyToBaseline = this.ACCreditsApplyToBaseline;
            return md;
        }
        #endregion
        #endregion
        #region 
        public int Code;
        public string Name;
        public int CostAllocationStrategy;
        public double AverageMY2002LtCw;
        public double DiscountRate;
        public bool Optimize;
        public bool[] WillingToPayFines;
        public double[] AvailableCreditsDA;
        public double[] AvailableCreditsIA;
        public double[] AvailableCreditsLT;
        public bool CreditsApplyToBaseline;
        public double[] AvailableACCreditsDA;
        public double[] AvailableACCreditsIA;
        public double[] AvailableACCreditsLT;
        public bool ACCreditsApplyToBaseline;
        #endregion
    }
}

