using System;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public struct RCBoolean
    {
        #region 
        static RCBoolean()
        {
            RCBoolean.False = new RCBoolean(false);
            RCBoolean.True  = new RCBoolean(true);
        }
        RCBoolean(bool value)
        {
            this.Unregulated  = value;
            this.DomesticAuto = value;
            this.ImportedAuto = value;
            this.LightTruck   = value;
        }
        #endregion
        #region 
        public override string ToString()
        {
            return "{Dom Auto="  + this.DomesticAuto.ToString() +
                ", Imp Auto="    + this.ImportedAuto.ToString() +
                ", Light Truck=" + this.LightTruck  .ToString() +
                ", Unregulated=" + this.Unregulated .ToString() + "}";
        }
        public bool Value(RegulatoryClass regClass)
        {
            return
                (regClass == RegulatoryClass.DomesticAuto) ? this.DomesticAuto :
                (regClass == RegulatoryClass.ImportedAuto) ? this.ImportedAuto :
                (regClass == RegulatoryClass.LightTruck  ) ? this.LightTruck   : this.Unregulated;
        }
        public void Clear()
        {
            this.Unregulated  = false;
            this.DomesticAuto = false;
            this.ImportedAuto = false;
            this.LightTruck   = false;
        }
        #endregion
        #region 
        public bool this[RegulatoryClass regClass]
        {
            get { return this.Value(regClass); }
            set
            {
                if      (regClass == RegulatoryClass.DomesticAuto) { this.DomesticAuto = value; }
                else if (regClass == RegulatoryClass.ImportedAuto) { this.ImportedAuto = value; }
                else if (regClass == RegulatoryClass.LightTruck  ) { this.LightTruck   = value; }
                else if (regClass == RegulatoryClass.Unregulated ) { this.Unregulated  = value; }
                else { throw new ArgumentException("The value specified does not represent a valid regulatory class."); }
            }
        }
        public bool IsTrue     { get { return this.DomesticAuto && this.ImportedAuto && this.LightTruck; } }
        public bool IsTrueAll  { get { return this.Unregulated && this.IsTrue; } }
        public bool IsFalse    { get { return !(this.DomesticAuto || this.ImportedAuto || this.LightTruck); } }
        public bool IsFalseAll { get { return this.IsFalse && !this.Unregulated; } }
        #endregion
        #region 
        public static readonly RCBoolean False;
        public static readonly RCBoolean True;
        public bool Unregulated;
        public bool DomesticAuto;
        public bool ImportedAuto;
        public bool LightTruck;
        #endregion
    }
}

