using System;
using System.Runtime.Serialization;
using Volpe.Cafe.IO;
namespace Volpe.Cafe.Settings
{
    [Serializable]
    public struct OperatingModes : ISerializable
    {
        #region 
        OperatingModes(SerializationInfo info, StreamingContext context)
        {
            this.ModelingApproach                  = (ModelingApproach)info.GetValue("ModelingApproach", typeof(ModelingApproach));
            this.AutoToggleApproach                = info.GetBoolean("AutoToggleApproach");
            this.NoFines                           = info.GetBoolean("NoFines");
            this.MultiYearModeling                 = info.GetBoolean("MultiYearModeling");
            this.MultiYearStartYear                = info.GetInt32  ("MultiYearStartYear");
            this.SplitSharedEngsOrTrns             = info.GetBoolean("SplitSharedEngsOrTrns");
            this.SplitConflictingEngsOrTrns        = info.GetBoolean("SplitConflictingEngsOrTrns");
            this.SkipSharedEngsOrTrns              = info.GetBoolean("SkipSharedEngsOrTrns");
            this.SkipConflictingEngsOrTrns         = info.GetBoolean("SkipConflictingEngsOrTrns");
            this.TechnologyFuelEstimates           = (Estimates)info.GetValue("TechnologyFuelEstimates", typeof(Estimates));
            this.TechnologyCostEstimates           = (Estimates)info.GetValue("TechnologyCostEstimates", typeof(Estimates));
            this.Backfill                          = info.GetBoolean("Backfill");
            this.ClipTechImprovements              = info.GetBoolean("ClipTechImprovements");
            this.ClipTechCosts                     = info.GetBoolean("ClipTechCosts");
            this.ReserveTechnologiesIfInCompliance = info.GetBoolean("ReserveTechnologiesIfInCompliance");
            this.IgnoreYearAvailable               = info.GetBoolean("IgnoreYearAvailable");
            this.IgnorePhaseIn                     = info.GetBoolean("IgnorePhaseIn");
            this.IgnoreRefreshRedesign             = info.GetBoolean("IgnoreRefreshRedesign");
            this.IgnoreWeightInMsApplication       = info.GetBoolean("IgnoreWeightInMsApplication");
            this.ShutoffEngineTechsAfterHEV        = info.GetBoolean("ShutoffEngineTechsAfterHEV");
            this.ShutoffTransmissionTechsAfterHEV  = info.GetBoolean("ShutoffTransmissionTechsAfterHEV");
            this.ShutoffElecTechsAfterHEV          = info.GetBoolean("ShutoffElecTechsAfterHEV");
            this.GenerateExtendedLogFiles          = info.GetBoolean("GenerateExtendedLogFiles");
            this.FuelPriceEstimates                = (Estimates)info.GetValue("FuelPriceEstimates", typeof(Estimates));
            this.Multithread                       = info.GetBoolean("Multithread");
            try
            {
                this.CO2Estimates = (CO2Estimates)info.GetValue("CO2Estimates", typeof(CO2Estimates));
            }
            catch
            {
                this.CO2Estimates = CO2Estimates.Average;
            }
        }
        #endregion
        #region 
        #region 
        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            info.AddValue("ModelingApproach"                 , this.ModelingApproach);
            info.AddValue("AutoToggleApproach"               , this.AutoToggleApproach);
            info.AddValue("NoFines"                          , this.NoFines);
            info.AddValue("MultiYearModeling"                , this.MultiYearModeling);
            info.AddValue("MultiYearStartYear"               , this.MultiYearStartYear);
            info.AddValue("SplitSharedEngsOrTrns"            , this.SplitSharedEngsOrTrns);
            info.AddValue("SplitConflictingEngsOrTrns"       , this.SplitConflictingEngsOrTrns);
            info.AddValue("SkipSharedEngsOrTrns"             , this.SkipSharedEngsOrTrns);
            info.AddValue("SkipConflictingEngsOrTrns"        , this.SkipConflictingEngsOrTrns);
            info.AddValue("TechnologyFuelEstimates"          , this.TechnologyFuelEstimates);
            info.AddValue("TechnologyCostEstimates"          , this.TechnologyCostEstimates);
            info.AddValue("Backfill"                         , this.Backfill);
            info.AddValue("ClipTechImprovements"             , this.ClipTechImprovements);
            info.AddValue("ClipTechCosts"                    , this.ClipTechCosts);
            info.AddValue("ReserveTechnologiesIfInCompliance", this.ReserveTechnologiesIfInCompliance);
            info.AddValue("IgnoreYearAvailable"              , this.IgnoreYearAvailable);
            info.AddValue("IgnorePhaseIn"                    , this.IgnorePhaseIn);
            info.AddValue("IgnoreRefreshRedesign"            , this.IgnoreRefreshRedesign);
            info.AddValue("IgnoreWeightInMsApplication"      , this.IgnoreWeightInMsApplication);
            info.AddValue("ShutoffEngineTechsAfterHEV"       , this.ShutoffEngineTechsAfterHEV);
            info.AddValue("ShutoffTransmissionTechsAfterHEV" , this.ShutoffTransmissionTechsAfterHEV);
            info.AddValue("ShutoffElecTechsAfterHEV"         , this.ShutoffElecTechsAfterHEV);
            info.AddValue("GenerateExtendedLogFiles"         , this.GenerateExtendedLogFiles);
            info.AddValue("FuelPriceEstimates"               , this.FuelPriceEstimates);
            info.AddValue("CO2Estimates"                     , this.CO2Estimates);
            info.AddValue("Multithread"                      , this.Multithread);
        }
        #endregion
        internal void WriteSummaryLog(LogWriter writer)
        {
            if (writer.Summary == null) { return; }
            string outStr = "--- Operating Modes ---" +
                "\n  ModelingApproach="                  + this.ModelingApproach                  +
                "\n  AutoToggleApproach="                + this.AutoToggleApproach                +
                "\n  NoFines="                           + this.NoFines                           +
                "\n  MultiYearModeling="                 + this.MultiYearModeling                 +
                "\n  MultiYearStartYear="                + this.MultiYearStartYear                +
                "\n  SplitSharedEngsOrTrns="             + this.SplitSharedEngsOrTrns             +
                "\n  SplitConflictingEngsOrTrns="        + this.SplitConflictingEngsOrTrns        +
                "\n  SkipSharedEngsOrTrns="              + this.SkipSharedEngsOrTrns              +
                "\n  SkipConflictingEngsOrTrns="         + this.SkipConflictingEngsOrTrns         +
                "\n  TechnologyFuelEstimates="           + this.TechnologyFuelEstimates           +
                "\n  TechnologyCostEstimates="           + this.TechnologyCostEstimates           +
                "\n  Backfill="                          + this.Backfill                          +
                "\n  ClipTechImprovements="              + this.ClipTechImprovements              +
                "\n  ClipTechCosts="                     + this.ClipTechCosts                     +
                "\n  ReserveTechnologiesIfInCompliance=" + this.ReserveTechnologiesIfInCompliance +
                "\n  IgnoreYearAvailable="               + this.IgnoreYearAvailable               +
                "\n  IgnorePhaseIn="                     + this.IgnorePhaseIn                     +
                "\n  IgnoreRefreshRedesign="             + this.IgnoreRefreshRedesign             +
                "\n  IgnoreWeightInMsApplication="       + this.IgnoreWeightInMsApplication       +
                "\n  ShutoffEngineTechsAfterHEV="        + this.ShutoffEngineTechsAfterHEV        +
                "\n  ShutoffTransmissionTechsAfterHEV="  + this.ShutoffTransmissionTechsAfterHEV  +
                "\n  ShutoffElecTechsAfterHEV="          + this.ShutoffElecTechsAfterHEV          +
                "\n  GenerateExtendedLogFiles="          + this.GenerateExtendedLogFiles          +
                "\n  FuelPriceEstimates="                + this.FuelPriceEstimates                +
                "\n  CO2Estimates="                      + this.CO2Estimates                      +
                "\n  Multithread="                       + this.Multithread;
            writer.Summary.WriteLine(outStr + "\n");
        }
        #endregion
        #region 
        #region 
        public ModelingApproach ModelingApproach;
        public bool AutoToggleApproach;
        public bool NoFines;
        public bool MultiYearModeling;
        public int MultiYearStartYear;
        public bool SplitSharedEngsOrTrns;
        public bool SplitConflictingEngsOrTrns;
        public bool SkipSharedEngsOrTrns;
        public bool SkipConflictingEngsOrTrns;
        #endregion
        #region 
        public Estimates TechnologyFuelEstimates;
        public Estimates TechnologyCostEstimates;
        public bool Backfill;
        public bool ClipTechImprovements;
        public bool ClipTechCosts;
        public bool ReserveTechnologiesIfInCompliance;
        #endregion
        #region 
        public bool IgnoreYearAvailable;
        public bool IgnorePhaseIn;
        public bool IgnoreRefreshRedesign;
        public bool IgnoreWeightInMsApplication;
        public bool ShutoffEngineTechsAfterHEV;
        public bool ShutoffTransmissionTechsAfterHEV;
        public bool ShutoffElecTechsAfterHEV;
        #endregion
        #region 
        public bool GenerateExtendedLogFiles;
        #endregion
        #region 
        public Estimates FuelPriceEstimates;
        public CO2Estimates CO2Estimates;
        public bool Multithread;
        #endregion
        #endregion
    }
}

