using Excel = Microsoft.Office.Interop.Excel;
using System;
using System.Drawing;
namespace Volpe.Utils
{
    [Serializable]
    public class XlFont
    {
        #region 
        public XlFont(string name)
            : this(name, 10)
        {
        }
        public XlFont(string name, int size)
            : this(name, size, false, false, false)
        {
        }
        public XlFont(string name, int size, bool italic, bool bold, bool underline)
            : this(name, size, italic, bold, underline, XlColor.Automatic)
        {
        }
        public XlFont(string name, int size, XlColor color)
            : this(name, size, false, false, false, color)
        {
        }
        public XlFont(string name, int size, bool italic, bool bold, bool underline, XlColor color)
            : this(name, size, italic, bold, underline, color, false, false, false)
        {
        }
        public XlFont(string name, int size, bool italic, bool bold, bool underline,
            XlColor color, bool strikethrough, bool subscript, bool superscript)
        {
            this._name          = name;
            this._size          = size;
            this._italic        = italic;
            this._bold          = bold;
            this._underline     = underline;
            this._color         = color;
            this._strikethrough = strikethrough;
            this._subscript     = subscript;
            this._superscript   = (!subscript && superscript);
        }
        public XlFont(Font font)
            : this(font, XlColor.Automatic, false, false)
        {
        }
        public XlFont(Font font, XlColor color)
            : this(font, color, false, false)
        {
        }
        public XlFont(Font font, bool subscript, bool superscript)
            : this(font, XlColor.Automatic, subscript, superscript)
        {
        }
        public XlFont(Font font, XlColor color, bool subscript, bool superscript)
            : this(font.Name, (int)font.SizeInPoints, font.Italic, font.Bold, font.Underline, color, font.Strikeout, subscript,
                superscript)
        {
        }
        #endregion
        #region 
        public override string ToString()
        {
            return "{Name="        + this._name +
                ", Size="          + this._size +
                ", Italic="        + this._italic +
                ", Bold="          + this._bold +
                ", Underline="     + this._underline +
                ", Color="         + this._color +
                ", Strikethrough=" + this._strikethrough +
                ", Subscript="     + this._subscript +
                ", Superscript="   + this._superscript + "}";
        }
        #endregion
        #region 
        public string  Name          { get { return this._name; } }
        public int     Size          { get { return this._size; } }
        public bool    Italic        { get { return this._italic; } }
        public bool    Bold          { get { return this._bold; } }
        public bool    Underline     { get { return this._underline; } }
        public XlColor Color         { get { return this._color; } }
        public bool    Strikethrough { get { return this._strikethrough; } }
        public bool    Subscript     { get { return this._subscript; } }
        public bool    Superscript   { get { return this._superscript; } }
        #endregion
        #region 
        private string  _name;
        private int     _size;
        private bool    _italic;
        private bool    _bold;
        private bool    _underline;
        private XlColor _color;
        private bool    _strikethrough;
        private bool    _subscript;
        private bool    _superscript;
        #endregion
    }
}

