using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Windows.Forms;
using Volpe.Cafe.Settings;
namespace Volpe.Cafe.Ui.Panels
{
	public class OutputPanel : Volpe.Cafe.Ui.Panels.CafeUserControl
	{
        #region 
        public OutputPanel()
        {
            this.InitializeComponent();
            this.PostInitialize();
        }
        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }
        #endregion
        #region 
        #region 
        void InitializeComponent()
        {
            this.ux_outputPathLabel = new System.Windows.Forms.Label();
            this.ux_outputPath = new System.Windows.Forms.TextBox();
            this.ux_outputPathBrowse = new System.Windows.Forms.Button();
            this.ux_encryptionPanel = new System.Windows.Forms.Panel();
            this.ux_outputPasswordLabel3 = new System.Windows.Forms.Label();
            this.ux_useStrongEncryption = new System.Windows.Forms.CheckBox();
            this.ux_outputPasswordLabel2 = new System.Windows.Forms.Label();
            this.ux_outputPasswordVerfiy = new System.Windows.Forms.TextBox();
            this.ux_outputPasswordLabel1 = new System.Windows.Forms.Label();
            this.ux_outputPassword = new System.Windows.Forms.TextBox();
            this.ux_encryptOutput = new System.Windows.Forms.RadioButton();
            this.ux_doNotEncryptOutput = new System.Windows.Forms.RadioButton();
            this.ux_encryptionLabel = new System.Windows.Forms.Label();
            this.ux_generateReportsLabel = new System.Windows.Forms.Label();
            this.ux_generateReportsPanel = new System.Windows.Forms.Panel();
            this.ux_reportOptimizedIndustry = new System.Windows.Forms.CheckBox();
            this.ux_reportEA = new System.Windows.Forms.CheckBox();
            this.ux_reportEffects = new System.Windows.Forms.CheckBox();
            this.ux_reportScenarioSummary = new System.Windows.Forms.CheckBox();
            this.ux_reportVehicles = new System.Windows.Forms.CheckBox();
            this.ux_reportManufacturers = new System.Windows.Forms.CheckBox();
            this.ux_reportIndustry = new System.Windows.Forms.CheckBox();
            this.ux_encryptionPanel.SuspendLayout();
            this.ux_generateReportsPanel.SuspendLayout();
            this.SuspendLayout();
            this.ux_outputPathLabel.Location = new System.Drawing.Point(8, 8);
            this.ux_outputPathLabel.Name = "ux_outputPathLabel";
            this.ux_outputPathLabel.Size = new System.Drawing.Size(328, 16);
            this.ux_outputPathLabel.TabIndex = 0;
            this.ux_outputPathLabel.Text = "Please specify where you would like to save the model outputs:";
            this.ux_outputPath.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_outputPath.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_outputPath.Location = new System.Drawing.Point(8, 24);
            this.ux_outputPath.Name = "ux_outputPath";
            this.ux_outputPath.Size = new System.Drawing.Size(303, 21);
            this.ux_outputPath.TabIndex = 1;
            this.ux_outputPath.Text = "";
            this.ux_outputPathBrowse.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_outputPathBrowse.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_outputPathBrowse.Location = new System.Drawing.Point(312, 24);
            this.ux_outputPathBrowse.Name = "ux_outputPathBrowse";
            this.ux_outputPathBrowse.Size = new System.Drawing.Size(80, 21);
            this.ux_outputPathBrowse.TabIndex = 2;
            this.ux_outputPathBrowse.Text = "Browse";
            this.ux_encryptionPanel.Controls.Add(this.ux_outputPasswordLabel3);
            this.ux_encryptionPanel.Controls.Add(this.ux_useStrongEncryption);
            this.ux_encryptionPanel.Controls.Add(this.ux_outputPasswordLabel2);
            this.ux_encryptionPanel.Controls.Add(this.ux_outputPasswordVerfiy);
            this.ux_encryptionPanel.Controls.Add(this.ux_outputPasswordLabel1);
            this.ux_encryptionPanel.Controls.Add(this.ux_outputPassword);
            this.ux_encryptionPanel.Controls.Add(this.ux_encryptOutput);
            this.ux_encryptionPanel.Controls.Add(this.ux_doNotEncryptOutput);
            this.ux_encryptionPanel.Location = new System.Drawing.Point(8, 60);
            this.ux_encryptionPanel.Name = "ux_encryptionPanel";
            this.ux_encryptionPanel.Size = new System.Drawing.Size(368, 112);
            this.ux_encryptionPanel.TabIndex = 4;
            this.ux_outputPasswordLabel3.Enabled = false;
            this.ux_outputPasswordLabel3.ForeColor = System.Drawing.Color.DarkRed;
            this.ux_outputPasswordLabel3.Location = new System.Drawing.Point(24, 80);
            this.ux_outputPasswordLabel3.Name = "ux_outputPasswordLabel3";
            this.ux_outputPasswordLabel3.Size = new System.Drawing.Size(344, 32);
            this.ux_outputPasswordLabel3.TabIndex = 7;
            this.ux_outputPasswordLabel3.Text = "Note:  Only Excel reports are password protected; the log files are not currently" +
                " encrypted.";
            this.ux_useStrongEncryption.Enabled = false;
            this.ux_useStrongEncryption.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_useStrongEncryption.Location = new System.Drawing.Point(24, 64);
            this.ux_useStrongEncryption.Name = "ux_useStrongEncryption";
            this.ux_useStrongEncryption.Size = new System.Drawing.Size(264, 16);
            this.ux_useStrongEncryption.TabIndex = 6;
            this.ux_useStrongEncryption.Text = "Use strong encryption for improved protection.";
            this.ux_outputPasswordLabel2.Enabled = false;
            this.ux_outputPasswordLabel2.Location = new System.Drawing.Point(360, 44);
            this.ux_outputPasswordLabel2.Name = "ux_outputPasswordLabel2";
            this.ux_outputPasswordLabel2.Size = new System.Drawing.Size(8, 16);
            this.ux_outputPasswordLabel2.TabIndex = 5;
            this.ux_outputPasswordLabel2.Text = ")";
            this.ux_outputPasswordVerfiy.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_outputPasswordVerfiy.Enabled = false;
            this.ux_outputPasswordVerfiy.Location = new System.Drawing.Point(238, 40);
            this.ux_outputPasswordVerfiy.Name = "ux_outputPasswordVerfiy";
            this.ux_outputPasswordVerfiy.PasswordChar = '*';
            this.ux_outputPasswordVerfiy.Size = new System.Drawing.Size(120, 21);
            this.ux_outputPasswordVerfiy.TabIndex = 4;
            this.ux_outputPasswordVerfiy.Text = "";
            this.ux_outputPasswordLabel1.Enabled = false;
            this.ux_outputPasswordLabel1.Location = new System.Drawing.Point(148, 44);
            this.ux_outputPasswordLabel1.Name = "ux_outputPasswordLabel1";
            this.ux_outputPasswordLabel1.Size = new System.Drawing.Size(96, 16);
            this.ux_outputPasswordLabel1.TabIndex = 3;
            this.ux_outputPasswordLabel1.Text = "(verify password:";
            this.ux_outputPassword.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_outputPassword.Enabled = false;
            this.ux_outputPassword.Location = new System.Drawing.Point(24, 40);
            this.ux_outputPassword.Name = "ux_outputPassword";
            this.ux_outputPassword.PasswordChar = '*';
            this.ux_outputPassword.Size = new System.Drawing.Size(120, 21);
            this.ux_outputPassword.TabIndex = 2;
            this.ux_outputPassword.Text = "";
            this.ux_encryptOutput.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_encryptOutput.Location = new System.Drawing.Point(8, 24);
            this.ux_encryptOutput.Name = "ux_encryptOutput";
            this.ux_encryptOutput.Size = new System.Drawing.Size(360, 16);
            this.ux_encryptOutput.TabIndex = 1;
            this.ux_encryptOutput.Text = "Password protect the model outputs using the specified password:";
            this.ux_doNotEncryptOutput.Checked = true;
            this.ux_doNotEncryptOutput.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_doNotEncryptOutput.Location = new System.Drawing.Point(8, 8);
            this.ux_doNotEncryptOutput.Name = "ux_doNotEncryptOutput";
            this.ux_doNotEncryptOutput.Size = new System.Drawing.Size(248, 16);
            this.ux_doNotEncryptOutput.TabIndex = 0;
            this.ux_doNotEncryptOutput.TabStop = true;
            this.ux_doNotEncryptOutput.Text = "Do not password protect the model outputs,";
            this.ux_encryptionLabel.Location = new System.Drawing.Point(8, 52);
            this.ux_encryptionLabel.Name = "ux_encryptionLabel";
            this.ux_encryptionLabel.Size = new System.Drawing.Size(304, 16);
            this.ux_encryptionLabel.TabIndex = 3;
            this.ux_encryptionLabel.Text = "Would you like the model to password protect the outputs?";
            this.ux_generateReportsLabel.Location = new System.Drawing.Point(8, 176);
            this.ux_generateReportsLabel.Name = "ux_generateReportsLabel";
            this.ux_generateReportsLabel.Size = new System.Drawing.Size(304, 16);
            this.ux_generateReportsLabel.TabIndex = 5;
            this.ux_generateReportsLabel.Text = "Which Excel reports would you like the model to generate?";
            this.ux_generateReportsPanel.Controls.Add(this.ux_reportOptimizedIndustry);
            this.ux_generateReportsPanel.Controls.Add(this.ux_reportEA);
            this.ux_generateReportsPanel.Controls.Add(this.ux_reportEffects);
            this.ux_generateReportsPanel.Controls.Add(this.ux_reportScenarioSummary);
            this.ux_generateReportsPanel.Controls.Add(this.ux_reportVehicles);
            this.ux_generateReportsPanel.Controls.Add(this.ux_reportManufacturers);
            this.ux_generateReportsPanel.Controls.Add(this.ux_reportIndustry);
            this.ux_generateReportsPanel.Location = new System.Drawing.Point(8, 184);
            this.ux_generateReportsPanel.Name = "ux_generateReportsPanel";
            this.ux_generateReportsPanel.Size = new System.Drawing.Size(368, 128);
            this.ux_generateReportsPanel.TabIndex = 6;
            this.ux_reportOptimizedIndustry.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_reportOptimizedIndustry.Location = new System.Drawing.Point(8, 104);
            this.ux_reportOptimizedIndustry.Name = "ux_reportOptimizedIndustry";
            this.ux_reportOptimizedIndustry.Size = new System.Drawing.Size(160, 16);
            this.ux_reportOptimizedIndustry.TabIndex = 6;
            this.ux_reportOptimizedIndustry.Text = "Optimized Industry Report";
            this.ux_reportEA.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_reportEA.Location = new System.Drawing.Point(8, 88);
            this.ux_reportEA.Name = "ux_reportEA";
            this.ux_reportEA.Size = new System.Drawing.Size(200, 16);
            this.ux_reportEA.TabIndex = 5;
            this.ux_reportEA.Text = "Environmental Assessment Report";
            this.ux_reportEffects.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_reportEffects.Location = new System.Drawing.Point(8, 72);
            this.ux_reportEffects.Name = "ux_reportEffects";
            this.ux_reportEffects.Size = new System.Drawing.Size(96, 16);
            this.ux_reportEffects.TabIndex = 4;
            this.ux_reportEffects.Text = "Effects Report";
            this.ux_reportScenarioSummary.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_reportScenarioSummary.Location = new System.Drawing.Point(8, 56);
            this.ux_reportScenarioSummary.Name = "ux_reportScenarioSummary";
            this.ux_reportScenarioSummary.Size = new System.Drawing.Size(160, 16);
            this.ux_reportScenarioSummary.TabIndex = 3;
            this.ux_reportScenarioSummary.Text = "Scenario Summary Report";
            this.ux_reportVehicles.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_reportVehicles.Location = new System.Drawing.Point(8, 40);
            this.ux_reportVehicles.Name = "ux_reportVehicles";
            this.ux_reportVehicles.Size = new System.Drawing.Size(104, 16);
            this.ux_reportVehicles.TabIndex = 2;
            this.ux_reportVehicles.Text = "Vehicles Report";
            this.ux_reportManufacturers.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_reportManufacturers.Location = new System.Drawing.Point(8, 24);
            this.ux_reportManufacturers.Name = "ux_reportManufacturers";
            this.ux_reportManufacturers.Size = new System.Drawing.Size(136, 16);
            this.ux_reportManufacturers.TabIndex = 1;
            this.ux_reportManufacturers.Text = "Manufacturers Report";
            this.ux_reportIndustry.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_reportIndustry.Location = new System.Drawing.Point(8, 8);
            this.ux_reportIndustry.Name = "ux_reportIndustry";
            this.ux_reportIndustry.Size = new System.Drawing.Size(104, 16);
            this.ux_reportIndustry.TabIndex = 0;
            this.ux_reportIndustry.Text = "Industry Report";
            this.Controls.Add(this.ux_generateReportsLabel);
            this.Controls.Add(this.ux_generateReportsPanel);
            this.Controls.Add(this.ux_encryptionLabel);
            this.Controls.Add(this.ux_encryptionPanel);
            this.Controls.Add(this.ux_outputPathBrowse);
            this.Controls.Add(this.ux_outputPath);
            this.Controls.Add(this.ux_outputPathLabel);
            this.Name = "OutputPanel";
            this.Size = new System.Drawing.Size(400, 320);
            this.ux_encryptionPanel.ResumeLayout(false);
            this.ux_generateReportsPanel.ResumeLayout(false);
            this.ResumeLayout(false);
        }
        #endregion
        void PostInitialize()
        {
            this.InitializeTextBoxDragDrop(this.ux_outputPath);
            this.AutoInitializeCheckChangesDetector(this.Controls);
            this.ux_outputPath          .TextChanged    += new EventHandler(this.OutputPath_TextChanged);
            this.ux_outputPath          .EnabledChanged += new EventHandler(this.OutputPath_EnabledChanged);
            this.ux_outputPathBrowse    .Click          += new EventHandler(this.OutputPathBrowse_Click);
            this.ux_encryptOutput       .CheckedChanged += new EventHandler(this.EncryptOutput_CheckedChanged);
            this.ux_outputPassword      .TextChanged    += new EventHandler(this.OutputPassword_TextChanged);
            this.ux_outputPasswordVerfiy.TextChanged    += new EventHandler(this.OutputPassword_TextChanged);
            this.ux_outputPassword      .EnabledChanged += new EventHandler(this.OutputPassword_EnabledChanged);
            this.ux_outputPasswordVerfiy.EnabledChanged += new EventHandler(this.OutputPassword_EnabledChanged);
            this.ux_outputPath.Text = "";
        }
        void OutputPath_TextChanged(object sender, EventArgs e)
        {
            TextBox tb = (TextBox)sender;
            if (Directory.Exists(tb.Text))
            {
                bool outputPathChanged = !this.CompareDirectories(this._outputSettings.OutputPath, tb.Text);
                tb.ForeColor = (this._visualTracking && outputPathChanged) ? this._visualTrackingColor : Control.DefaultForeColor;
                tb.BackColor = Color.Empty;
                this._messages.RemoveMessage(tb);
            }
            else
            {
                if (tb.Text.Trim() == string.Empty)
                {
                    this._messages.AddMessage("Please select a location where you would like to save the model outputs.", Color.Red, tb);
                }
                else
                {
                    this._messages.AddMessage("The specified location for model outputs does not exist on disk.", Color.Red, tb);
                }
                tb.BackColor = Color.Honeydew;
                tb.ForeColor = Color.Red;
            }
        }
        void OutputPath_EnabledChanged(object sender, EventArgs e)
        {
            TextBox tb = (TextBox)sender;
            if (tb.Enabled) { this.OutputPath_TextChanged(sender, e); }
            else            { this._messages.RemoveMessage(sender); tb.BackColor = Color.Empty; }
        }
        void OutputPathBrowse_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog dlg = new FolderBrowserDialog();
            dlg.Description         = "Please select a location where you would like to save the model outputs:";
            dlg.SelectedPath        = this.ux_outputPath.Text;
            dlg.ShowNewFolderButton = true;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                this.ux_outputPath.Text = dlg.SelectedPath;
            }
        }
        bool CompareDirectories(string path1, string path2)
        {
            if (Directory.Exists(path1)) { path1 = Path.GetFullPath(path1.TrimEnd('\\')); }
            if (Directory.Exists(path2)) { path2 = Path.GetFullPath(path2.TrimEnd('\\')); }
            return (path1 == path2);
        }
        void EncryptOutput_CheckedChanged(object sender, EventArgs e)
        {
            bool enabled = this.ux_encryptOutput.Checked;
            this.ux_outputPassword      .Enabled = enabled;
            this.ux_outputPasswordVerfiy.Enabled = enabled;
            this.ux_useStrongEncryption .Enabled = enabled;
            this.ux_outputPasswordLabel1.Enabled = enabled;
            this.ux_outputPasswordLabel2.Enabled = enabled;
            this.ux_outputPasswordLabel3.Enabled = enabled;
        }
        void OutputPassword_TextChanged(object sender, EventArgs e)
        {
            string pw1 = this.ux_outputPassword.Text;
            string pw2 = this.ux_outputPasswordVerfiy.Text;
            string errMessage = string.Empty;
            if (pw1 == "" && pw2 == "")
            {
                errMessage = "Please enter an output password and verify.";
            }
            else if (pw1 == pw2)
            {
                bool  pwChanged = pw1 != this._outputSettings.OutputPassword;
                Color foreColor = (pwChanged && this._visualTracking) ? this._visualTrackingColor : Control.DefaultForeColor;
                this.ux_outputPassword      .ForeColor = foreColor;
                this.ux_outputPassword      .BackColor = Color.Empty;
                this.ux_outputPasswordVerfiy.ForeColor = foreColor;
                this.ux_outputPasswordVerfiy.BackColor = Color.Empty;
                this._messages.RemoveMessage(this.ux_outputPassword);
            }
            else
            {
                errMessage = "The specified output and \"verify\" passwords do not match.";
            }
            if (errMessage != string.Empty)
            {
                this._messages.AddMessage(errMessage, Color.Red, this.ux_outputPassword);
                this.ux_outputPassword      .BackColor = Color.Honeydew;
                this.ux_outputPassword      .ForeColor = Color.Red;
                this.ux_outputPasswordVerfiy.BackColor = Color.Honeydew;
                this.ux_outputPasswordVerfiy.ForeColor = Color.Red;
            }
        }
        void OutputPassword_EnabledChanged(object sender, EventArgs e)
        {
            TextBox tb = (TextBox)sender;
            if (tb.Enabled) { this.OutputPassword_TextChanged(sender, e); }
            else
            {
                this._messages.RemoveMessage(this.ux_outputPassword);
                this.ux_outputPassword      .BackColor = Color.Empty;
                this.ux_outputPasswordVerfiy.BackColor = Color.Empty;
            }
        }
        void InitializeTextBoxDragDrop(params TextBox[] values)
        {
            for (int i = 0; i < values.Length; i++)
            {
                values[i].AllowDrop = true;
                values[i].DragEnter += new DragEventHandler(this.OutputPanel_DragEnter);
                values[i].DragDrop  += new DragEventHandler(this.OutputPanel_DragDrop);
            }
        }
        void OutputPanel_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop, false))
            {
                e.Effect = DragDropEffects.All;
            }
        }
        void OutputPanel_DragDrop(object sender, DragEventArgs e)
        {
            TextBox tb = (TextBox)sender;
            string[] files = (string[])e.Data.GetData(DataFormats.FileDrop, false);
            for (int i = 0; i < files.Length; i++)
            {
                if (Directory.Exists(files[i])) { tb.Text = files[i]; break; }
            }
        }
        public void SetInitialState(OutputSettings outputSettings)
        {
            this._outputSettings = outputSettings;
            this.ux_outputPath          .Text    =  this._outputSettings.OutputPath;
            this.ux_doNotEncryptOutput  .Checked = !this._outputSettings.EncryptOutput;
            this.ux_encryptOutput       .Checked =  this._outputSettings.EncryptOutput;
            this.ux_outputPassword      .Text    =  this._outputSettings.OutputPassword;
            this.ux_outputPasswordVerfiy.Text    =  this._outputSettings.OutputPassword;
            this.ux_useStrongEncryption .Checked =  this._outputSettings.UseStrongEncryption;
            if (this._outputSettings.GenerateReports)
            {
                this.ux_reportIndustry         .Checked = this._outputSettings.ReportIndustry;
                this.ux_reportManufacturers    .Checked = this._outputSettings.ReportManufacturers;
                this.ux_reportVehicles         .Checked = this._outputSettings.ReportVehicles;
                this.ux_reportScenarioSummary  .Checked = this._outputSettings.ReportScenarioSummary;
                this.ux_reportEffects          .Checked = this._outputSettings.ReportEffects;
                this.ux_reportEA               .Checked = this._outputSettings.ReportEnvironmentalAssessment;
                this.ux_reportOptimizedIndustry.Checked = this._outputSettings.ReportOptimizedIndustry;
            }
            base.SaveChanges();
        }
        public override void SaveChanges()
        {
            if (this.SettingsChanged)
            {   
                this._outputSettings.OutputPath    = this.ux_outputPath.Text;
                this._outputSettings.EncryptOutput = this.ux_encryptOutput.Checked;
                if (this._outputSettings.EncryptOutput)
                {
                    this._outputSettings.OutputPassword  = this.ux_outputPassword.Text;
                }
                this._outputSettings.UseStrongEncryption = this.ux_useStrongEncryption.Checked;
                this._outputSettings.GenerateReports               = true;
                this._outputSettings.ReportIndustry                = this.ux_reportIndustry.Checked;
                this._outputSettings.ReportManufacturers           = this.ux_reportManufacturers.Checked;
                this._outputSettings.ReportVehicles                = this.ux_reportVehicles.Checked;
                this._outputSettings.ReportScenarioSummary         = this.ux_reportScenarioSummary.Checked;
                this._outputSettings.ReportEffects                 = this.ux_reportEffects.Checked;
                this._outputSettings.ReportEnvironmentalAssessment = this.ux_reportEA.Checked;
                this._outputSettings.ReportOptimizedIndustry       = this.ux_reportOptimizedIndustry.Checked;
                base.SaveChanges();
                this.PostSave();
            }
        }
        void PostSave()
        {
            if (this._visualTracking)
            {   
                this.ux_outputPath          .ForeColor = Control.DefaultForeColor;
                this.ux_outputPath          .BackColor = Color.Empty;
                this.ux_outputPassword      .ForeColor = Control.DefaultForeColor;
                this.ux_outputPassword      .BackColor = Color.Empty;
                this.ux_outputPasswordVerfiy.ForeColor = Control.DefaultForeColor;
                this.ux_outputPasswordVerfiy.BackColor = Color.Empty;
            }
        }
        #endregion
        #region 
        [Browsable(false)]
        public OutputSettings OutputSettings { get { return this._outputSettings; } }
        [Browsable(false)]
        public override bool SettingsChanged
        {
            get
            {
                if (!Directory.Exists(this.ux_outputPath.Text)) { return false; }
                if (this.ux_encryptOutput.Checked &&
                    (this.ux_outputPassword.Text == string.Empty ||
                     this.ux_outputPassword.Text != this.ux_outputPasswordVerfiy.Text)) { return false; }
                return base.SettingsChanged ||
                    !this.CompareDirectories(this._outputSettings.OutputPath, this.ux_outputPath.Text) ||
                    (this.ux_encryptOutput.Checked && this.ux_outputPassword.Text != this._outputSettings.OutputPassword);
            }
        }
        #endregion
        #region 
        #region 
        System.Windows.Forms.Label ux_outputPathLabel;
        System.Windows.Forms.TextBox ux_outputPath;
        System.Windows.Forms.Button ux_outputPathBrowse;
        System.Windows.Forms.Label ux_encryptionLabel;
        System.Windows.Forms.Panel ux_encryptionPanel;
        System.Windows.Forms.RadioButton ux_doNotEncryptOutput;
        System.Windows.Forms.RadioButton ux_encryptOutput;
        System.Windows.Forms.TextBox ux_outputPassword;
        System.Windows.Forms.TextBox ux_outputPasswordVerfiy;
        System.Windows.Forms.CheckBox ux_useStrongEncryption;
        System.Windows.Forms.Label ux_outputPasswordLabel1;
        System.Windows.Forms.Label ux_outputPasswordLabel2;
        System.Windows.Forms.Label ux_outputPasswordLabel3;
        System.Windows.Forms.Label ux_generateReportsLabel;
        System.Windows.Forms.Panel ux_generateReportsPanel;
        System.Windows.Forms.CheckBox ux_reportIndustry;
        System.Windows.Forms.CheckBox ux_reportManufacturers;
        System.Windows.Forms.CheckBox ux_reportVehicles;
        System.Windows.Forms.CheckBox ux_reportScenarioSummary;
        System.Windows.Forms.CheckBox ux_reportEffects;
        System.Windows.Forms.CheckBox ux_reportEA;
        System.Windows.Forms.CheckBox ux_reportOptimizedIndustry;
        #endregion
        OutputSettings _outputSettings;
        #endregion
    }
}

