using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using Volpe.Cafe;
using Volpe.Cafe.Settings;
namespace Volpe.Cafe.Ui.Panels
{
	public class ParamsOverridesPanel : Volpe.Cafe.Ui.Panels.CafeUserControl
	{
        #region 
		public ParamsOverridesPanel()
		{
			this.InitializeComponent();
            this.PostInitialize();
        }
		protected override void Dispose(bool disposing)
		{
			base.Dispose(disposing);
		}
        #endregion
        #region 
		#region 
        void InitializeComponent()
		{
            this.ux_consumerBenefits = new System.Windows.Forms.TextBox();
            this.ux_scaleConsumerBenefits = new System.Windows.Forms.CheckBox();
            this.ux_titleLabel = new System.Windows.Forms.Label();
            this.ux_overrideFuelPriceEstimates = new System.Windows.Forms.CheckBox();
            this.ux_overrideReboundEffect = new System.Windows.Forms.CheckBox();
            this.ux_overrideDiscountRate = new System.Windows.Forms.CheckBox();
            this.ux_overrideMilitarySecurity = new System.Windows.Forms.CheckBox();
            this.ux_overrideCO2Estimates = new System.Windows.Forms.CheckBox();
            this.ux_fuelPriceEstimatesPanel = new System.Windows.Forms.Panel();
            this.ux_highFuelPriceEstimates = new System.Windows.Forms.RadioButton();
            this.ux_refFuelPriceEstimates = new System.Windows.Forms.RadioButton();
            this.ux_lowFuelPriceEstimates = new System.Windows.Forms.RadioButton();
            this.ux_reboundEffect = new System.Windows.Forms.TextBox();
            this.ux_discountRate = new System.Windows.Forms.TextBox();
            this.ux_militarySecurity = new System.Windows.Forms.TextBox();
            this.ux_vehicleTravelTimeValue = new System.Windows.Forms.TextBox();
            this.ux_overrideVehicleTravelTimeValue = new System.Windows.Forms.CheckBox();
            this.ux_co2EstimatesPanel = new System.Windows.Forms.Panel();
            this.ux_veryHighCO2Estimates = new System.Windows.Forms.RadioButton();
            this.ux_highCO2Estimates = new System.Windows.Forms.RadioButton();
            this.ux_averageCO2Estimates = new System.Windows.Forms.RadioButton();
            this.ux_lowCO2Estimates = new System.Windows.Forms.RadioButton();
            this.ux_fuelPriceEstimatesPanel.SuspendLayout();
            this.ux_co2EstimatesPanel.SuspendLayout();
            this.SuspendLayout();
            this.ux_consumerBenefits.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_consumerBenefits.Enabled = false;
            this.ux_consumerBenefits.Location = new System.Drawing.Point(304, 168);
            this.ux_consumerBenefits.MaxLength = 4;
            this.ux_consumerBenefits.Multiline = true;
            this.ux_consumerBenefits.Name = "ux_consumerBenefits";
            this.ux_consumerBenefits.Size = new System.Drawing.Size(56, 18);
            this.ux_consumerBenefits.TabIndex = 14;
            this.ux_consumerBenefits.Text = "";
            this.ux_consumerBenefits.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.ux_scaleConsumerBenefits.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_scaleConsumerBenefits.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_scaleConsumerBenefits.Location = new System.Drawing.Point(16, 168);
            this.ux_scaleConsumerBenefits.Name = "ux_scaleConsumerBenefits";
            this.ux_scaleConsumerBenefits.Size = new System.Drawing.Size(344, 16);
            this.ux_scaleConsumerBenefits.TabIndex = 13;
            this.ux_scaleConsumerBenefits.Text = "Scale Consumer Benefits During Effects Calculations by:";
            this.ux_titleLabel.Location = new System.Drawing.Point(8, 8);
            this.ux_titleLabel.Name = "ux_titleLabel";
            this.ux_titleLabel.Size = new System.Drawing.Size(328, 16);
            this.ux_titleLabel.TabIndex = 0;
            this.ux_titleLabel.Text = "Which parameters would you like to override from the input file?";
            this.ux_overrideFuelPriceEstimates.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_overrideFuelPriceEstimates.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_overrideFuelPriceEstimates.Location = new System.Drawing.Point(16, 24);
            this.ux_overrideFuelPriceEstimates.Name = "ux_overrideFuelPriceEstimates";
            this.ux_overrideFuelPriceEstimates.Size = new System.Drawing.Size(328, 16);
            this.ux_overrideFuelPriceEstimates.TabIndex = 1;
            this.ux_overrideFuelPriceEstimates.Text = "Override Fuel Price Estimates:";
            this.ux_overrideReboundEffect.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_overrideReboundEffect.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_overrideReboundEffect.Location = new System.Drawing.Point(16, 72);
            this.ux_overrideReboundEffect.Name = "ux_overrideReboundEffect";
            this.ux_overrideReboundEffect.Size = new System.Drawing.Size(280, 16);
            this.ux_overrideReboundEffect.TabIndex = 5;
            this.ux_overrideReboundEffect.Text = "Override Rebound Effect:";
            this.ux_overrideDiscountRate.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_overrideDiscountRate.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_overrideDiscountRate.Location = new System.Drawing.Point(16, 96);
            this.ux_overrideDiscountRate.Name = "ux_overrideDiscountRate";
            this.ux_overrideDiscountRate.Size = new System.Drawing.Size(280, 16);
            this.ux_overrideDiscountRate.TabIndex = 7;
            this.ux_overrideDiscountRate.Text = "Override Discount Rate:";
            this.ux_overrideMilitarySecurity.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_overrideMilitarySecurity.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_overrideMilitarySecurity.Location = new System.Drawing.Point(16, 144);
            this.ux_overrideMilitarySecurity.Name = "ux_overrideMilitarySecurity";
            this.ux_overrideMilitarySecurity.Size = new System.Drawing.Size(280, 16);
            this.ux_overrideMilitarySecurity.TabIndex = 11;
            this.ux_overrideMilitarySecurity.Text = "Override Military Security Cost:";
            this.ux_overrideCO2Estimates.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_overrideCO2Estimates.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_overrideCO2Estimates.Location = new System.Drawing.Point(16, 48);
            this.ux_overrideCO2Estimates.Name = "ux_overrideCO2Estimates";
            this.ux_overrideCO2Estimates.Size = new System.Drawing.Size(384, 16);
            this.ux_overrideCO2Estimates.TabIndex = 3;
            this.ux_overrideCO2Estimates.Text = "Override CO-2 Estimates:";
            this.ux_fuelPriceEstimatesPanel.Controls.Add(this.ux_highFuelPriceEstimates);
            this.ux_fuelPriceEstimatesPanel.Controls.Add(this.ux_refFuelPriceEstimates);
            this.ux_fuelPriceEstimatesPanel.Controls.Add(this.ux_lowFuelPriceEstimates);
            this.ux_fuelPriceEstimatesPanel.Enabled = false;
            this.ux_fuelPriceEstimatesPanel.Location = new System.Drawing.Point(184, 24);
            this.ux_fuelPriceEstimatesPanel.Name = "ux_fuelPriceEstimatesPanel";
            this.ux_fuelPriceEstimatesPanel.Size = new System.Drawing.Size(160, 16);
            this.ux_fuelPriceEstimatesPanel.TabIndex = 2;
            this.ux_highFuelPriceEstimates.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_highFuelPriceEstimates.Location = new System.Drawing.Point(112, 0);
            this.ux_highFuelPriceEstimates.Name = "ux_highFuelPriceEstimates";
            this.ux_highFuelPriceEstimates.Size = new System.Drawing.Size(48, 16);
            this.ux_highFuelPriceEstimates.TabIndex = 2;
            this.ux_highFuelPriceEstimates.Text = "High";
            this.ux_refFuelPriceEstimates.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_refFuelPriceEstimates.Location = new System.Drawing.Point(48, 0);
            this.ux_refFuelPriceEstimates.Name = "ux_refFuelPriceEstimates";
            this.ux_refFuelPriceEstimates.Size = new System.Drawing.Size(64, 16);
            this.ux_refFuelPriceEstimates.TabIndex = 1;
            this.ux_refFuelPriceEstimates.Text = "Average";
            this.ux_lowFuelPriceEstimates.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_lowFuelPriceEstimates.Location = new System.Drawing.Point(0, 0);
            this.ux_lowFuelPriceEstimates.Name = "ux_lowFuelPriceEstimates";
            this.ux_lowFuelPriceEstimates.Size = new System.Drawing.Size(48, 16);
            this.ux_lowFuelPriceEstimates.TabIndex = 0;
            this.ux_lowFuelPriceEstimates.Text = "Low";
            this.ux_reboundEffect.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_reboundEffect.Enabled = false;
            this.ux_reboundEffect.Location = new System.Drawing.Point(240, 72);
            this.ux_reboundEffect.MaxLength = 5;
            this.ux_reboundEffect.Multiline = true;
            this.ux_reboundEffect.Name = "ux_reboundEffect";
            this.ux_reboundEffect.Size = new System.Drawing.Size(56, 18);
            this.ux_reboundEffect.TabIndex = 6;
            this.ux_reboundEffect.Text = "";
            this.ux_reboundEffect.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.ux_discountRate.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_discountRate.Enabled = false;
            this.ux_discountRate.Location = new System.Drawing.Point(240, 96);
            this.ux_discountRate.MaxLength = 4;
            this.ux_discountRate.Multiline = true;
            this.ux_discountRate.Name = "ux_discountRate";
            this.ux_discountRate.Size = new System.Drawing.Size(56, 18);
            this.ux_discountRate.TabIndex = 8;
            this.ux_discountRate.Text = "";
            this.ux_discountRate.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.ux_militarySecurity.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_militarySecurity.Enabled = false;
            this.ux_militarySecurity.Location = new System.Drawing.Point(240, 144);
            this.ux_militarySecurity.MaxLength = 32;
            this.ux_militarySecurity.Multiline = true;
            this.ux_militarySecurity.Name = "ux_militarySecurity";
            this.ux_militarySecurity.Size = new System.Drawing.Size(56, 18);
            this.ux_militarySecurity.TabIndex = 12;
            this.ux_militarySecurity.Text = "";
            this.ux_militarySecurity.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.ux_vehicleTravelTimeValue.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_vehicleTravelTimeValue.Enabled = false;
            this.ux_vehicleTravelTimeValue.Location = new System.Drawing.Point(240, 120);
            this.ux_vehicleTravelTimeValue.MaxLength = 4;
            this.ux_vehicleTravelTimeValue.Multiline = true;
            this.ux_vehicleTravelTimeValue.Name = "ux_vehicleTravelTimeValue";
            this.ux_vehicleTravelTimeValue.Size = new System.Drawing.Size(56, 18);
            this.ux_vehicleTravelTimeValue.TabIndex = 10;
            this.ux_vehicleTravelTimeValue.Text = "";
            this.ux_vehicleTravelTimeValue.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.ux_overrideVehicleTravelTimeValue.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_overrideVehicleTravelTimeValue.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_overrideVehicleTravelTimeValue.Location = new System.Drawing.Point(16, 120);
            this.ux_overrideVehicleTravelTimeValue.Name = "ux_overrideVehicleTravelTimeValue";
            this.ux_overrideVehicleTravelTimeValue.Size = new System.Drawing.Size(280, 16);
            this.ux_overrideVehicleTravelTimeValue.TabIndex = 9;
            this.ux_overrideVehicleTravelTimeValue.Text = "Override Value of Travel Time per Vehicle:";
            this.ux_co2EstimatesPanel.Controls.Add(this.ux_veryHighCO2Estimates);
            this.ux_co2EstimatesPanel.Controls.Add(this.ux_highCO2Estimates);
            this.ux_co2EstimatesPanel.Controls.Add(this.ux_averageCO2Estimates);
            this.ux_co2EstimatesPanel.Controls.Add(this.ux_lowCO2Estimates);
            this.ux_co2EstimatesPanel.Enabled = false;
            this.ux_co2EstimatesPanel.Location = new System.Drawing.Point(184, 48);
            this.ux_co2EstimatesPanel.Name = "ux_co2EstimatesPanel";
            this.ux_co2EstimatesPanel.Size = new System.Drawing.Size(216, 16);
            this.ux_co2EstimatesPanel.TabIndex = 4;
            this.ux_veryHighCO2Estimates.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_veryHighCO2Estimates.Location = new System.Drawing.Point(160, 0);
            this.ux_veryHighCO2Estimates.Name = "ux_veryHighCO2Estimates";
            this.ux_veryHighCO2Estimates.Size = new System.Drawing.Size(56, 16);
            this.ux_veryHighCO2Estimates.TabIndex = 3;
            this.ux_veryHighCO2Estimates.Text = "V-High";
            this.ux_highCO2Estimates.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_highCO2Estimates.Location = new System.Drawing.Point(112, 0);
            this.ux_highCO2Estimates.Name = "ux_highCO2Estimates";
            this.ux_highCO2Estimates.Size = new System.Drawing.Size(48, 16);
            this.ux_highCO2Estimates.TabIndex = 2;
            this.ux_highCO2Estimates.Text = "High";
            this.ux_averageCO2Estimates.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_averageCO2Estimates.Location = new System.Drawing.Point(48, 0);
            this.ux_averageCO2Estimates.Name = "ux_averageCO2Estimates";
            this.ux_averageCO2Estimates.Size = new System.Drawing.Size(64, 16);
            this.ux_averageCO2Estimates.TabIndex = 1;
            this.ux_averageCO2Estimates.Text = "Average";
            this.ux_lowCO2Estimates.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_lowCO2Estimates.Location = new System.Drawing.Point(0, 0);
            this.ux_lowCO2Estimates.Name = "ux_lowCO2Estimates";
            this.ux_lowCO2Estimates.Size = new System.Drawing.Size(48, 16);
            this.ux_lowCO2Estimates.TabIndex = 0;
            this.ux_lowCO2Estimates.Text = "Low";
            this.Controls.Add(this.ux_co2EstimatesPanel);
            this.Controls.Add(this.ux_vehicleTravelTimeValue);
            this.Controls.Add(this.ux_overrideVehicleTravelTimeValue);
            this.Controls.Add(this.ux_militarySecurity);
            this.Controls.Add(this.ux_discountRate);
            this.Controls.Add(this.ux_reboundEffect);
            this.Controls.Add(this.ux_fuelPriceEstimatesPanel);
            this.Controls.Add(this.ux_overrideCO2Estimates);
            this.Controls.Add(this.ux_overrideMilitarySecurity);
            this.Controls.Add(this.ux_overrideDiscountRate);
            this.Controls.Add(this.ux_overrideReboundEffect);
            this.Controls.Add(this.ux_overrideFuelPriceEstimates);
            this.Controls.Add(this.ux_titleLabel);
            this.Controls.Add(this.ux_consumerBenefits);
            this.Controls.Add(this.ux_scaleConsumerBenefits);
            this.Name = "ParamsOverridesPanel";
            this.Size = new System.Drawing.Size(400, 200);
            this.ux_fuelPriceEstimatesPanel.ResumeLayout(false);
            this.ux_co2EstimatesPanel.ResumeLayout(false);
            this.ResumeLayout(false);
        }
		#endregion
        void PostInitialize()
        {
            this.AutoInitializeCheckChangesDetector(this.Controls);
            this.ux_overrideFuelPriceEstimates    .CheckedChanged += new EventHandler(this.OverrideFuelPriceEstimates_CheckedChanged);
            this.ux_overrideCO2Estimates          .CheckedChanged += new EventHandler(this.OverrideCO2Estimates_CheckedChanged);
            this.ux_overrideReboundEffect         .CheckedChanged += new EventHandler(this.OverrideReboundEffect_CheckedChanged);
            this.ux_overrideDiscountRate          .CheckedChanged += new EventHandler(this.OverrideDiscountRate_CheckedChanged);
            this.ux_overrideVehicleTravelTimeValue.CheckedChanged += new EventHandler(this.OverrideVehicleTravelTimeValue_CheckedChanged);
            this.ux_overrideMilitarySecurity      .CheckedChanged += new EventHandler(this.OverrideMilitarySecurity_CheckedChanged);
            this.ux_scaleConsumerBenefits         .CheckedChanged += new EventHandler(this.ScaleConsumerBenefits_CheckedChanged);
        }
        void OverrideFuelPriceEstimates_CheckedChanged(object sender, EventArgs e)
        {
            this.ux_fuelPriceEstimatesPanel.Enabled = this.ux_overrideFuelPriceEstimates.Checked;
        }
        void OverrideCO2Estimates_CheckedChanged(object sender, EventArgs e)
        {
            this.ux_co2EstimatesPanel.Enabled = this.ux_overrideCO2Estimates.Checked;
        }
        void OverrideReboundEffect_CheckedChanged(object sender, EventArgs e)
        {
            this.ux_reboundEffect.Enabled = this.ux_overrideReboundEffect.Checked;
        }
        void OverrideDiscountRate_CheckedChanged(object sender, EventArgs e)
        {
            this.ux_discountRate.Enabled = this.ux_overrideDiscountRate.Checked;
        }
        void OverrideVehicleTravelTimeValue_CheckedChanged(object sender, EventArgs e)
        {
            this.ux_vehicleTravelTimeValue.Enabled = this.ux_overrideVehicleTravelTimeValue.Checked;
        }
        void OverrideMilitarySecurity_CheckedChanged(object sender, EventArgs e)
        {
            this.ux_militarySecurity.Enabled = this.ux_overrideMilitarySecurity.Checked;
        }
        void ScaleConsumerBenefits_CheckedChanged(object sender, EventArgs e)
        {
            this.ux_consumerBenefits.Enabled = this.ux_scaleConsumerBenefits.Checked;
        }
        public void SetInitialState(ParametersOverrides paramsOverrides)
        {
            this._paramsOverrides = paramsOverrides;
            this.ux_overrideFuelPriceEstimates    .Checked = paramsOverrides.OverrideFuelPriceEstimates;
            this.ux_overrideCO2Estimates          .Checked = paramsOverrides.OverrideCO2Estimates;
            this.ux_overrideReboundEffect         .Checked = paramsOverrides.OverrideReboundEffect;
            this.ux_overrideDiscountRate          .Checked = paramsOverrides.OverrideDiscountRate;
            this.ux_overrideVehicleTravelTimeValue.Checked = paramsOverrides.OverrideVehicleTravelTimeValue;
            this.ux_overrideMilitarySecurity      .Checked = paramsOverrides.OverrideMilitarySecurity;
            this.ux_scaleConsumerBenefits         .Checked = paramsOverrides.ScaleConsumerBenefits;
            if      (paramsOverrides.FuelPriceEstimates == Estimates.Low  ) { this.ux_lowFuelPriceEstimates .Checked = true; }
            else if (paramsOverrides.FuelPriceEstimates == Estimates.High ) { this.ux_highFuelPriceEstimates.Checked = true; }
            else                                                            { this.ux_refFuelPriceEstimates .Checked = true; }
            if      (paramsOverrides.CO2Estimates == CO2Estimates.Low     ) { this.ux_lowCO2Estimates       .Checked = true; }
            else if (paramsOverrides.CO2Estimates == CO2Estimates.High    ) { this.ux_highCO2Estimates      .Checked = true; }
            else if (paramsOverrides.CO2Estimates == CO2Estimates.VeryHigh) { this.ux_veryHighCO2Estimates  .Checked = true; }
            else                                                            { this.ux_averageCO2Estimates   .Checked = true; }
            this.ux_reboundEffect         .Text = this._paramsOverrides.ReboundEffect         .ToString("0.00");
            this.ux_discountRate          .Text = this._paramsOverrides.DiscountRate          .ToString("0.00");
            this.ux_vehicleTravelTimeValue.Text = this._paramsOverrides.VehicleTravelTimeValue.ToString("0.00");
            this.ux_militarySecurity      .Text = this._paramsOverrides.MilitarySecurity      .ToString("0.00");
            this.ux_consumerBenefits      .Text = this._paramsOverrides.ConsumerBenefits      .ToString("0.00");
            this.RegisterNumericTextControl(this.ux_reboundEffect         , 0.00,      -1.00,       1.00, "The rebound effect should be between {MIN} and {MAX}."   , true, "0.00");
            this.RegisterNumericTextControl(this.ux_discountRate          , 0.00,       0.00,       1.00, "The discount rate should be between {MIN} and {MAX}."    , true, "0.00");
            this.RegisterNumericTextControl(this.ux_vehicleTravelTimeValue, 0.00, double.NaN, double.NaN, null                                                      , true, "0.00");
            this.RegisterNumericTextControl(this.ux_militarySecurity      , 0.00, double.NaN, double.NaN, null                                                      , true, "0.00");
            this.RegisterNumericTextControl(this.ux_consumerBenefits      , 0.00,       0.00,       1.00, "The consumer benefits should be between {MIN} and {MAX}.", true, "0.00");
            base.SaveChanges();
        }
        public override void SaveChanges()
        {
            if (this.SettingsChanged)
            {   
                this._paramsOverrides.OverrideFuelPriceEstimates     = this.ux_overrideFuelPriceEstimates    .Checked;
                this._paramsOverrides.OverrideReboundEffect          = this.ux_overrideReboundEffect         .Checked;
                this._paramsOverrides.OverrideDiscountRate           = this.ux_overrideDiscountRate          .Checked;
                this._paramsOverrides.OverrideVehicleTravelTimeValue = this.ux_overrideVehicleTravelTimeValue.Checked;
                this._paramsOverrides.OverrideMilitarySecurity       = this.ux_overrideMilitarySecurity      .Checked;
                this._paramsOverrides.OverrideCO2Estimates           = this.ux_overrideCO2Estimates          .Checked;
                this._paramsOverrides.ScaleConsumerBenefits          = this.ux_scaleConsumerBenefits         .Checked;
                this._paramsOverrides.FuelPriceEstimates =
                    (this.ux_lowFuelPriceEstimates .Checked) ? Estimates.Low  :
                    (this.ux_highFuelPriceEstimates.Checked) ? Estimates.High : Estimates.Average;
                this._paramsOverrides.CO2Estimates =
                    (this.ux_lowCO2Estimates       .Checked) ? CO2Estimates.Low      :
                    (this.ux_highCO2Estimates      .Checked) ? CO2Estimates.High     :
                    (this.ux_veryHighCO2Estimates  .Checked) ? CO2Estimates.VeryHigh : CO2Estimates.Average;
                this._paramsOverrides.ReboundEffect          = Global.GetDouble(this.ux_reboundEffect         .Text);
                this._paramsOverrides.DiscountRate           = Global.GetDouble(this.ux_discountRate          .Text);
                this._paramsOverrides.VehicleTravelTimeValue = Global.GetDouble(this.ux_vehicleTravelTimeValue.Text);
                this._paramsOverrides.MilitarySecurity       = Global.GetDouble(this.ux_militarySecurity      .Text);
                this._paramsOverrides.ConsumerBenefits       = Global.GetDouble(this.ux_consumerBenefits      .Text);
                base.SaveChanges();
            }
        }
        #endregion
        #region 
        [Browsable(false)]
        public ParametersOverrides ParametersOverrides { get { return this._paramsOverrides; } }
        #endregion
        #region 
        #region 
        private System.Windows.Forms.Label ux_titleLabel;
        private System.Windows.Forms.CheckBox ux_overrideFuelPriceEstimates;
        private System.Windows.Forms.CheckBox ux_overrideCO2Estimates;
        private System.Windows.Forms.CheckBox ux_overrideReboundEffect;
        private System.Windows.Forms.CheckBox ux_overrideDiscountRate;
        private System.Windows.Forms.CheckBox ux_overrideVehicleTravelTimeValue;
        private System.Windows.Forms.CheckBox ux_overrideMilitarySecurity;
        private System.Windows.Forms.CheckBox ux_scaleConsumerBenefits;
        private System.Windows.Forms.Panel ux_fuelPriceEstimatesPanel;
        private System.Windows.Forms.RadioButton ux_highFuelPriceEstimates;
        private System.Windows.Forms.RadioButton ux_refFuelPriceEstimates;
        private System.Windows.Forms.RadioButton ux_lowFuelPriceEstimates;
        private System.Windows.Forms.Panel ux_co2EstimatesPanel;
        private System.Windows.Forms.RadioButton ux_veryHighCO2Estimates;
        private System.Windows.Forms.RadioButton ux_highCO2Estimates;
        private System.Windows.Forms.RadioButton ux_averageCO2Estimates;
        private System.Windows.Forms.RadioButton ux_lowCO2Estimates;
        private System.Windows.Forms.TextBox ux_reboundEffect;
        private System.Windows.Forms.TextBox ux_discountRate;
        private System.Windows.Forms.TextBox ux_vehicleTravelTimeValue;
        private System.Windows.Forms.TextBox ux_militarySecurity;
        private System.Windows.Forms.TextBox ux_consumerBenefits;
        #endregion
        ParametersOverrides _paramsOverrides;
        #endregion
    }
}

