using System;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public struct RCInt32
    {
        #region 
        static RCInt32()
        {
            RCInt32.Zero = new RCInt32(0);
            RCInt32.One  = new RCInt32(1);
        }
        RCInt32(int value)
            : this(value, value, value, value)
        {
        }
        RCInt32(int unregulated, int domesticAuto, int importedAuto, int lightTruck)
        {
            this.Unregulated  = unregulated;
            this.DomesticAuto = domesticAuto;
            this.ImportedAuto = importedAuto;
            this.LightTruck   = lightTruck;
        }
        #endregion
        #region 
        #region 
        public static RCInt32 operator +(RCInt32 value1, RCInt32 value2)
        {
            return new RCInt32(value1.Unregulated + value2.Unregulated, value1.DomesticAuto + value2.DomesticAuto,
                value1.ImportedAuto + value2.ImportedAuto, value1.LightTruck + value2.LightTruck);
        }
        public static RCInt32 operator +(RCInt32 value1, int value2)
        {
            return value1 + new RCInt32(value2);
        }
        public static RCInt32 operator +(int value1, RCInt32 value2)
        {
            return new RCInt32(value1) + value2;
        }
        public static RCInt32 operator -(RCInt32 value1, RCInt32 value2)
        {
            return new RCInt32(value1.Unregulated - value2.Unregulated, value1.DomesticAuto - value2.DomesticAuto,
                value1.ImportedAuto - value2.ImportedAuto, value1.LightTruck - value2.LightTruck);
        }
        public static RCInt32 operator -(RCInt32 value1, int value2)
        {
            return value1 - new RCInt32(value2);
        }
        public static RCInt32 operator -(int value1, RCInt32 value2)
        {
            return new RCInt32(value1) - value2;
        }
        public static RCInt32 operator *(RCInt32 value1, RCInt32 value2)
        {
            return new RCInt32(value1.Unregulated * value2.Unregulated, value1.DomesticAuto * value2.DomesticAuto,
                value1.ImportedAuto * value2.ImportedAuto, value1.LightTruck * value2.LightTruck);
        }
        public static RCInt32 operator *(RCInt32 value1, int value2)
        {
            return value1 * new RCInt32(value2);
        }
        public static RCInt32 operator *(int value1, RCInt32 value2)
        {
            return new RCInt32(value1) * value2;
        }
        public static RCInt32 operator /(RCInt32 value1, RCInt32 value2)
        {
            return new RCInt32(value1.Unregulated / value2.Unregulated, value1.DomesticAuto / value2.DomesticAuto,
                value1.ImportedAuto / value2.ImportedAuto, value1.LightTruck / value2.LightTruck);
        }
        public static RCInt32 operator /(RCInt32 value1, int value2)
        {
            return value1 / new RCInt32(value2);
        }
        public static RCInt32 operator /(int value1, RCInt32 value2)
        {
            return new RCInt32(value1) / value2;
        }
        public static RCInt32 operator +(RCInt32 value)
        {
            return RCInt32.Zero + value;
        }
        public static RCInt32 operator -(RCInt32 value)
        {
            return RCInt32.Zero - value;
        }
        public static RCInt32 operator ++(RCInt32 value)
        {
            return value + RCInt32.One;
        }
        public static RCInt32 operator --(RCInt32 value)
        {
            return value - RCInt32.One;
        }
        public static bool operator ==(RCInt32 value1, RCInt32 value2)
        {
            return value1.Equals(value2);
        }
        public static bool operator !=(RCInt32 value1, RCInt32 value2)
        {
            return !value1.Equals(value2);
        }
        #endregion
        public override string ToString()
        {
            return "{Dom Auto="  + this.DomesticAuto.ToString() +
                ", Imp Auto="    + this.ImportedAuto.ToString() +
                ", Light Truck=" + this.LightTruck  .ToString() +
                ", Unregulated=" + this.Unregulated .ToString() + "}";
        }
        public string ToString(string format)
        {
            return "{Dom Auto="  + this.DomesticAuto.ToString(format) +
                ", Imp Auto="    + this.ImportedAuto.ToString(format) +
                ", Light Truck=" + this.LightTruck  .ToString(format) +
                ", Unregulated=" + this.Unregulated .ToString(format) + "}";
        }
        public override int GetHashCode()
        {
            return this.DomesticAuto.GetHashCode() ^ this.ImportedAuto.GetHashCode() ^ this.LightTruck.GetHashCode() ^
                this.Unregulated.GetHashCode();
        }
        public override bool Equals(object obj)
        {
            if (obj is RCInt32) { return this.Equals((RCInt32)obj); }
            else                { return base.Equals(obj); }
        }
        public bool Equals(RCInt32 value)
        {
            return (this.DomesticAuto == value.DomesticAuto && this.ImportedAuto == value.ImportedAuto &&
                    this.LightTruck   == value.LightTruck   && this.Unregulated  == value.Unregulated);
        }
        public int Value(RegulatoryClass regClass)
        {
            return
                (regClass == RegulatoryClass.DomesticAuto) ? this.DomesticAuto :
                (regClass == RegulatoryClass.ImportedAuto) ? this.ImportedAuto :
                (regClass == RegulatoryClass.LightTruck)   ? this.LightTruck   : this.Unregulated;
        }
        public void Clear()
        {
            this.Unregulated  = 0;
            this.DomesticAuto = 0;
            this.ImportedAuto = 0;
            this.LightTruck   = 0;
        }
        #endregion
        #region 
        public int this[RegulatoryClass regClass]
        {
            get { return this.Value(regClass); }
            set
            {
                if      (regClass == RegulatoryClass.DomesticAuto) { this.DomesticAuto = value; }
                else if (regClass == RegulatoryClass.ImportedAuto) { this.ImportedAuto = value; }
                else if (regClass == RegulatoryClass.LightTruck  ) { this.LightTruck   = value; }
                else if (regClass == RegulatoryClass.Unregulated ) { this.Unregulated  = value; }
                else
                {
                    throw new ArgumentException("The value specified does not represent a valid regulatory class.");
                }
            }
        }
        public int Total { get { return this.DomesticAuto + this.ImportedAuto + this.LightTruck; } }
        public int TotalAll { get { return this.Total + this.Unregulated; } }
        #endregion
        #region 
        public static readonly RCInt32 Zero;
        public static readonly RCInt32 One;
        public int Unregulated;
        public int DomesticAuto;
        public int ImportedAuto;
        public int LightTruck;
        #endregion
    }
}

