using System;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public struct RCObject
    {
        #region 
        public override string ToString()
        {
            return "{Dom Auto="  + this.DomesticAuto.ToString() +
                ", Imp Auto="    + this.ImportedAuto.ToString() +
                ", Light Truck=" + this.LightTruck.ToString() +
                ", Unregulated=" + this.Unregulated.ToString() + "}";
        }
        public object Value(RegulatoryClass regClass)
        {
            return
                (regClass == RegulatoryClass.DomesticAuto) ? this.DomesticAuto :
                (regClass == RegulatoryClass.ImportedAuto) ? this.ImportedAuto :
                (regClass == RegulatoryClass.LightTruck  ) ? this.LightTruck   : this.Unregulated;
        }
        public void Clear()
        {
            this.Unregulated  = null;
            this.DomesticAuto = null;
            this.ImportedAuto = null;
            this.LightTruck   = null;
        }
        #endregion
        #region 
        public object this[RegulatoryClass regClass]
        {
            get { return this.Value(regClass); }
            set
            {
                if      (regClass == RegulatoryClass.DomesticAuto) { this.DomesticAuto = value; }
                else if (regClass == RegulatoryClass.ImportedAuto) { this.ImportedAuto = value; }
                else if (regClass == RegulatoryClass.LightTruck)   { this.LightTruck   = value; }
                else if (regClass == RegulatoryClass.Unregulated)  { this.Unregulated  = value; }
                else
                {
                    throw new ArgumentException("The value specified does not represent a valid regulatory class.");
                }
            }
        }
        #endregion
        #region 
        public object Unregulated;
        public object DomesticAuto;
        public object ImportedAuto;
        public object LightTruck;
        #endregion
    }
}

