using System;
namespace Volpe.Cafe
{
    [Serializable]
    public enum TechnologyOverride : int
    {
        None = 0,
        Used = 1,
        Skip = 2,
        Force = 3,
        Unused = 4
    }
    [Serializable]
    public enum Estimates : int
    {
        Low = 0,
        Average = 1,
        High = 2
    }
    public enum CO2Estimates : int
    {
        Low = 0,
        Average = 1,
        High = 2,
        VeryHigh = 3
    }
    [Serializable]
    public enum TechnologyType : int
    {
        Other = 0,
        Engine = 1,
        Elec = 2,
        Transmission = 3,
        Hybrid = 4,
        MSR = 5,
        DLR = 6,
        Aerodynamics = 7
    }
    [Serializable]
    public enum TechnologyComplexity : int
    {
        None = 0,
        Low = 1,
        Medium = 2,
        High = 3
    }
    [Serializable]
    public enum LearningType : int
    {
        None   = 0,
        Volume = 1,
        Time   = 2,
        Slope  = 3
    }
    [Serializable]
    public enum SynergyType : int
    {
        None = 0,
        Accounting = 1,
        Physical = 2
    }
    [Serializable]
    public enum VehicleType : int
    {
        None = 0,
        Domestic = 1,
        Imported = 2,
        PassengerAuto = 4,
        LightTruck = 8,
        HeavyLT = 16
    }
    [Serializable]
    public enum RegulatoryClass : int
    {
        Unregulated = 0,
        DomesticAuto = 1,
        ImportedAuto = 2,
        LightTruck = 3
    }
    [Serializable]
    public enum OptimizationType : int
    {
        Default = 0,
        PassengerAuto = 1,
        LightTruck = 2
    }
    [Serializable]
    public enum OptimizationMode : int
    {
        MaximumNetBenefits = 1,
        ZeroNetBeneftis = 2,
        Mbcr = 3,
        AverageOfPeaks = 4
    }
    [Serializable]
    public enum FunctionalFitMode : int
    {
        None = 0,
        Weighted   = 1,
        Unweighted = 2,
        Lsq = 4,
        Mad = 8,
        TsLsq = 16,
        TsMad = 32,
        Lnr = 1024,
        WeightedLsq = Weighted | Lsq,
        UnweightedLsq = Unweighted | Lsq,
        WeightedTsLsq = Weighted | TsLsq,
        UnweightedTsLsq = Unweighted | TsLsq,
        WeightedMad = Weighted | Mad,
        UnweightedMad = Unweighted | Mad,
        WeightedTsMad = Weighted | TsMad,
        UnweightedTsMad = Unweighted | TsMad,
        WeightedLnr = Weighted | Lnr,
        UnweightedLnr = Unweighted | Lnr
    }
    [Serializable]
    public enum CalibrationMode : int
    {
        Default = Weighted | Unweighted | ByPercent,
        Weighted = 1,
        Unweighted = 2,
        ByPercent = 4,
        ByFpOrCw = 8,
        ByVehicleType = 16,
        WeightedByPct = Weighted | ByPercent,
        UnweightedByPct = Unweighted | ByPercent,
        WeightedByFpCw = Weighted | ByFpOrCw,
        UnweightedByFpCw = Unweighted | ByFpOrCw,
        WeightedByVehicleType = Unweighted | ByVehicleType
    }
    [Serializable]
    public enum EqualizationMode : int
    {
        None = 0,
        Cost = 1,
        Standard = 2,
        FuelEconomy = 3,
        FuelSavings = 4,
        CO2 = 5
    }
    [Serializable]
    public enum Mobile6Class : int
    {
        None = 0,
        Ldgv = 1,
        Lddv = 2,
        Ldgt1 = 3,
        Lddt1 = 4,
        Ldgt2 = 5,
        Lddt2 = 6,
        Hdgv2b = 7,
        Hddv2b = 8
    }
    [Serializable]
    public enum TechnologyClass : int
    {
        None = 0,
        SubcompactPC = 1,
        SubcompactPerfPC = 2,
        CompactPC = 3,
        CompactPerfPC = 4,
        MidsizePC = 5,
        MidsizePerfPC = 6,
        LargePC = 7,
        LargePerfPC = 8,
        MinivanLT = 9,
        SmallLT = 10,
        MidsizeLT = 11,
        LargeLT = 12,
        Max = 12
    }
    [Serializable]
    public enum ModelingApproach : int
    {
        LowCostFirst = 0,
        EconomicEfficiency = 1
    }
}

