using System;
using Volpe.Cafe.Data;
namespace Volpe.Cafe.Model
{
    [Serializable]
    public class ModelingProgress : IModelingProgress
    {
        #region 
        public ModelingProgress(Scenario scen, ModelYear year, Manufacturer mfr)
            : this(scen, year, mfr, null)
        {
        }
        public ModelingProgress(Scenario scen, ModelYear year, Manufacturer mfr, object additionalInfo)
        {
            this._scen = scen;
            this._year = year;
            this._mfr  = mfr;
            this._additionalInfo = additionalInfo;
        }
        #endregion
        #region 
        public override string ToString()
        {
            if (this._scen == null)
            {
                return "No progress information available.";
            }
            else
            {   
                return
                    "Scenario: "       + ((this._scen == null) ? "N/A" : this._scen.ToString()) +
                    "\nModel Year: "   + ((this._year == null) ? "N/A" : this._year.ToString()) +
                    "\nManufacturer: " + ((this._mfr  == null) ? "N/A" : this._mfr .Description.Name);
            }
        }
        #endregion
        #region 
        #region 
        public virtual Scenario Scenario { get { return this._scen; } }
        public virtual ModelYear ModelYear { get { return this._year; } }
        public virtual Manufacturer Manufacturer { get { return this._mfr; } }
        public virtual object AdditionalInfo { get { return this._additionalInfo; } set { this._additionalInfo = value; } }
        #endregion
        #endregion
        #region 
        protected Scenario _scen;
        protected ModelYear _year;
        protected Manufacturer _mfr;
        protected object _additionalInfo;
        #endregion
    }
}

