using System;
using System.Runtime.Serialization;
using Volpe.Cafe.IO;
namespace Volpe.Cafe.Settings
{
    [Serializable]
    public struct ParametersOverrides : ISerializable
	{
        #region 
        ParametersOverrides(SerializationInfo info, StreamingContext context)
        {
            this.OverrideFuelPriceEstimates = info.GetBoolean("OverrideFuelPriceEstimates");
            this.OverrideReboundEffect      = info.GetBoolean("OverrideReboundEffect");
            this.OverrideDiscountRate       = info.GetBoolean("OverrideDiscountRate");
            this.OverrideMilitarySecurity   = info.GetBoolean("OverrideMilitarySecurity");
            this.ScaleConsumerBenefits      = info.GetBoolean("ScaleConsumerBenefits");
            this.FuelPriceEstimates         = (Estimates)info.GetValue("FuelPriceEstimates", typeof(Estimates));
            this.ReboundEffect              = info.GetDouble ("ReboundEffect");
            this.DiscountRate               = info.GetDouble ("DiscountRate");
            this.MilitarySecurity           = info.GetDouble ("MilitarySecurity");
            this.ConsumerBenefits           = info.GetDouble ("ConsumerBenefits");
            try
            {
                this.OverrideCO2Estimates           = info.GetBoolean("OverrideCO2Estimates");
                this.OverrideVehicleTravelTimeValue = info.GetBoolean("OverrideVehicleTravelTimeValue");
                this.CO2Estimates                   = (CO2Estimates)info.GetValue("CO2Estimates", typeof(CO2Estimates));
                this.VehicleTravelTimeValue         = info.GetDouble ("VehicleTravelTimeValue");
            }
            catch
            {
                this.OverrideCO2Estimates           = false;
                this.OverrideVehicleTravelTimeValue = false;
                this.CO2Estimates                   = CO2Estimates.Average;
                this.VehicleTravelTimeValue         = 24.64D;
            }
        }
        #endregion
        #region 
        #region 
        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            info.AddValue("OverrideFuelPriceEstimates"    , this.OverrideFuelPriceEstimates);
            info.AddValue("OverrideCO2Estimates"          , this.OverrideCO2Estimates);
            info.AddValue("OverrideReboundEffect"         , this.OverrideReboundEffect);
            info.AddValue("OverrideDiscountRate"          , this.OverrideDiscountRate);
            info.AddValue("OverrideVehicleTravelTimeValue", this.OverrideVehicleTravelTimeValue);
            info.AddValue("OverrideMilitarySecurity"      , this.OverrideMilitarySecurity);
            info.AddValue("ScaleConsumerBenefits"         , this.ScaleConsumerBenefits);
            info.AddValue("FuelPriceEstimates"            , this.FuelPriceEstimates);
            info.AddValue("CO2Estimates"                  , this.CO2Estimates);
            info.AddValue("ReboundEffect"                 , this.ReboundEffect);
            info.AddValue("DiscountRate"                  , this.DiscountRate);
            info.AddValue("VehicleTravelTimeValue"        , this.VehicleTravelTimeValue);
            info.AddValue("MilitarySecurity"              , this.MilitarySecurity);
            info.AddValue("ConsumerBenefits"              , this.ConsumerBenefits);
        }
        #endregion
        internal void WriteSummaryLog(LogWriter writer)
        {
            if (writer.Summary == null) { return; }
            string outStr = "--- Parameters Overrides ---" +
                "\n  OverrideFuelPriceEstimates="     + this.OverrideFuelPriceEstimates     + ((this.OverrideFuelPriceEstimates    ) ? " (" + this.FuelPriceEstimates     + ")" : string.Empty) +
                "\n  OverrideCO2Estimates="           + this.OverrideCO2Estimates           + ((this.OverrideCO2Estimates          ) ? " (" + this.CO2Estimates           + ")" : string.Empty) +
                "\n  OverrideReboundEffect="          + this.OverrideReboundEffect          + ((this.OverrideReboundEffect         ) ? " (" + this.ReboundEffect          + ")" : string.Empty) +
                "\n  OverrideDiscountRate="           + this.OverrideDiscountRate           + ((this.OverrideDiscountRate          ) ? " (" + this.DiscountRate           + ")" : string.Empty) +
                "\n  OverrideVehicleTravelTimeValue=" + this.OverrideVehicleTravelTimeValue + ((this.OverrideVehicleTravelTimeValue) ? " (" + this.VehicleTravelTimeValue + ")" : string.Empty) +
                "\n  OverrideMilitarySecurity="       + this.OverrideMilitarySecurity       + ((this.OverrideMilitarySecurity      ) ? " (" + this.MilitarySecurity       + ")" : string.Empty) +
                "\n  ScaleConsumerBenefits="          + this.ScaleConsumerBenefits          + ((this.ScaleConsumerBenefits         ) ? " (" + this.ConsumerBenefits       + ")" : string.Empty);
            writer.Summary.WriteLine(outStr + "\n");
        }
        #endregion
        #region 
        public bool OverrideFuelPriceEstimates;
        public bool OverrideCO2Estimates;
        public bool OverrideReboundEffect;
        public bool OverrideDiscountRate;
        public bool OverrideVehicleTravelTimeValue;
        public bool OverrideMilitarySecurity;
        public bool ScaleConsumerBenefits;
        public Estimates FuelPriceEstimates;
        public CO2Estimates CO2Estimates;
        public double ReboundEffect;
        public double DiscountRate;
        public double VehicleTravelTimeValue;
        public double MilitarySecurity;
        public double ConsumerBenefits;
        #endregion
    }
}

