using System;
using Volpe.Cafe.Data;
using TI = Volpe.Cafe.TechnologyIndexes;
namespace Volpe.Cafe
{
    [Serializable]
    public class Technology : ICloneable
    {
        #region 
        public Technology()
        {
            this.Attributes     = new TechnologyAttributesTable();
            this.ImprvSynergies = new TechnologySynergiesTable();
            this.CostSynergies  = new TechnologySynergiesTable();
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public Technology Clone()
        {
            Technology tech     = new Technology();
            tech.Index          = this.Index;
            tech.Name           = this.Name;
            tech.Abbr           = this.Abbr;
            tech.Removable      = this.Removable;
            tech.Type           = this.Type;
            tech.Complexity     = this.Complexity;
            tech.FcVariation    = this.FcVariation;
            tech.CostVariation  = this.CostVariation;
            tech.Attributes     = this.Attributes    .Clone();
            tech.ImprvSynergies = this.ImprvSynergies.Clone();
            tech.CostSynergies  = this.CostSynergies .Clone();
            tech.PhaseIn        = (double[])Global.CloneArray(this.PhaseIn, typeof(double));
            return tech;
        }
        #endregion
        #region 
        public double GetPhaseIn(ModelYear year)
        {
            return this.GetPhaseIn(year.Index);
        }
        public double GetPhaseIn(int yrIndex)
        {
            int maxYrIndex = this.PhaseIn.Length - 1;
            if (yrIndex > maxYrIndex)
            {
                if (maxYrIndex == 0)
                {   
                    return Math.Min(1.0, this.PhaseIn[0] * yrIndex);
                }
                else
                {   
                    return Math.Min(1.0, this.PhaseIn[maxYrIndex] +
                        (this.PhaseIn[maxYrIndex] - this.PhaseIn[maxYrIndex - 1]) * (yrIndex - maxYrIndex));
                }
            }
            else { return this.PhaseIn[yrIndex]; }
        }
        #endregion
        #endregion
        #region 
        public int Index;
        public string Name;
        public string Abbr;
        public bool Removable;
        public TechnologyType Type;
        public TechnologyComplexity Complexity;
        public double FcVariation;
        public double CostVariation;
        protected internal double[] PhaseIn;
        public TechnologyAttributesTable Attributes;
        public TechnologySynergiesTable ImprvSynergies;
        public TechnologySynergiesTable CostSynergies;
        #endregion
    }
}

