using System;
using System.Text;
using Volpe.Cafe.Collections;
namespace Volpe.Cafe
{
    [Serializable]
    public sealed class TechnologyIndexes
    {
        #region 
        static TechnologyIndexes()
        {
            TechnologyCount = TechAbbr.Length;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < TechnologyCount; i++)
            {
                sb.Append(TechAbbr[i]);
                sb.Append(',');
            }
            TechAbbrCSV = sb.ToString(0, sb.Length - 1);
        }
        #endregion
        #region 
        public static int GetIndex(string abbr)
        {
            for (int i = 0; i < TechnologyCount ; i++)
            {
                if (TechAbbr[i] == abbr) { return i; }
            }
            return -1;
        }
        public static string GetAbbr(int index)
        {
            if ((index < 0) || (index >= TechnologyCount)) { return string.Empty; }
            return TechAbbr[index];
        }
        public static bool IsDieselization(int index)
        {
            return ContainsIndex(index, Dieselization);
        }
        public static bool IsHybridization(int index)
        {
            return ContainsIndex(index, Hybridization);
        }
        public static bool IsMaterialSubstitution(int index)
        {
            return ContainsIndex(index, MaterialSubstitution);
        }
        public static bool IsConfigurationBased(int index)
        {
            return ContainsIndex(index, ConfigurationBased);
        }
        public static bool IsCylinderBased(int index)
        {
            return ContainsIndex(index, CylinderBased);
        }
        public static bool IsTiedToRedesign(int index)
        {
            return ContainsIndex(index, TiedToRedesign);
        }
        public static bool IsTiedToRefresh(int index)
        {
            return ContainsIndex(index, TiedToRefresh);
        }
        static bool ContainsIndex(int index, int[] list)
        {
            for (int i = 0; i < list.Length; i++)
            {
                if (list[i] == index) { return true; }
            }
            return false;
        }
        #endregion
        #region 
        #region 
        static readonly int[] Dieselization        = new int[] {DSLT , DSLC                                                 };
        static readonly int[] Hybridization        = new int[] {PSHEV, MHEV2, PHEV                                          };
        static readonly int[] MaterialSubstitution = new int[] {MS1  , MS2  , MS5                                           };
        static readonly int[] ConfigurationBased   = new int[] {CCPS , DVVLS, ICP  , DCP  , DVVLD, CVVL , CCPO, DVVLO, CDOHC};
        static readonly int[] CylinderBased        = new int[] {EFR  , DEACO, SGDI                                          };
        static readonly int[] TiedToRedesign = new int[] {DVVLS, DVVLD, CVVL, DVVLO, CDOHC, SGDI, TRBDS, EGRB, DSLT, DSLC, MAN6,
            CVT, NAUTO, DCTAM, MHEV, BISG, CISG, PSHEV, MHEV2, PHEV, MS2, MS5};
        static readonly int[] TiedToRefresh  = new int[] {EFR, CCPS, DEACS, ICP, DCP, DEACD, DEACO, CCPO, CBRST, EPS, IACC, IATC,
            ROLL, LDB, SAXU, SAXL, AERO, MS1};
        #endregion
        public static readonly string[] TechAbbr =
            new string[] { 
                             "LUB"  , "EFR"  , "CCPS" , "DVVLS", "DEACS", "ICP"  , "DCP"  , "DVVLD", "CVVL", "DEACD",
                             "DEACO", "CCPO" , "DVVLO", "CDOHC", "SGDI" , "CBRST", "TRBDS", "EGRB" , "DSLT", "DSLC" ,
                             "6MAN" , "IATC" , "CVT"  , "NAUTO", "DCTAM", "EPS"  , "IACC" , "MHEV" , "BISG", "CISG" ,
                             "PSHEV", "2MHEV", "PHEV" , "MS1"  , "MS2"  , "MS5"  , "ROLL" , "LDB" , "SAXU" , "SAXL" ,
                             "AERO"
                         };
        public static readonly string TechAbbrCSV;
        public static readonly int TechnologyCount;
        public const int LUB   =  0;
        public const int EFR   =  1;
        public const int CCPS  =  2;
        public const int DVVLS =  3;
        public const int DEACS =  4;
        public const int ICP   =  5;
        public const int DCP   =  6;
        public const int DVVLD =  7;
        public const int CVVL  =  8;
        public const int DEACD =  9;
        public const int DEACO = 10;
        public const int CCPO  = 11;
        public const int DVVLO = 12;
        public const int CDOHC = 13;
        public const int SGDI  = 14;
        public const int CBRST = 15;
        public const int TRBDS = 16;
        public const int EGRB  = 17;
        public const int DSLT  = 18;
        public const int DSLC  = 19;
        public const int MAN6  = 20;
        public const int IATC  = 21;
        public const int CVT   = 22;
        public const int NAUTO = 23;
        public const int DCTAM = 24;
        public const int EPS   = 25;
        public const int IACC  = 26;
        public const int MHEV  = 27;
        public const int BISG  = 28;
        public const int CISG  = 29;
        public const int PSHEV = 30;
        public const int MHEV2 = 31;
        public const int PHEV  = 32;
        public const int MS1   = 33;
        public const int MS2   = 34;
        public const int MS5   = 35;
        public const int ROLL  = 36;
        public const int LDB   = 37;
        public const int SAXU  = 38;
        public const int SAXL  = 39;
        public const int AERO  = 40;
        #endregion
    }
}

