using System;
namespace Volpe.Cafe
{
    [Serializable]
    public class TechnologySynergiesTable : ICloneable
    {
        #region 
        public TechnologySynergiesTable()
        {
            this._synergies = new TechnologySynergies[(int)TechnologyClass.Max];
            for (int i = 0 ; i < (int)TechnologyClass.Max; i++)
            {
                this._synergies[i] = new TechnologySynergies();
            }
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public TechnologySynergiesTable Clone()
        {
            TechnologySynergiesTable tst = new TechnologySynergiesTable();
            for (int i = 0; i < (int)TechnologyClass.Max; i++)
            {
                tst._synergies[i] = this._synergies[i].Clone();
            }
            return tst;
        }
        #endregion
        public TechnologySynergies[] ToArray()
        {
            return this._synergies;
        }
        #endregion
        #region 
        public TechnologySynergies this[TechnologyClass techClass]
        {
            get
            {
                int index = (int)techClass - 1;
                if (index < 0 || index >= (int)TechnologyClass.Max) { throw new ArgumentOutOfRangeException("techClass",
                    "The CAFE technology class specified is not a valid value."); }
                return this._synergies[index];
            }
            set
            {
                int index = (int)techClass - 1;
                if (index < 0 || index >= (int)TechnologyClass.Max) { throw new ArgumentOutOfRangeException("techClass",
                    "The CAFE technology class specified is not a valid value."); }
                this._synergies[index] = value;
            }
        }
        #endregion
        #region 
        private TechnologySynergies[] _synergies;
        #endregion
    }
}

