using System;
namespace Volpe.Utils
{
    [Serializable]
    public class XlChartFormat
    {
        #region 
        public XlChartFormat(XlChartType type, string name)
            : this(type, name, "", XlColor.Automatic, XlChartFormat.EmptySeries, null, null)
        {
        }
        public XlChartFormat(XlChartType type, string name, string title, XlColor plotColor,
            XlSeriesFormat seriesFormat, XlAxisFormat categoryAxisFormat, XlAxisFormat valuesAxisFormat)
            : this(type, name, title, plotColor, new XlSeriesFormat[] {seriesFormat}, categoryAxisFormat,
            valuesAxisFormat)
        {
        }
        public XlChartFormat(XlChartType type, string name, string title, XlColor plotColor,
            XlSeriesFormat[] seriesFormat, XlAxisFormat categoryAxisFormat, XlAxisFormat valuesAxisFormat)
        {
            this._type               = type;
            this._name               = name;
            this._title              = title;
            this._plotColor          = plotColor;
            this._seriesFormat       = seriesFormat;
            if (this._seriesFormat == null) { this._seriesFormat = new XlSeriesFormat[0]; }
            this._categoryAxisFormat = categoryAxisFormat;
            this._valuesAxisFormat   = valuesAxisFormat;
        }
        #endregion
        #region 
        public override string ToString()
        {
            string allSeries = "";
            int seriesCount = 0;
            if (this.HasSeries)
            {
                seriesCount = this._seriesFormat.Length;
                for (int i = 0; i < seriesCount; i++)
                {
                    allSeries += this._seriesFormat[i].ToString() + ", ";
                }
            }
            return "{IsValid="          + this.IsValid +
                ", HasSeries="          + this.HasSeries +
                ", Type="               + this._type +
                ", Name="               + this._name +
                ", Title="              + this._title +
                ", PlotColor="          + this._plotColor +
                ", Series[Count]="      + seriesCount +
                ", Series=Count:"       + seriesCount +
                ", Format:"             + allSeries.Remove(allSeries.Length - 2, 2) +
                ", CategoryAxisFormat=" + this._categoryAxisFormat +
                ", ValuesAxisFormat="   + this._valuesAxisFormat + "}";
        }
        public void AddSeries(XlSeriesFormat format)
        {
            int seriesCount = this._seriesFormat.Length;
            XlSeriesFormat[] sf = new XlSeriesFormat[seriesCount + 1];
            Array.Copy(this._seriesFormat, 0, sf, 0, seriesCount);
            sf[seriesCount] = format;
            this._seriesFormat = sf;
        }
        #endregion
        #region 
        public bool IsValid   { get { return (this._name != null) && (this._name.Trim() != "") && this.HasSeries; } }
        public bool HasSeries { get { return (this._seriesFormat != null) && (this._seriesFormat.Length > 0); } }
        public XlChartType Type
        {
            get { return this._type; }
            set { this._type = value; }
        }
        public string Name
        {
            get { return this._name; }
            set { this._name = value; }
        }
        public string Title
        {
            get { return this._title; }
            set { this._title = value; }
        }
        public XlColor PlotColor
        {
            get { return this._plotColor; }
            set { this._plotColor = value; }
        }
        public XlSeriesFormat[] SeriesFormat
        {
            get { return this._seriesFormat; }
        }
        public XlAxisFormat CategoryAxisFormat
        {
            get { return this._categoryAxisFormat; }
            set { this._categoryAxisFormat = value; }
        }
        public XlAxisFormat ValuesAxisFormat
        {
            get { return this._valuesAxisFormat; }
            set { this._valuesAxisFormat = value; }
        }
        #endregion
        #region 
        public static readonly XlSeriesFormat[] EmptySeries = new XlSeriesFormat[0];
        private XlChartType _type;
        private string _name;
        private string _title;
        private XlColor _plotColor;
        private XlSeriesFormat[] _seriesFormat;
        private XlAxisFormat _categoryAxisFormat;
        private XlAxisFormat _valuesAxisFormat;
        #endregion
    }
}

