#region << Using Directives >>
using System;
using Volpe.Cafe.Data;
#endregion
namespace Volpe.Cafe.Model
{
    public struct TechImpact
    {
        #region 
        public override string ToString()
        {
            return "{" + this.ToStringInternal() + "}";
        }
        public string ToString(bool fullString)
        {
            if (fullString)
            {
                return "{Vehicle Code=" + this.Vehicle[this.Vehicle.Length - 1].Description.Code + ", Ignore=" + this.Ignore +
                    ", " + this.ToStringInternal() + "}";
            }
            else { return this.ToString(); }
        }
        string ToStringInternal()
        {
            int lastYear  = this.HasImpact.Length - 1;
            int firstYear = 0;
            for (int i = 0; i < this.HasImpact.Length; i++)
            {   
                if (this.HasImpact[i]) { firstYear = i; break; }
            }
            bool multiple = (firstYear != lastYear);
            string impactString = string.Empty;
            for (int i = lastYear; i >= firstYear; i--)
            {   
                if (this.HasImpact[i])
                {
                    if (multiple) { impactString += "{"; }
                    impactString +=
                        "Model Year=" + (ModelYear.MinYear +  i)                     .ToString(        ) +
                        ", Veh Code=" + this.Vehicle         [i].Description.Code    .ToString(        ) +
                        ", Sales="    + this.Vehicle         [i].Description.Sales[i].ToString(        ) +
                        ", Cost="     + this.Cost            [i]                     .ToString("0.####") +
                        ", Imprv="    + this.Improvement     [i]                     .ToString("0.####") +
                        ", Delta CW=" + this.DeltaCurbWeight [i]                     .ToString("0.####") +
                        ", Delta FE=" + this.DeltaFuelEconomy[i]                     .ToString("0.####");
                    if (multiple) { impactString += ((i == firstYear) ? "}" : "}, "); }
                }
            }
            return impactString;
        }
        public void Reset()
        {
            this.Ignore           = false;
            this.HasImpact        = null;
            this.Vehicle          = null;
            this.Cost             = null;
            this.Improvement      = null;
            this.DeltaCurbWeight  = null;
            this.DeltaFuelEconomy = null;
            this.IsDieselized     = false;
        }
        #endregion
        #region 
        public bool Ignore;
        public bool[] HasImpact;
        public Vehicle[] Vehicle;
        public double[] Cost;
        public double[] Improvement;
        public double[] DeltaCurbWeight;
        public double[] DeltaFuelEconomy;
        public bool IsDieselized;
        #endregion
    }
}

