#region << Using Directives >>
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using Volpe.Cafe.Settings;
using Volpe.Cafe.Ui.Panels;
#endregion
namespace Volpe.Cafe.Ui
{
    public class ManageOutput : System.Windows.Forms.Form
    {
        #region 
        public ManageOutput(Session session)
        {
            this.InitializeComponent();
            this._session = session;
        }
        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }
        #endregion
        #region 
        #region 
        void InitializeComponent()
        {
            this.ux_statusTextBox = new System.Windows.Forms.RichTextBox();
            this.ux_outputPanel = new Volpe.Cafe.Ui.Panels.OutputPanel();
            this.ux_close = new System.Windows.Forms.Button();
            this.ux_save = new System.Windows.Forms.Button();
            this.SuspendLayout();
            this.ux_statusTextBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_statusTextBox.BackColor = System.Drawing.SystemColors.Control;
            this.ux_statusTextBox.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.ux_statusTextBox.Enabled = false;
            this.ux_statusTextBox.ForeColor = System.Drawing.Color.Black;
            this.ux_statusTextBox.Location = new System.Drawing.Point(8, 312);
            this.ux_statusTextBox.Name = "ux_statusTextBox";
            this.ux_statusTextBox.ReadOnly = true;
            this.ux_statusTextBox.ScrollBars = System.Windows.Forms.RichTextBoxScrollBars.Vertical;
            this.ux_statusTextBox.Size = new System.Drawing.Size(264, 56);
            this.ux_statusTextBox.TabIndex = 1;
            this.ux_statusTextBox.TabStop = false;
            this.ux_statusTextBox.Text = "";
            this.ux_outputPanel.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
                | System.Windows.Forms.AnchorStyles.Left) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_outputPanel.AutoScroll = true;
            this.ux_outputPanel.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.ux_outputPanel.Location = new System.Drawing.Point(0, 0);
            this.ux_outputPanel.Name = "ux_outputPanel";
            this.ux_outputPanel.Size = new System.Drawing.Size(394, 312);
            this.ux_outputPanel.TabIndex = 0;
            this.ux_close.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_close.BackColor = System.Drawing.SystemColors.Control;
            this.ux_close.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.ux_close.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_close.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.ux_close.ForeColor = System.Drawing.Color.Red;
            this.ux_close.Location = new System.Drawing.Point(336, 312);
            this.ux_close.Name = "ux_close";
            this.ux_close.Size = new System.Drawing.Size(48, 48);
            this.ux_close.TabIndex = 3;
            this.ux_close.Text = "Close";
            this.ux_close.Click += new System.EventHandler(this.Close_Click);
            this.ux_save.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_save.BackColor = System.Drawing.SystemColors.Control;
            this.ux_save.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_save.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.ux_save.ForeColor = System.Drawing.Color.Green;
            this.ux_save.Location = new System.Drawing.Point(280, 312);
            this.ux_save.Name = "ux_save";
            this.ux_save.Size = new System.Drawing.Size(48, 48);
            this.ux_save.TabIndex = 2;
            this.ux_save.Text = "Save";
            this.ux_save.Click += new System.EventHandler(this.Save_Click);
            this.AcceptButton = this.ux_save;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 14);
            this.CancelButton = this.ux_close;
            this.ClientSize = new System.Drawing.Size(394, 375);
            this.Controls.Add(this.ux_close);
            this.Controls.Add(this.ux_save);
            this.Controls.Add(this.ux_outputPanel);
            this.Controls.Add(this.ux_statusTextBox);
            this.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.HelpButton = true;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "ManageOutput";
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
            this.Text = "Manage Output";
            this.ResumeLayout(false);
        }
        #endregion
        #region 
        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            this.ux_outputPanel.Messages.MessagesChanged += new EventHandler(this.Messages_MessagesChanged);
            this.ux_outputPanel.SetInitialState(this._session.Settings.OutputSettings);
            Application.Idle += new EventHandler(this.ManageOutput_Idle);
            this.ux_save.Visible = !this._session.Running;
        }
        protected override void OnClosing(CancelEventArgs e)
        {
            this.ux_outputPanel.Messages.MessagesChanged -= new EventHandler(this.Messages_MessagesChanged);
            Application.Idle -= new EventHandler(this.ManageOutput_Idle);
            base.OnClosing(e);
        }
        #endregion
        void ManageOutput_Idle(object sender, EventArgs e)
        {
            this.ux_save.Enabled = !this._session.Running && this.ux_outputPanel.SettingsChanged;
        }
        void Messages_MessagesChanged(object sender, EventArgs e)
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new EventHandler(this.Messages_MessagesChanged));
            }
            else
            {
                this.ux_statusTextBox.Text      = this.ux_outputPanel.Messages.ToString();
                this.ux_statusTextBox.ForeColor = Color.Red;
                this.ux_statusTextBox.Enabled   = this.ux_statusTextBox.Text != "";
            }
        }
        void Save_Click(object sender, System.EventArgs e)
        {
            this.ux_outputPanel.SaveChanges();
            this._session.Settings.OutputSettings = this.ux_outputPanel.OutputSettings;
            this._session.SaveRequired = true;
        }
        void Close_Click(object sender, System.EventArgs e)
        {
            this.Close();
        }
        #endregion
        #region 
        #region 
        Volpe.Cafe.Ui.Panels.OutputPanel ux_outputPanel;
        System.Windows.Forms.RichTextBox ux_statusTextBox;
        System.Windows.Forms.Button ux_close;
        System.Windows.Forms.Button ux_save;
        #endregion
        Session _session;
        #endregion
    }
}

