using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Reflection;
using System.Windows.Forms;
using Volpe.Cafe;
using Volpe.Cafe.Model;
namespace Volpe.Cafe.Ui.Panels
{
	public class CompliancePanel : Volpe.Cafe.Ui.Panels.CafeUserControl
	{
        #region 
		public CompliancePanel()
		{
			this.InitializeComponent();
            this.PostInitialize();
        }
		protected override void Dispose(bool disposing)
		{
			base.Dispose(disposing);
		}
        #endregion
        #region 
		#region 
        void InitializeComponent()
		{
            this.ux_complianceLabel = new System.Windows.Forms.Label();
            this.ux_compliancePanel = new System.Windows.Forms.Panel();
            this.SuspendLayout();
            this.ux_complianceLabel.Location = new System.Drawing.Point(8, 8);
            this.ux_complianceLabel.Name = "ux_complianceLabel";
            this.ux_complianceLabel.Size = new System.Drawing.Size(232, 16);
            this.ux_complianceLabel.TabIndex = 0;
            this.ux_complianceLabel.Text = "What type of model would you like to run?";
            this.ux_compliancePanel.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_compliancePanel.Location = new System.Drawing.Point(8, 16);
            this.ux_compliancePanel.Name = "ux_compliancePanel";
            this.ux_compliancePanel.Size = new System.Drawing.Size(384, 48);
            this.ux_compliancePanel.TabIndex = 1;
            this.Controls.Add(this.ux_complianceLabel);
            this.Controls.Add(this.ux_compliancePanel);
            this.Name = "CompliancePanel";
            this.Size = new System.Drawing.Size(400, 112);
            this.ResumeLayout(false);
        }
		#endregion
        void PostInitialize()
        {
            this.AutoInitializeCheckChangesDetector(this.Controls);
        }
        void InitializeComplianceList(Type[] complianceTypes, ICompliance initialCompliance)
        {
            const string errMessage = "At least one compliance model must be specified in the complianceTypes array.";
            if (complianceTypes == null) { throw new ArgumentNullException("complianceTypes", errMessage); }
            if (complianceTypes.Length < 1) { throw new ArgumentException(errMessage, "complianceTypes"); }
            int      y     = 8;                                     
            Graphics g     = this.ux_compliancePanel.CreateGraphics();
            Font     font  = this.ux_compliancePanel.Font;
            int      width = this.ux_compliancePanel.Width - 16;    
            string initialComplianceName = (initialCompliance == null) ? "volpe.cafe.model.compliance" :
                initialCompliance.GetType().FullName.ToLower();
            for (int i = 0; i < complianceTypes.Length; i++)
            {
                Type            item       = complianceTypes[i];
                ConstructorInfo ctor       = item.GetConstructor(Type.EmptyTypes);
                ICompliance     compliance = (ICompliance)ctor.Invoke(new object[] {});
                ModelDescriptionAttribute attr = (ModelDescriptionAttribute)Attribute.GetCustomAttribute(item, typeof(ModelDescriptionAttribute));
                string name  = attr.FullTitle;
                string descr = attr.Description;
                string text  = name + "\n" + descr;
                SizeF  size  = g.MeasureString(text, font, width - 16);
                RadioButton rdb = new RadioButton();
                rdb.CheckAlign  = ContentAlignment.TopLeft;
                rdb.FlatStyle   = FlatStyle.Popup;
                rdb.Location    = new Point(8, y);
                rdb.Size        = new Size(width, (int)(size.Height + 1));
                rdb.Tag         = compliance;
                rdb.Text        = text;
                rdb.CheckedChanged += new EventHandler(this.CheckChangesDetector);
                rdb.CheckedChanged += new EventHandler(this.ComplianceItem_CheckedChanged);
                this.ux_compliancePanel.Controls.Add(rdb);
                y = rdb.Top + rdb.Height + 8;
                if (initialComplianceName == item.FullName.ToLower()) { rdb.Checked = true; }
            }
            this.ux_compliancePanel.Height = y;
        }
        void ComplianceItem_CheckedChanged(object sender, EventArgs e)
        {
            RadioButton rdb = (RadioButton)sender;
            if (rdb.Checked)
            {
                this._selCompliance = (ICompliance)rdb.Tag;
            }
        }
        public void SetInitialState(Type[] complianceTypes, ICompliance compliance)
        {
            this.InitializeComplianceList(complianceTypes, compliance);
            if (compliance != null) { this.SaveChanges(); }
        }
        public override void SaveChanges()
        {
            if (this.SettingsChanged)
            {
                this._compliance = this._selCompliance.CreateNew();
                base.SaveChanges();
            }
        }
        #endregion
        #region 
        [Browsable(false)]
        public override bool SettingsChanged { get { return base.SettingsChanged || (this._compliance == null); } }
        [Browsable(false)]
        public ICompliance Compliance { get { return this._compliance; } }
        [Browsable(false)]
        public ICompliance SelectedCompliance { get { return this._selCompliance; } }
        #endregion
        #region 
        #region 
        System.Windows.Forms.Label ux_complianceLabel;
        System.Windows.Forms.Panel ux_compliancePanel;
        #endregion
        ICompliance _compliance;
        ICompliance _selCompliance;
        #endregion
    }
}

