using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Windows.Forms;
using Volpe.Cafe.Settings;
namespace Volpe.Cafe.Ui.Panels
{
    public class EISPanel : Volpe.Cafe.Ui.Panels.CafeUserControl
    {
        #region 
        public EISPanel()
        {
            this.InitializeComponent();
            this.PostInitialize();
        }
        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }
        #endregion
        #region 
        #region 
        void InitializeComponent()
        {
            this.ux_runEISModel = new System.Windows.Forms.CheckBox();
            this.ux_eisInputPanel = new System.Windows.Forms.Panel();
            this.ux_eisTailpipeEmissionsFileBrowse = new System.Windows.Forms.Button();
            this.ux_eisTailpipeEmissionsFile = new System.Windows.Forms.TextBox();
            this.ux_eisTailpipeEmissionsFileLabel = new System.Windows.Forms.Label();
            this.ux_eisParametersFileBrowse = new System.Windows.Forms.Button();
            this.ux_eisParametersFile = new System.Windows.Forms.TextBox();
            this.ux_eisParametersFileLabel = new System.Windows.Forms.Label();
            this.ux_eisInputLabel = new System.Windows.Forms.Label();
            this.ux_eisInputPanel.SuspendLayout();
            this.SuspendLayout();
            this.ux_runEISModel.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_runEISModel.Location = new System.Drawing.Point(8, 8);
            this.ux_runEISModel.Name = "ux_runEISModel";
            this.ux_runEISModel.Size = new System.Drawing.Size(120, 16);
            this.ux_runEISModel.TabIndex = 0;
            this.ux_runEISModel.Text = "Run the EIS Model";
            this.ux_eisInputPanel.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_eisInputPanel.Controls.Add(this.ux_eisTailpipeEmissionsFileBrowse);
            this.ux_eisInputPanel.Controls.Add(this.ux_eisTailpipeEmissionsFile);
            this.ux_eisInputPanel.Controls.Add(this.ux_eisTailpipeEmissionsFileLabel);
            this.ux_eisInputPanel.Controls.Add(this.ux_eisParametersFileBrowse);
            this.ux_eisInputPanel.Controls.Add(this.ux_eisParametersFile);
            this.ux_eisInputPanel.Controls.Add(this.ux_eisParametersFileLabel);
            this.ux_eisInputPanel.Enabled = false;
            this.ux_eisInputPanel.Location = new System.Drawing.Point(8, 36);
            this.ux_eisInputPanel.Name = "ux_eisInputPanel";
            this.ux_eisInputPanel.Size = new System.Drawing.Size(384, 88);
            this.ux_eisInputPanel.TabIndex = 3;
            this.ux_eisTailpipeEmissionsFileBrowse.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_eisTailpipeEmissionsFileBrowse.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_eisTailpipeEmissionsFileBrowse.Location = new System.Drawing.Point(304, 64);
            this.ux_eisTailpipeEmissionsFileBrowse.Name = "ux_eisTailpipeEmissionsFileBrowse";
            this.ux_eisTailpipeEmissionsFileBrowse.Size = new System.Drawing.Size(80, 21);
            this.ux_eisTailpipeEmissionsFileBrowse.TabIndex = 5;
            this.ux_eisTailpipeEmissionsFileBrowse.Text = "Browse";
            this.ux_eisTailpipeEmissionsFile.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_eisTailpipeEmissionsFile.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_eisTailpipeEmissionsFile.Location = new System.Drawing.Point(8, 64);
            this.ux_eisTailpipeEmissionsFile.Name = "ux_eisTailpipeEmissionsFile";
            this.ux_eisTailpipeEmissionsFile.Size = new System.Drawing.Size(295, 21);
            this.ux_eisTailpipeEmissionsFile.TabIndex = 4;
            this.ux_eisTailpipeEmissionsFile.Text = "";
            this.ux_eisTailpipeEmissionsFile.WordWrap = false;
            this.ux_eisTailpipeEmissionsFileLabel.AutoSize = true;
            this.ux_eisTailpipeEmissionsFileLabel.Location = new System.Drawing.Point(8, 48);
            this.ux_eisTailpipeEmissionsFileLabel.Name = "ux_eisTailpipeEmissionsFileLabel";
            this.ux_eisTailpipeEmissionsFileLabel.Size = new System.Drawing.Size(225, 17);
            this.ux_eisTailpipeEmissionsFileLabel.TabIndex = 3;
            this.ux_eisTailpipeEmissionsFileLabel.Text = "Please select the EIS Tailpipe Emissions file:";
            this.ux_eisParametersFileBrowse.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_eisParametersFileBrowse.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_eisParametersFileBrowse.Location = new System.Drawing.Point(304, 24);
            this.ux_eisParametersFileBrowse.Name = "ux_eisParametersFileBrowse";
            this.ux_eisParametersFileBrowse.Size = new System.Drawing.Size(80, 21);
            this.ux_eisParametersFileBrowse.TabIndex = 2;
            this.ux_eisParametersFileBrowse.Text = "Browse";
            this.ux_eisParametersFile.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_eisParametersFile.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_eisParametersFile.Location = new System.Drawing.Point(8, 24);
            this.ux_eisParametersFile.Name = "ux_eisParametersFile";
            this.ux_eisParametersFile.Size = new System.Drawing.Size(295, 21);
            this.ux_eisParametersFile.TabIndex = 1;
            this.ux_eisParametersFile.Text = "";
            this.ux_eisParametersFile.WordWrap = false;
            this.ux_eisParametersFileLabel.AutoSize = true;
            this.ux_eisParametersFileLabel.Location = new System.Drawing.Point(8, 8);
            this.ux_eisParametersFileLabel.Name = "ux_eisParametersFileLabel";
            this.ux_eisParametersFileLabel.Size = new System.Drawing.Size(103, 17);
            this.ux_eisParametersFileLabel.TabIndex = 0;
            this.ux_eisParametersFileLabel.Text = "EIS Parameters file:";
            this.ux_eisInputLabel.Location = new System.Drawing.Point(8, 28);
            this.ux_eisInputLabel.Name = "ux_eisInputLabel";
            this.ux_eisInputLabel.Size = new System.Drawing.Size(344, 16);
            this.ux_eisInputLabel.TabIndex = 4;
            this.ux_eisInputLabel.Text = "Please select the input files you would like to use for EIS modeling:";
            this.Controls.Add(this.ux_eisInputLabel);
            this.Controls.Add(this.ux_eisInputPanel);
            this.Controls.Add(this.ux_runEISModel);
            this.Name = "EISPanel";
            this.Size = new System.Drawing.Size(400, 136);
            this.ux_eisInputPanel.ResumeLayout(false);
            this.ResumeLayout(false);
        }
        #endregion
        void PostInitialize()
        {
            this.InitializeTextBoxDragDrop(this.ux_eisParametersFile, this.ux_eisTailpipeEmissionsFile);
            this.AutoInitializeCheckChangesDetector(this.Controls);
            this.ux_runEISModel                   .CheckedChanged += new EventHandler(this.RunEISModel_CheckedChanged);
            this.ux_eisParametersFile             .TextChanged    += new EventHandler(this.EisFile_TextChanged);
            this.ux_eisTailpipeEmissionsFile      .TextChanged    += new EventHandler(this.EisFile_TextChanged);
            this.ux_eisParametersFile             .EnabledChanged += new EventHandler(this.EisFile_EnabledChanged);
            this.ux_eisTailpipeEmissionsFile      .EnabledChanged += new EventHandler(this.EisFile_EnabledChanged);
            this.ux_eisParametersFileBrowse       .Click          += new EventHandler(this.EisFileBrowse_Click);
            this.ux_eisTailpipeEmissionsFileBrowse.Click          += new EventHandler(this.EisFileBrowse_Click);
            this.ux_eisParametersFile       .Text = "";
            this.ux_eisTailpipeEmissionsFile.Text = "";
        }
        void RunEISModel_CheckedChanged(object sender, EventArgs e)
        {
            bool enabled = this.ux_runEISModel.Checked;
            this.ux_eisInputLabel.Enabled = enabled;
            this.ux_eisInputPanel.Enabled = enabled;
        }
        void EisFile_TextChanged(object sender, EventArgs e)
        {
            TextBox tb          = (TextBox)sender;
            bool    isParams    = (tb == this.ux_eisParametersFile);
            bool    isEmissions = (tb == this.ux_eisTailpipeEmissionsFile);
            if (File.Exists(tb.Text))
            {
                bool eisFilePathChanged =
                    (isParams    && !this.CompareFilePaths(this._eisSettings.EISParametersFile       , tb.Text)) ||
                    (isEmissions && !this.CompareFilePaths(this._eisSettings.EISTailpipeEmissionsFile, tb.Text));
                tb.ForeColor = (this._visualTracking && eisFilePathChanged) ? this._visualTrackingColor : Control.DefaultForeColor;
                tb.BackColor = Color.Empty;
                this._messages.RemoveMessage(tb);
            }
            else if (tb.Enabled)
            {
                if (tb.Text.Trim() == string.Empty)
                {
                    if      (isParams   ) { this._messages.AddMessage("Please select a Parameters file for EIS Modeling."        , Color.Red, tb); }
                    else if (isEmissions) { this._messages.AddMessage("Please select a Tailpipe Emissions file for EIS Modeling.", Color.Red, tb); }
                }
                else
                {
                    if      (isParams   ) { this._messages.AddMessage("The specified EIS Parameters file does not exist on disk."        , Color.Red, tb); }
                    else if (isEmissions) { this._messages.AddMessage("The specified EIS Tailpipe Emissions file does not exist on disk.", Color.Red, tb); }
                }
                tb.BackColor = Color.Honeydew;
                tb.ForeColor = Color.Red;
            }
        }
        void EisFile_EnabledChanged(object sender, EventArgs e)
        {
            TextBox tb = (TextBox)sender;
            if (tb.Enabled) { this.EisFile_TextChanged(sender, e); }
            else            { this._messages.RemoveMessage(sender); tb.BackColor = Color.Empty; }
        }
        void EisFileBrowse_Click(object sender, EventArgs e)
        {
            string title = null;
            TextBox tb = null;
            if (sender == this.ux_eisParametersFileBrowse)
            {
                title = "Please select the Parameters file for EIS Modeling:";
                tb = this.ux_eisParametersFile;
            }
            else if (sender == this.ux_eisTailpipeEmissionsFileBrowse)
            {
                title = "Please select the Tailpipe Emissions file for EIS Modeling:";
                tb = this.ux_eisTailpipeEmissionsFile;
            }
            OpenFileDialog dlg = new OpenFileDialog();
            dlg.Title = title;
            dlg.Multiselect = false;
            if (File.Exists(tb.Text)) { dlg.FileName = tb.Text; }
            dlg.Filter = "Microsoft Excel Workbook Files (*.xls)|*.xls";
            if (dlg.ShowDialog() == DialogResult.OK) { tb.Text = dlg.FileName; }
        }
        bool CompareFilePaths(string path1, string path2)
        {
            if (File.Exists(path1)) { path1 = Path.GetFullPath(path1); }
            if (File.Exists(path2)) { path2 = Path.GetFullPath(path2); }
            return (path1 == path2);
        }
        void InitializeTextBoxDragDrop(params TextBox[] values)
        {
            for (int i = 0; i < values.Length; i++)
            {
                values[i].AllowDrop = true;
                values[i].DragEnter += new DragEventHandler(this.EISPanel_DragEnter);
                values[i].DragDrop  += new DragEventHandler(this.EISPanel_DragDrop);
            }
        }
        void EISPanel_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop, false))
            {
                e.Effect = DragDropEffects.All;
            }
        }
        void EISPanel_DragDrop(object sender, DragEventArgs e)
        {
            TextBox tb = (TextBox)sender;
            string[] files = (string[])e.Data.GetData(DataFormats.FileDrop, false);
            for (int i = 0; i < files.Length; i++)
            {
                if (File.Exists(files[i])) { tb.Text = files[i]; break; }
            }
        }
        public void SetInitialState(EISSettings eisSettings)
        {
            this._eisSettings = eisSettings;
            this.ux_runEISModel             .Checked = (eisSettings.RunEISModelFlatCAFE || eisSettings.RunEISModelGrowCAFE);
            this.ux_eisParametersFile       .Text    = eisSettings.EISParametersFile;
            this.ux_eisTailpipeEmissionsFile.Text    = eisSettings.EISTailpipeEmissionsFile;
            base.SaveChanges();
        }
        public override void SaveChanges()
        {
            if (this.SettingsChanged)
            {   
                this._eisSettings.RunEISModelFlatCAFE      = this.ux_runEISModel             .Checked;
                this._eisSettings.RunEISModelGrowCAFE      = this.ux_runEISModel             .Checked;
                this._eisSettings.EISParametersFile        = this.ux_eisParametersFile       .Text.Trim();
                this._eisSettings.EISTailpipeEmissionsFile = this.ux_eisTailpipeEmissionsFile.Text.Trim();
                base.SaveChanges();
                this.PostSave();
            }
        }
        void PostSave()
        {
            if (this._visualTracking)
            {   
                this.ux_eisParametersFile       .ForeColor = Control.DefaultForeColor;
                this.ux_eisParametersFile       .BackColor = Color.Empty;
                this.ux_eisTailpipeEmissionsFile.ForeColor = Control.DefaultForeColor;
                this.ux_eisTailpipeEmissionsFile.BackColor = Color.Empty;
            }
        }
        #endregion
        #region 
        [Browsable(false)]
        public EISSettings EISSettings { get { return this._eisSettings; } }
        [Browsable(false)]
        public override bool SettingsChanged
        {
            get
            {
                if (this.ux_runEISModel.Checked && (!File.Exists(this.ux_eisParametersFile       .Text) ||
                                                    !File.Exists(this.ux_eisTailpipeEmissionsFile.Text))) { return false; }
                return base.SettingsChanged ||
                    !this.CompareFilePaths(this._eisSettings.EISParametersFile       , this.ux_eisParametersFile       .Text) ||
                    !this.CompareFilePaths(this._eisSettings.EISTailpipeEmissionsFile, this.ux_eisTailpipeEmissionsFile.Text);
            }
        }
        #endregion
        #region 
        #region 
        System.Windows.Forms.CheckBox ux_runEISModel;
        System.Windows.Forms.Label ux_eisInputLabel;
        System.Windows.Forms.Panel ux_eisInputPanel;
        System.Windows.Forms.Label ux_eisParametersFileLabel;
        System.Windows.Forms.TextBox ux_eisParametersFile;
        System.Windows.Forms.Button ux_eisParametersFileBrowse;
        System.Windows.Forms.Button ux_eisTailpipeEmissionsFileBrowse;
        System.Windows.Forms.TextBox ux_eisTailpipeEmissionsFile;
        System.Windows.Forms.Label ux_eisTailpipeEmissionsFileLabel;
        #endregion
        EISSettings _eisSettings;
        #endregion
    }
}

