using System;
using Volpe.Cafe;
using Volpe.Cafe.Data;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public class ManufacturerModelingData : ICloneable
    {
        #region 
        public ManufacturerModelingData()
        {
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public ManufacturerModelingData Clone()
        {
            ManufacturerModelingData mmd = new ManufacturerModelingData();
            mmd.KMY                 = (KMYType  [])Global.CloneArray(this.KMY            , typeof(KMYType ));
            mmd.DefaultStandard     = (RCDouble [])Global.CloneArray(this.DefaultStandard, typeof(RCDouble));
            mmd.AverageStandard     = this.AverageStandard;
            mmd.PreliminaryStandard = this.PreliminaryStandard;
            mmd.Standard            = this.Standard;
            mmd.Sales               = this.Sales;
            mmd.SalesOverFE         = this.SalesOverFE;
            mmd.CAFE                = this.CAFE;
            mmd.Credits             = this.Credits;
            mmd.Fines               = this.Fines;
            mmd.TechCost            = this.TechCost;
            mmd.RegCost             = this.RegCost;
            mmd.TechUsedSales       = (RCDouble [])Global.CloneArray(this.TechUsedSales   , typeof(RCDouble ));
            mmd.TechAppliedSales    = (RCDouble [])Global.CloneArray(this.TechAppliedSales, typeof(RCDouble ));
            mmd.TechExhausted       = (RCBoolean[])Global.CloneArray(this.TechExhausted   , typeof(RCBoolean));
            mmd.FuelConsumption     = this.FuelConsumption;
            mmd.SocialBenefits      = this.SocialBenefits;
            mmd.DiscSocialBenefits  = this.DiscSocialBenefits;
            mmd.CO2Emissions        = this.CO2Emissions;
            mmd.CO2DamageCosts      = this.CO2DamageCosts;
            mmd.CO2DiscDamageCosts  = this.CO2DiscDamageCosts;
            mmd.CFExhausted         = this.CFExhausted;
            return mmd;
        }
        #endregion
        #endregion
        #region 
        public KMYType[] KMY;
        public RCDouble[] DefaultStandard;
        public RCDouble AverageStandard;
        public RCDouble PreliminaryStandard;
        public RCDouble Standard;
        public RCDouble Sales;
        public RCDouble SalesOverFE;
        public RCDouble CAFE;
        public RCDouble Credits;
        public RCDouble Fines;
        public RCDouble TechCost;
        public RCDouble RegCost;
        public RCDouble[] TechUsedSales;
        public RCDouble[] TechAppliedSales;
        public RCBoolean[] TechExhausted;
        public RCDouble FuelConsumption;
        public RCDouble SocialBenefits;
        public RCDouble DiscSocialBenefits;
        public RCDouble CO2Emissions;
        public RCDouble CO2DamageCosts;
        public RCDouble CO2DiscDamageCosts;
        public bool CFExhausted;
        #endregion
    }
}

