using System;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public class NamePlate : Component, ICloneable
    {
        #region 
        private NamePlate()
            : base()
        {
        }
        public NamePlate(string name)
            : base()
        {
            this._name = name.Trim().ToUpper();
            this._modelingData = new ComponentModelingData();
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public NamePlate Clone()
        {
            NamePlate np = new NamePlate();
            np._name = this._name;
            this.CopyTo(np);
            return np;
        }
        #endregion
        internal override void Initialize(Manufacturer manufacturer)
        {
            base.Initialize(manufacturer);
        }
        #endregion
        #region 
        public string Name
        {
            get { return this._name; }
        }
        #endregion
        #region 
        private string _name;
        #endregion
    }
}

