using System;
using Volpe.Cafe;
using Volpe.Cafe.Collections;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public class Transmission : Component, ICloneable
    {
        #region 
        private Transmission()
            : base()
        {
        }
        public Transmission(TransmissionDescription description)
            : base()
        {
            this._description = description;
            this._modelingData = new ComponentModelingData();
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public Transmission Clone()
        {
            Transmission trn = new Transmission();
            trn._description = (TransmissionDescription)this._description.Clone();
            this.CopyTo(trn);
            return trn;
        }
        #endregion
        internal void SetParent(int parentCode)
        {
            if (parentCode != -1)
            {
                Transmission[] trns = this._manufacturer.Transmissions.ToArray();
                for (int i = 0; i < trns.Length; i++)
                {
                    if (parentCode == trns[i]._description.Code)
                    {
                        this._parent = trns[i];
                        break;
                    }
                }
            }
        }
        internal void SetParent(Transmission value)
        {
            this._parent = value;
        }
        public Transmission Split(VehicleCollection vehicles, int newCode)
        {
            Transmission trn = (Transmission)this.Clone();
            newCode = Math.Max(newCode, trn._manufacturer.GetNextTransmissionCode());
            trn._description.Code = newCode;
            trn._manufacturer.LastTrnCode = newCode;
            for (int i = 0, vehCount = vehicles.Count; i < vehCount; i++)
            {
                vehicles[i].SetTransmission(trn);
            }
            this.SplitTo(vehicles, trn);
            return trn;
        }
        #endregion
        #region 
        public TransmissionDescription Description
        {
            get { return this._description; }
        }
        public Transmission Parent
        {
            get { return (Transmission)this._parent; }
        }
        #endregion
        #region 
        private TransmissionDescription _description;
        #endregion
    }
}

