using System;
using System.Text;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public class TransmissionDescription : ICloneable
    {
        #region 
        public TransmissionDescription()
            : base()
        {
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public TransmissionDescription Clone()
        {
            TransmissionDescription td = new TransmissionDescription();
            td.Code                  = this.Code;
            td.Manufacturer          = this.Manufacturer;
            td.Type                  = this.Type;
            td.NumForwardGears       = this.NumForwardGears;
            td.UsedTechnologies      = (int[])Global.CloneArray(this.UsedTechnologies     , typeof(int));
            td.AvailableTechnologies = (int[])Global.CloneArray(this.AvailableTechnologies, typeof(int));
            return td;
        }
        #endregion
        #region 
        public override string ToString()
        {
            return
                (this.Type == "A" || this.Type == "M") ? this.Type + this.NumForwardGears :
                (this.Type.StartsWith("CVT")         ) ? "CVT" : this.Type;
        }
        #endregion
        #endregion
        #region 
        public int    Code;
        public string Manufacturer;
        public string Type;
        public int    NumForwardGears;
        public int[] UsedTechnologies;
        public int[] AvailableTechnologies;
        #endregion
    }
}

