#region << Using Directives >>
using System;
using Volpe.Cafe.Data;
using Volpe.Cafe.Data.MonteCarlo;
using Volpe.Cafe.Data.Optimization;
using Volpe.Cafe.IO;
using Volpe.Cafe.Settings;
#endregion
namespace Volpe.Cafe.Model
{
    [ModelDescription("ICompliance", "Provides a standard interface for the compliance model implementation.", 1.0F)]
    public interface ICompliance
    {
        #region 
        event Volpe.Ui.PromptEventHandler Prompt;
        event ModelingEventHandler ModelingStarted;
        event ModelingEventHandler ModelingStopped;
        event ModelingEventHandler ModelingCompleted;
        event ModelingEventHandler ModelingChanged;
        #endregion
        #region 
        ICompliance CreateNew();
        void Start(Industry data, ModelingSettings settings, LogWriter logWriter);
        void Abort();
        void Abort(bool abortWhenReady);
        Industry GetData(int scenIndex, int yearIndex);
        #endregion
        #region 
        bool IsValid { get; }
        IEISModel EISModel { get; }
        bool IsOptimization { get; }
        bool IsMonteCarlo { get; }
        OptimizationData OptimizationData { get; }
        MonteCarloData   MonteCarloData   { get; }
        Industry Data { get; }
        ModelingSettings Settings { get; }
        LogWriter LogWriter { get; }
        ModelingState State { get; }
        bool Running   { get; }
        bool Stopped   { get; }
        bool Completed { get; }
        bool StoppedOrCompleted { get; }
        IModelingProgress Progress { get; }
        DateTime StartTime { get; }
        DateTime StopTime  { get; }
        long Runtime { get; }
        bool RequiresMarketData   { get; }
        bool RequiresTechnologies { get; }
        bool RequiresParameters   { get; }
        bool RequiresEmissions    { get; }
        bool RequiresScenarios    { get; }
        #endregion
    }
}

