using System;
using System.Runtime.Serialization;
using Volpe.Cafe.IO;
namespace Volpe.Cafe.Settings
{
    [Serializable]
    public struct InputSettings : ISerializable
    {
        #region 
        public InputSettings(string dataPath)
        {
            this._dataPath               = dataPath;
            this.EncryptInput            = false;
            this.InputPassword           = string.Empty;
            this.MarketDataFile          = "";
            this.TechnologiesFile        = "";
            this.ParametersFile          = "";
            this.EmissionsRatesFile      = "";
            this.ScenariosFile           = "";
            this.MarketDataTimestamp     = new DateTime(0);
            this.TechnologiesTimestamp   = new DateTime(0);
            this.ParametersTimestamp     = new DateTime(0);
            this.EmissionsRatesTimestamp = new DateTime(0);
            this.ScenariosTimestamp      = new DateTime(0);
        }
        InputSettings(SerializationInfo info, StreamingContext context)
        {
            this._dataPath          = info.GetString("_dataPath");
            this.EncryptInput       = info.GetBoolean("EncryptInput");
            this.InputPassword      = info.GetString("InputPassword");
            this.MarketDataFile     = info.GetString("MarketDataFile");
            this.TechnologiesFile   = info.GetString("TechnologiesFile");
            this.ParametersFile     = info.GetString("ParametersFile");
            this.EmissionsRatesFile = info.GetString("EmissionsRatesFile");
            this.ScenariosFile      = info.GetString("ScenariosFile");
            try
            {
                this.MarketDataTimestamp     = (DateTime)info.GetValue("MarketDataTimestamp"    , typeof(DateTime));
                this.TechnologiesTimestamp   = (DateTime)info.GetValue("TechnologiesTimestamp"  , typeof(DateTime));
                this.ParametersTimestamp     = (DateTime)info.GetValue("ParametersTimestamp"    , typeof(DateTime));
                this.EmissionsRatesTimestamp = (DateTime)info.GetValue("EmissionsRatesTimestamp", typeof(DateTime));
                this.ScenariosTimestamp      = (DateTime)info.GetValue("ScenariosTimestamp"     , typeof(DateTime));
            }
            catch
            {
                this.MarketDataTimestamp     = new DateTime(0);
                this.TechnologiesTimestamp   = new DateTime(0);
                this.ParametersTimestamp     = new DateTime(0);
                this.EmissionsRatesTimestamp = new DateTime(0);
                this.ScenariosTimestamp      = new DateTime(0);
            }
        }
        #endregion
        #region 
        #region 
        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            info.AddValue("_dataPath"              , this._dataPath);
            info.AddValue("EncryptInput"           , this.EncryptInput);
            info.AddValue("InputPassword"          , this.InputPassword);
            info.AddValue("MarketDataFile"         , this.MarketDataFile);
            info.AddValue("TechnologiesFile"       , this.TechnologiesFile);
            info.AddValue("ParametersFile"         , this.ParametersFile);
            info.AddValue("EmissionsRatesFile"     , this.EmissionsRatesFile);
            info.AddValue("ScenariosFile"          , this.ScenariosFile);
            info.AddValue("MarketDataTimestamp"    , this.MarketDataTimestamp);
            info.AddValue("TechnologiesTimestamp"  , this.TechnologiesTimestamp);
            info.AddValue("ParametersTimestamp"    , this.ParametersTimestamp);
            info.AddValue("EmissionsRatesTimestamp", this.EmissionsRatesTimestamp);
            info.AddValue("ScenariosTimestamp"     , this.ScenariosTimestamp);
        }
        #endregion
        internal void WriteSummaryLog(LogWriter writer)
        {
            string format = "M/dd/yy H:mm:ss";
            if (writer.Summary == null) { return; }
            string outStr = "--- Input Settings ---"                    +
                "\n  DataPath="           + this._dataPath              +
                "\n  EncryptInput="       + this.EncryptInput           +
                "\n    InputPassword="    + this.MaskInputPassword('*') +
                "\n  MarketDataFile="     + this.MarketDataFile     + " (" + this.MarketDataTimestamp    .ToString(format) + ")" +
                "\n  TechnologiesFile="   + this.TechnologiesFile   + " (" + this.TechnologiesTimestamp  .ToString(format) + ")" +
                "\n  ParametersFile="     + this.ParametersFile     + " (" + this.ParametersTimestamp    .ToString(format) + ")" +
                "\n  EmissionsRatesFile=" + this.EmissionsRatesFile + " (" + this.EmissionsRatesTimestamp.ToString(format) + ")" +
                "\n  ScenariosFile="      + this.ScenariosFile      + " (" + this.ScenariosTimestamp     .ToString(format) + ")";
            writer.Summary.WriteLine(outStr + "\n");
        }
        string MaskInputPassword(char pwMask)
        {
            return (this.InputPassword == null || this.InputPassword == string.Empty) ? "" : new string(pwMask, 8);
        }
        #endregion
        #region 
        public string DataPath { get { return this._dataPath; } }
        #endregion
        #region 
        private string _dataPath;
        public bool EncryptInput;
        public string InputPassword;
        public string MarketDataFile;
        public string TechnologiesFile;
        public string ParametersFile;
        public string EmissionsRatesFile;
        public string ScenariosFile;
        public DateTime MarketDataTimestamp;
        public DateTime TechnologiesTimestamp;
        public DateTime ParametersTimestamp;
        public DateTime EmissionsRatesTimestamp;
        public DateTime ScenariosTimestamp;
        #endregion
    }
}

