using System;
using Volpe.Cafe.IO;
namespace Volpe.Cafe.Settings
{
    [Serializable]
    public struct MonteCarloSettings : ICloneable
    {
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public MonteCarloSettings Clone()
        {
            MonteCarloSettings mcs = new MonteCarloSettings();
            mcs.TrialPairs         = this.TrialPairs;
            mcs.UseTrialsFile      = this.UseTrialsFile;
            mcs.TrialsFile         = this.TrialsFile;
            mcs.Distributed        = this.Distributed;
            mcs.DistributedHosts   = (string[])Global.CloneArray(this.DistributedHosts, typeof(string));
            return mcs;
        }
        #endregion
        internal void WriteSummaryLog(LogWriter writer)
        {
            if (writer.Summary == null) { return; }
            string outStr = "--- Monte-Carlo Settings ---" +
                ((this.UseTrialsFile) ? "\n  Using TrialsFile=" + this.TrialsFile : "\n  TrialPairs=" + this.TrialPairs);
            if (this.Distributed && this.DistributedHosts != null && this.DistributedHosts.Length > 0)
            {
                outStr += "\n  Distributed MC Settings:" + "\n    Distributed Hosts=";
                for (int i = 0, hostCount = this.DistributedHosts.Length; i < hostCount; i++)
                {
                    outStr += "\n      " + this.DistributedHosts[i];
                }
            }
            writer.Summary.WriteLine(outStr + "\n");
        }
        #endregion
        #region 
        public int TrialPairs;
        public bool UseTrialsFile;
        public string TrialsFile;
        public bool Distributed;
        public string[] DistributedHosts;
        #endregion
    }
}

