using System;
using Volpe.Cafe.IO;
namespace Volpe.Cafe.Settings
{
    [Serializable]
    public struct OptimizationSettings
    {
        #region 
        internal void WriteSummaryLog(LogWriter writer)
        {
            if (writer.Summary == null) { return; }
            string outStr = "--- Optimization Settings ---"                   +
                "\n  Type="                   + this.Type                   +
                "\n  Mode="                   + this.Mode                   +
                "\n  AboveOptimum="           + this.AboveOptimum           +
                "\n  BelowOptimum="           + this.BelowOptimum           +
                "\n  Increment="              + this.Increment              +
                "\n  MergedFleet="            + this.MergedFleet            +
                "\n  BackstopStandard="       + this.BackstopStandard       +
                "\n  BackstopTargetFunction=" + this.BackstopTargetFunction +
                "\n  StartYear="              + this.StartYear              +
                "\n  StopOnFinedIterations="  + this.StopOnFinedIterations  +
                "\n  CountFinesTowardNB="     + this.CountFinesTowardNB     +
                "\n  DiscardMfrsWithFines="   + this.DiscardMfrsWithFines;
            writer.Summary.WriteLine(outStr + "\n");
        }
        #endregion
        #region 
        public OptimizationType Type;
        public OptimizationMode Mode;
        public int AboveOptimum;
        public int BelowOptimum;
        public double Increment;
        public bool MergedFleet;
        public bool BackstopStandard;
        public bool BackstopTargetFunction;
        public int StartYear;
        public bool StopOnFinedIterations;
        public bool CountFinesTowardNB;
        public bool DiscardMfrsWithFines;
        #endregion
    }
}

