using System;
namespace Volpe.Cafe
{
    [Serializable]
    public class TechnologyAttributesTable : ICloneable
    {
        #region 
        public TechnologyAttributesTable()
        {
            this._attributes = new TechnologyAttributes[(int)TechnologyClass.Max];
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public TechnologyAttributesTable Clone()
        {
            TechnologyAttributesTable tat = new TechnologyAttributesTable();
            int attrCount = this._attributes.Length;
            tat._attributes = new TechnologyAttributes[attrCount];
            for (int i = 0; i < attrCount; i++)
            {
                tat._attributes[i] = this._attributes[i];
            }
            return tat;
        }
        #endregion
        public TechnologyAttributes[] ToArray()
        {
            return this._attributes;
        }
        #endregion
        #region 
        public TechnologyAttributes this[TechnologyClass techClass]
        {
            get
            {
                int index = (int)techClass - 1;
                if (index < 0 || index >= (int)TechnologyClass.Max) { throw new ArgumentOutOfRangeException("techClass",
                    "The CAFE technology class specified is not a valid value."); }
                return this._attributes[index];
            }
            set
            {
                int index = (int)techClass - 1;
                if (index < 0 || index >= (int)TechnologyClass.Max) { throw new ArgumentOutOfRangeException("techClass",
                    "The CAFE technology class specified is not a valid value."); }
                this._attributes[index] = value;
            }
        }
        #endregion
        #region 
        private TechnologyAttributes[] _attributes;
        #endregion
    }
}

