#region << Using Directives >>
using System;
using Volpe.Cafe.IO;
#endregion
namespace Volpe.Cafe.Model.EIS
{
    [Serializable]
    class EisTailpipeEmissions : ICloneable
    {
        #region 
        [Serializable]
        public struct Mobile6Type : ICloneable
        {
            #region 
            public Mobile6Type(int length)
            {
                this.LDGV = new double[length, length];
                this.LDGT = new double[length, length];
                this.LDDV = new double[length, length];
                this.LDDT = new double[length, length];
            }
            #endregion
            #region 
            #region 
            object ICloneable.Clone()
            {
                return this.Clone();
            }
            public Mobile6Type Clone()
            {
                int         length = this.LDGV.Length;
                Mobile6Type m6Type = new Mobile6Type(length);
                int totalLength = length * length;
                Array.Copy(this.LDGV, 0, m6Type.LDGV, 0, totalLength);
                Array.Copy(this.LDGT, 0, m6Type.LDGT, 0, totalLength);
                Array.Copy(this.LDDV, 0, m6Type.LDDV, 0, totalLength);
                Array.Copy(this.LDDT, 0, m6Type.LDDT, 0, totalLength);
                return m6Type;
            }
            #endregion
            #endregion
            public double[,] LDGV;
            public double[,] LDGT;
            public double[,] LDDV;
            public double[,] LDDT;
        }
        #endregion
        #region 
        private EisTailpipeEmissions()
        {
        }
        public EisTailpipeEmissions(string path)
            : this(path, string.Empty)
        {
        }
        public EisTailpipeEmissions(string path, string password)
            : this()
        {
            Input input = new Input(path, password);
            try
            {   
                this.ParseFile(input);
            }
            catch (Exception ex)
            {   
                throw new InputException("Errors were encountered while parsing file: " + ex.Message, path, ex);
            }
            finally
            {   
                input.Close();
            }
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public EisTailpipeEmissions Clone()
        {
            EisTailpipeEmissions eis = new EisTailpipeEmissions();
            eis.MinYear      = this.MinYear;
            eis.MaxYear      = this.MaxYear;
            eis.Acetaldehyde = this.Acetaldehyde.Clone();
            eis.Acrolein     = this.Acrolein    .Clone();
            eis.Benzene      = this.Benzene     .Clone();
            eis.Butadiene    = this.Butadiene   .Clone();
            eis.CH4          = this.CH4         .Clone();
            eis.CO           = this.CO          .Clone();
            eis.DieselPM     = this.DieselPM    .Clone();
            eis.Formaldehyde = this.Formaldehyde.Clone();
            eis.MTBE         = this.MTBE        .Clone();
            eis.N2O          = this.N2O         .Clone();
            eis.NOx          = this.NOx         .Clone();
            eis.PM           = this.PM          .Clone();
            eis.VOC          = this.VOC         .Clone();
            return eis;
        }
        #endregion
        void ParseFile(Input input)
        {
            string[] sheets  = input.SheetNames;
            string[] names   = {
                                   "ACT_LDGV" , "ACT_LDGT" , "ACT_LDDV" , "ACT_LDDT" ,
                                   "ACR_LDGV" , "ACR_LDGT" , "ACR_LDDV" , "ACR_LDDT" ,
                                   "BNZ_LDGV" , "BNZ_LDGT" , "BNZ_LDDV" , "BNZ_LDDT" ,
                                   "BTD_LDGV" , "BTD_LDGT" , "BTD_LDDV" , "BTD_LDDT" ,
                                   "CH4_LDGV" , "CH4_LDGT" , "CH4_LDDV" , "CH4_LDDT" ,
                                   "CO_LDGV"  , "CO_LDGT"  , "CO_LDDV"  , "CO_LDDT"  ,
                                   "DSL_LDGV" , "DSL_LDGT" , "DSL_LDDV" , "DSL_LDDT" ,
                                   "FRM_LDGV" , "FRM_LDGT" , "FRM_LDDV" , "FRM_LDDT" ,
                                   "MTBE_LDGV", "MTBE_LDGT", "MTBE_LDDV", "MTBE_LDDT",
                                   "N2O_LDGV" , "N2O_LDGT" , "N2O_LDDV" , "N2O_LDDT" ,
                                   "NOX_LDGV" , "NOX_LDGT" , "NOX_LDDV" , "NOX_LDDT" ,
                                   "PM_LDGV"  , "PM_LDGT"  , "PM_LDDV"  , "PM_LDDT"  ,
                                   "VOC_LDGV" , "VOC_LDGT" , "VOC_LDDV" , "VOC_LDDT"
                               };
            int[] indexes = new int[names.Length];
            for (int i = 0; i < names.Length; i++) { indexes[i] = -1; }
            for (int i = 0; i < sheets.Length; i++)
            {
                for (int j = 0; j < names.Length; j++)
                {
                    if (input.Compare(sheets[i], names[j], false)) { indexes[j] = i; break; }
                }
            }
            input.VerifyIndexes(indexes, names);
            this.MinYear = 1975;
            this.MaxYear = 2060;
            int yearCount = this.MaxYear - this.MinYear + 1;
            this.Acetaldehyde = new Mobile6Type(yearCount);
            this.Acrolein     = new Mobile6Type(yearCount);
            this.Benzene      = new Mobile6Type(yearCount);
            this.Butadiene    = new Mobile6Type(yearCount);
            this.CH4          = new Mobile6Type(yearCount);
            this.CO           = new Mobile6Type(yearCount);
            this.DieselPM     = new Mobile6Type(yearCount);
            this.Formaldehyde = new Mobile6Type(yearCount);
            this.MTBE         = new Mobile6Type(yearCount);
            this.N2O          = new Mobile6Type(yearCount);
            this.NOx          = new Mobile6Type(yearCount);
            this.PM           = new Mobile6Type(yearCount);
            this.VOC          = new Mobile6Type(yearCount);
            Mobile6Type[] emissions = {
                                          this.Acetaldehyde, this.Acrolein, this.Benzene, this.Butadiene, this.CH4, this.CO,
                                          this.DieselPM, this.Formaldehyde, this.MTBE, this.N2O, this.NOx, this.PM, 
                                          this.VOC
                                      };
            for (int i = 0; i < names.Length; i++)
            {
                input.ActivateWorksheet(names[i]);
                int emIndex = i / 4;
                double[,] ld;
                switch (i % 4)
                {
                    case  0: ld = emissions[emIndex].LDGV; break;
                    case  1: ld = emissions[emIndex].LDGT; break;
                    case  2: ld = emissions[emIndex].LDDV; break;
                    case  3: ld = emissions[emIndex].LDDT; break;
                    default: ld = null;                    break;
                }
                for (int j = 0; j < yearCount; j++)     
                {
                    for (int k = 0; k < yearCount; k++) 
                    {
                        ld[j, k] = input.GetDouble(2 + j, 1 + k);
                    }
                }
            } 
        }
        #endregion
        #region 
        public int MinYear;     
        public int MaxYear;     
        public EisTailpipeEmissions.Mobile6Type Acetaldehyde;
        public EisTailpipeEmissions.Mobile6Type Acrolein;
        public EisTailpipeEmissions.Mobile6Type Benzene;
        public EisTailpipeEmissions.Mobile6Type Butadiene;
        public EisTailpipeEmissions.Mobile6Type CH4;
        public EisTailpipeEmissions.Mobile6Type CO;
        public EisTailpipeEmissions.Mobile6Type DieselPM;
        public EisTailpipeEmissions.Mobile6Type Formaldehyde;
        public EisTailpipeEmissions.Mobile6Type MTBE;
        public EisTailpipeEmissions.Mobile6Type N2O;
        public EisTailpipeEmissions.Mobile6Type NOx;
        public EisTailpipeEmissions.Mobile6Type PM;
        public EisTailpipeEmissions.Mobile6Type VOC;
        #endregion
    }
}

