using System;
using System.IO;
using Volpe.Cafe;
using Volpe.Cafe.Collections;
using Volpe.Cafe.Data;
using Volpe.Cafe.IO;
using Volpe.Cafe.Model;
using Volpe.Cafe.Settings;
using TI = Volpe.Cafe.TechnologyIndexes;
using TA = Volpe.Cafe.Model.TechnologyApplicability;
namespace Volpe.Cafe.Model
{
    [Serializable]
    public sealed class PredecessorsAndLegacies
    {
        #region 
        public static void ExamineVehicle(Vehicle veh, Scenario scen, ModelYear year, Industry data, ModelingSettings settings,
            int startYear, LogWriter logWriter)
        {
            TechnologyCollection technologies = settings.Technologies;
            Vehicle            pred = veh.Predecessor;
            VehicleDescription vd   = veh.Description;
            int             yrIndex   = year.Index;
            TechnologyClass techClass = veh.TechnologyClass;
            RegulatoryClass regClass  = veh.RegClass;
            double          vehSales  = vd.Sales[yrIndex];
            bool hasPred = (pred != null);
            bool usePred = hasPred && !veh.IsValid(yrIndex - 1);
            if (usePred)
            {   
                veh.SetEngineAndTransmissionFromPredecessor();
            }
            Engine       eng = veh.Engine;
            Transmission trn = veh.Transmission;
            VehicleModelingData   vmd = veh.ModelingData;
            ComponentModelingData emd = eng.ModelingData;
            ComponentModelingData tmd = trn.ModelingData;
            ComponentModelingData nmd = veh.NamePlate.ModelingData;
            VehicleModelingData   vmdPred = (usePred) ? pred.ModelingData : null;
            double initFe = vd.FuelEconomy;
            string strTechs      = string.Empty;
            int    affectedTechs = 0;
            double imprv         = 1;
            double cost          = 0;
            for (int k = 0; k < TI.TechnologyCount; k++)
            {
                Technology     tech = technologies[k];
                TechnologyType type = tech.Type;
                bool techUsed = !vmd.TechUsed[tech.Index] && 
                    ((type == TechnologyType.Engine     ) ? emd.TechUsed[tech.Index] :
                    (type == TechnologyType.Transmission) ? tmd.TechUsed[tech.Index] :
                    (type == TechnologyType.Aerodynamics) ? nmd.TechUsed[tech.Index] :
                    (usePred) ? (vmdPred.TechUsed[tech.Index] && vmdPred.TechApplied[tech.Index]) : false);
                if (techUsed)
                {   
                    vmd.TechUsed   [tech.Index] = true;
                    vmd.TechApplied[tech.Index] = true;
                    TechnologyApplicability.Enable(veh, year, tech.Index, settings);
                    cost  += TA.GetCost(tech, veh, data, settings.OperatingModes.TechnologyCostEstimates, year, startYear,
                        false, settings.OperatingModes.ClipTechCosts);
                    imprv *= (1 - TA.GetImprovement(tech, techClass, settings.OperatingModes.TechnologyFuelEstimates,
                        vmd.TechUsed, vmd.TechSuperseded, settings.OperatingModes.ClipTechImprovements));
                    if (TechnologyIndexes.IsMaterialSubstitution(tech.Index))
                    {   
                        vd.CurbWeight -= (vd.BaseWeight * tech.Attributes[techClass].Aux);
                    }
                    #region 
                    strTechs += ((affectedTechs == 0) ? tech.Abbr : ", " + tech.Abbr);
                    affectedTechs++;
                    #endregion
                } 
                if (usePred && vmdPred.TechLingering[tech.Index])
                {
                    vmd.TechLingering[tech.Index] = true;
                    vmd.TechLingerYear = new ModelYear(vmdPred.TechLingerYear.Year);
                }
            } 
            if (imprv != 1) { vd.FuelEconomy /= imprv; }
            #region 
            if (affectedTechs > 0)
            {   
                ComplianceWriter log    = logWriter.GetCompliance   (scen, year, veh.Manufacturer);
                ComplianceWriter extLog = logWriter.GetExtCompliance(scen, year, veh.Manufacturer);
                bool writeLog     = (log    != null);
                bool writeExtLog  = (extLog != null);
                if (writeLog || writeExtLog)
                {
                    double deltaCW = vd.CurbWeight  - vd.BaseWeight;
                    double deltaFE = vd.FuelEconomy - initFe;
                    string line =
                        "\tPred\t\t\t\t\t\t\t\t\t\t\t" +
                        vd.Code          .ToString()         + "\t" +
                        strTechs                             + "\t" +
                        year             .ToString(        ) + "\t" +
                        initFe           .ToString("0.####") + "\t" +
                        vd.FuelEconomy   .ToString("0.####") + "\t" +
                        vd.Sales[yrIndex].ToString(        ) + "\t" +
                        cost             .ToString("0.####") + "\t" +
                        imprv            .ToString("0.####") + "\t" +
                        deltaCW          .ToString("0.####") + "\t" +
                        deltaFE          .ToString("0.####") + "\t";
                    if (writeLog   ) { log   .Write((log   .LineCount + 1).ToString()); log   .WriteLine(line); }
                    if (writeExtLog) { extLog.Write((extLog.LineCount + 1).ToString()); extLog.WriteLine(line); }
                }
            }
            #endregion
        }
        #endregion
    }
}

