using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using Volpe.Cafe;
using Volpe.Cafe.Settings;
namespace Volpe.Cafe.Ui.Panels
{
    public class OptimizationPanel : Volpe.Cafe.Ui.Panels.CafeUserControl
    {
        #region 
        public OptimizationPanel()
        {
            this.InitializeComponent();
            this.PostInitialize();
        }
        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }
        #endregion
        #region 
        #region 
        void InitializeComponent()
        {
            this.ux_typeLabel = new System.Windows.Forms.Label();
            this.ux_typePanel = new System.Windows.Forms.Panel();
            this.ux_typeDefault = new System.Windows.Forms.RadioButton();
            this.ux_typeLightTruck = new System.Windows.Forms.RadioButton();
            this.ux_typePassengerAuto = new System.Windows.Forms.RadioButton();
            this.ux_modeLabel = new System.Windows.Forms.Label();
            this.ux_modePanel = new System.Windows.Forms.Panel();
            this.ux_modeZeroNetBenefits = new System.Windows.Forms.RadioButton();
            this.ux_modeMaximumNetBenefits = new System.Windows.Forms.RadioButton();
            this.ux_iterationOptionsLabel = new System.Windows.Forms.Label();
            this.ux_iterationOptionsPanel = new System.Windows.Forms.Panel();
            this.ux_iterationAboveOptimum = new System.Windows.Forms.TextBox();
            this.ux_iterationBelowOptimum = new System.Windows.Forms.TextBox();
            this.ux_iterationIncrement = new System.Windows.Forms.TextBox();
            this.ux_iterationIncrementLabel = new System.Windows.Forms.Label();
            this.ux_iterationBelowOptimumLabel = new System.Windows.Forms.Label();
            this.ux_iterationAboveOptimumLabel = new System.Windows.Forms.Label();
            this.ux_additionalOptionsLabel = new System.Windows.Forms.Label();
            this.ux_additionalOptionsPanel = new System.Windows.Forms.Panel();
            this.ux_optMergedFleet = new System.Windows.Forms.CheckBox();
            this.ux_typePanel.SuspendLayout();
            this.ux_modePanel.SuspendLayout();
            this.ux_iterationOptionsPanel.SuspendLayout();
            this.ux_additionalOptionsPanel.SuspendLayout();
            this.SuspendLayout();
            this.ux_typeLabel.Location = new System.Drawing.Point(8, 8);
            this.ux_typeLabel.Name = "ux_typeLabel";
            this.ux_typeLabel.Size = new System.Drawing.Size(176, 16);
            this.ux_typeLabel.TabIndex = 0;
            this.ux_typeLabel.Text = "What would you like to optimize?";
            this.ux_typePanel.Controls.Add(this.ux_typeDefault);
            this.ux_typePanel.Controls.Add(this.ux_typeLightTruck);
            this.ux_typePanel.Controls.Add(this.ux_typePassengerAuto);
            this.ux_typePanel.Location = new System.Drawing.Point(8, 16);
            this.ux_typePanel.Name = "ux_typePanel";
            this.ux_typePanel.Size = new System.Drawing.Size(384, 56);
            this.ux_typePanel.TabIndex = 1;
            this.ux_typeDefault.Checked = true;
            this.ux_typeDefault.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_typeDefault.Location = new System.Drawing.Point(8, 40);
            this.ux_typeDefault.Name = "ux_typeDefault";
            this.ux_typeDefault.Size = new System.Drawing.Size(264, 16);
            this.ux_typeDefault.TabIndex = 2;
            this.ux_typeDefault.TabStop = true;
            this.ux_typeDefault.Text = "Auto-detect based on the market data (default).";
            this.ux_typeLightTruck.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_typeLightTruck.Location = new System.Drawing.Point(8, 24);
            this.ux_typeLightTruck.Name = "ux_typeLightTruck";
            this.ux_typeLightTruck.Size = new System.Drawing.Size(64, 16);
            this.ux_typeLightTruck.TabIndex = 1;
            this.ux_typeLightTruck.Text = "Trucks,";
            this.ux_typePassengerAuto.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_typePassengerAuto.Location = new System.Drawing.Point(8, 8);
            this.ux_typePassengerAuto.Name = "ux_typePassengerAuto";
            this.ux_typePassengerAuto.Size = new System.Drawing.Size(56, 16);
            this.ux_typePassengerAuto.TabIndex = 0;
            this.ux_typePassengerAuto.Text = "Cars,";
            this.ux_modeLabel.Location = new System.Drawing.Point(8, 76);
            this.ux_modeLabel.Name = "ux_modeLabel";
            this.ux_modeLabel.Size = new System.Drawing.Size(248, 16);
            this.ux_modeLabel.TabIndex = 2;
            this.ux_modeLabel.Text = "Which optimization mode would you like to use?";
            this.ux_modePanel.Controls.Add(this.ux_modeZeroNetBenefits);
            this.ux_modePanel.Controls.Add(this.ux_modeMaximumNetBenefits);
            this.ux_modePanel.Location = new System.Drawing.Point(8, 84);
            this.ux_modePanel.Name = "ux_modePanel";
            this.ux_modePanel.Size = new System.Drawing.Size(384, 44);
            this.ux_modePanel.TabIndex = 3;
            this.ux_modeZeroNetBenefits.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_modeZeroNetBenefits.Location = new System.Drawing.Point(8, 24);
            this.ux_modeZeroNetBenefits.Name = "ux_modeZeroNetBenefits";
            this.ux_modeZeroNetBenefits.Size = new System.Drawing.Size(376, 16);
            this.ux_modeZeroNetBenefits.TabIndex = 1;
            this.ux_modeZeroNetBenefits.Text = "Optimize by minimizing Net Benefits, after the maximum has occurred.";
            this.ux_modeMaximumNetBenefits.Checked = true;
            this.ux_modeMaximumNetBenefits.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_modeMaximumNetBenefits.Location = new System.Drawing.Point(8, 8);
            this.ux_modeMaximumNetBenefits.Name = "ux_modeMaximumNetBenefits";
            this.ux_modeMaximumNetBenefits.Size = new System.Drawing.Size(288, 16);
            this.ux_modeMaximumNetBenefits.TabIndex = 0;
            this.ux_modeMaximumNetBenefits.TabStop = true;
            this.ux_modeMaximumNetBenefits.Text = "Optimize based on maximum Net Benefits (default),";
            this.ux_iterationOptionsLabel.Location = new System.Drawing.Point(8, 132);
            this.ux_iterationOptionsLabel.Name = "ux_iterationOptionsLabel";
            this.ux_iterationOptionsLabel.Size = new System.Drawing.Size(240, 16);
            this.ux_iterationOptionsLabel.TabIndex = 4;
            this.ux_iterationOptionsLabel.Text = "Please specify options for iterating the model:";
            this.ux_iterationOptionsPanel.Controls.Add(this.ux_iterationAboveOptimum);
            this.ux_iterationOptionsPanel.Controls.Add(this.ux_iterationBelowOptimum);
            this.ux_iterationOptionsPanel.Controls.Add(this.ux_iterationIncrement);
            this.ux_iterationOptionsPanel.Controls.Add(this.ux_iterationIncrementLabel);
            this.ux_iterationOptionsPanel.Controls.Add(this.ux_iterationBelowOptimumLabel);
            this.ux_iterationOptionsPanel.Controls.Add(this.ux_iterationAboveOptimumLabel);
            this.ux_iterationOptionsPanel.Location = new System.Drawing.Point(8, 140);
            this.ux_iterationOptionsPanel.Name = "ux_iterationOptionsPanel";
            this.ux_iterationOptionsPanel.Size = new System.Drawing.Size(384, 68);
            this.ux_iterationOptionsPanel.TabIndex = 5;
            this.ux_iterationAboveOptimum.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_iterationAboveOptimum.Location = new System.Drawing.Point(224, 8);
            this.ux_iterationAboveOptimum.Multiline = true;
            this.ux_iterationAboveOptimum.Name = "ux_iterationAboveOptimum";
            this.ux_iterationAboveOptimum.Size = new System.Drawing.Size(56, 18);
            this.ux_iterationAboveOptimum.TabIndex = 1;
            this.ux_iterationAboveOptimum.Text = "";
            this.ux_iterationAboveOptimum.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.ux_iterationAboveOptimum.WordWrap = false;
            this.ux_iterationBelowOptimum.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_iterationBelowOptimum.Location = new System.Drawing.Point(224, 28);
            this.ux_iterationBelowOptimum.Multiline = true;
            this.ux_iterationBelowOptimum.Name = "ux_iterationBelowOptimum";
            this.ux_iterationBelowOptimum.Size = new System.Drawing.Size(56, 18);
            this.ux_iterationBelowOptimum.TabIndex = 3;
            this.ux_iterationBelowOptimum.Text = "";
            this.ux_iterationBelowOptimum.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.ux_iterationBelowOptimum.WordWrap = false;
            this.ux_iterationIncrement.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_iterationIncrement.Location = new System.Drawing.Point(224, 48);
            this.ux_iterationIncrement.Multiline = true;
            this.ux_iterationIncrement.Name = "ux_iterationIncrement";
            this.ux_iterationIncrement.Size = new System.Drawing.Size(56, 18);
            this.ux_iterationIncrement.TabIndex = 5;
            this.ux_iterationIncrement.Text = "";
            this.ux_iterationIncrement.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.ux_iterationIncrement.WordWrap = false;
            this.ux_iterationIncrementLabel.Location = new System.Drawing.Point(8, 48);
            this.ux_iterationIncrementLabel.Name = "ux_iterationIncrementLabel";
            this.ux_iterationIncrementLabel.Size = new System.Drawing.Size(80, 16);
            this.ux_iterationIncrementLabel.TabIndex = 4;
            this.ux_iterationIncrementLabel.Text = "Increment by:";
            this.ux_iterationIncrementLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.ux_iterationBelowOptimumLabel.Location = new System.Drawing.Point(8, 28);
            this.ux_iterationBelowOptimumLabel.Name = "ux_iterationBelowOptimumLabel";
            this.ux_iterationBelowOptimumLabel.Size = new System.Drawing.Size(224, 16);
            this.ux_iterationBelowOptimumLabel.TabIndex = 2;
            this.ux_iterationBelowOptimumLabel.Text = "Iterations below optimum (more stringent):";
            this.ux_iterationBelowOptimumLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.ux_iterationAboveOptimumLabel.Location = new System.Drawing.Point(8, 8);
            this.ux_iterationAboveOptimumLabel.Name = "ux_iterationAboveOptimumLabel";
            this.ux_iterationAboveOptimumLabel.Size = new System.Drawing.Size(216, 16);
            this.ux_iterationAboveOptimumLabel.TabIndex = 0;
            this.ux_iterationAboveOptimumLabel.Text = "Iterations above optimum (less stringent):";
            this.ux_iterationAboveOptimumLabel.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.ux_additionalOptionsLabel.Location = new System.Drawing.Point(8, 212);
            this.ux_additionalOptionsLabel.Name = "ux_additionalOptionsLabel";
            this.ux_additionalOptionsLabel.Size = new System.Drawing.Size(168, 16);
            this.ux_additionalOptionsLabel.TabIndex = 6;
            this.ux_additionalOptionsLabel.Text = "Additional optimization options:";
            this.ux_additionalOptionsPanel.Controls.Add(this.ux_optMergedFleet);
            this.ux_additionalOptionsPanel.Location = new System.Drawing.Point(8, 220);
            this.ux_additionalOptionsPanel.Name = "ux_additionalOptionsPanel";
            this.ux_additionalOptionsPanel.Size = new System.Drawing.Size(384, 26);
            this.ux_additionalOptionsPanel.TabIndex = 7;
            this.ux_optMergedFleet.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.ux_optMergedFleet.Location = new System.Drawing.Point(8, 8);
            this.ux_optMergedFleet.Name = "ux_optMergedFleet";
            this.ux_optMergedFleet.Size = new System.Drawing.Size(200, 16);
            this.ux_optMergedFleet.TabIndex = 0;
            this.ux_optMergedFleet.Text = "Merge the fleet before optimizing.";
            this.Controls.Add(this.ux_additionalOptionsLabel);
            this.Controls.Add(this.ux_additionalOptionsPanel);
            this.Controls.Add(this.ux_iterationOptionsLabel);
            this.Controls.Add(this.ux_iterationOptionsPanel);
            this.Controls.Add(this.ux_modeLabel);
            this.Controls.Add(this.ux_modePanel);
            this.Controls.Add(this.ux_typeLabel);
            this.Controls.Add(this.ux_typePanel);
            this.Name = "OptimizationPanel";
            this.Size = new System.Drawing.Size(400, 256);
            this.ux_typePanel.ResumeLayout(false);
            this.ux_modePanel.ResumeLayout(false);
            this.ux_iterationOptionsPanel.ResumeLayout(false);
            this.ux_additionalOptionsPanel.ResumeLayout(false);
            this.ResumeLayout(false);
        }
        #endregion
        void PostInitialize()
        {
            this.AutoInitializeCheckChangesDetector(this.Controls);
            this.RegisterNumericTextControl(this.ux_iterationAboveOptimum, 100.0    , 0.0    , 1000.0    , "The number of iterations above optimum should be between 0 and 1000.", true, "0"      );
            this.RegisterNumericTextControl(this.ux_iterationBelowOptimum, 100.0    , 0.0    , 1000.0    , "The number of iterations below optimum should be between 0 and 1000.", true, "0"      );
            this.RegisterNumericTextControl(this.ux_iterationIncrement   ,   0.00010, 0.00001,    0.00500, "The iteration increment should be between 0.00001 and 0.005."        , true, "0.00000");
        }
        public void SetInitialState(OptimizationSettings optimizationSettings, int minYear, int maxYear)
        {
            this._optimizationSettings = optimizationSettings;
            if      (optimizationSettings.Type == OptimizationType.PassengerAuto) { this.ux_typePassengerAuto.Checked = true; }
            else if (optimizationSettings.Type == OptimizationType.LightTruck   ) { this.ux_typeLightTruck   .Checked = true; }
            else                                                                  { this.ux_typeDefault      .Checked = true; }
            if (optimizationSettings.Mode == OptimizationMode.ZeroNetBeneftis) { this.ux_modeZeroNetBenefits   .Checked = true; }
            else                                                               { this.ux_modeMaximumNetBenefits.Checked = true; }
            this.ux_iterationAboveOptimum.Text = optimizationSettings.AboveOptimum.ToString("0"      );
            this.ux_iterationBelowOptimum.Text = optimizationSettings.BelowOptimum.ToString("0"      );
            this.ux_iterationIncrement   .Text = optimizationSettings.Increment   .ToString("0.00000");
            this.ux_optMergedFleet       .Checked = optimizationSettings.MergedFleet;
            base.SaveChanges();
        }
        public override void SaveChanges()
        {
            if (this.SettingsChanged)
            {   
                this._optimizationSettings.Type = (this.ux_typePassengerAuto.Checked) ? OptimizationType.PassengerAuto :
                    (this.ux_typeLightTruck.Checked) ? OptimizationType.LightTruck : OptimizationType.Default;
                this._optimizationSettings.Mode = (this.ux_modeZeroNetBenefits.Checked) ? OptimizationMode.ZeroNetBeneftis :
                    OptimizationMode.MaximumNetBenefits;
                this._optimizationSettings.AboveOptimum = Global.GetInt32 (this.ux_iterationAboveOptimum.Text);
                this._optimizationSettings.BelowOptimum = Global.GetInt32 (this.ux_iterationBelowOptimum.Text);
                this._optimizationSettings.Increment    = Global.GetDouble(this.ux_iterationIncrement   .Text);
                this._optimizationSettings.MergedFleet = this.ux_optMergedFleet           .Checked;
                base.SaveChanges();
            }
        }
        #endregion
        #region 
        [Browsable(false)]
        public OptimizationSettings OptimizationSettings { get { return this._optimizationSettings; } }
        #endregion
        #region 
        #region 
        System.Windows.Forms.Label ux_typeLabel;
        System.Windows.Forms.Panel ux_typePanel;
        System.Windows.Forms.RadioButton ux_typePassengerAuto;
        System.Windows.Forms.RadioButton ux_typeLightTruck;
        System.Windows.Forms.RadioButton ux_typeDefault;
        System.Windows.Forms.Label ux_modeLabel;
        System.Windows.Forms.Panel ux_modePanel;
        System.Windows.Forms.RadioButton ux_modeMaximumNetBenefits;
        System.Windows.Forms.RadioButton ux_modeZeroNetBenefits;
        System.Windows.Forms.Label ux_iterationOptionsLabel;
        System.Windows.Forms.Panel ux_iterationOptionsPanel;
        System.Windows.Forms.TextBox ux_iterationAboveOptimum;
        System.Windows.Forms.TextBox ux_iterationBelowOptimum;
        System.Windows.Forms.TextBox ux_iterationIncrement;
        System.Windows.Forms.Label ux_iterationIncrementLabel;
        System.Windows.Forms.Label ux_iterationBelowOptimumLabel;
        System.Windows.Forms.Label ux_iterationAboveOptimumLabel;
        System.Windows.Forms.Label ux_additionalOptionsLabel;
        System.Windows.Forms.Panel ux_additionalOptionsPanel;
        System.Windows.Forms.CheckBox ux_optMergedFleet;
        #endregion
        OptimizationSettings _optimizationSettings;
        #endregion
    }
}

