using System;
using Volpe.Cafe.Data;
namespace Volpe.Cafe
{
    [Serializable]
    public struct BaselineInfo : ICloneable
    {
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public BaselineInfo Clone()
        {
            BaselineInfo bi = new BaselineInfo();
            if (this.ModelYear != null)
            {
                bi.ModelYear = new ModelYear(this.ModelYear.Year);
            }
            if (this.FinalFuelEconomy != null)
            {
                int ffeLen = this.FinalFuelEconomy.Length;
                bi.FinalFuelEconomy = new double[ffeLen][];
                for (int i = 0; i < ffeLen; i++)
                {
                    bi.FinalFuelEconomy[i] = (double[])Global.CloneArray(this.FinalFuelEconomy[i], typeof(double));
                }
            }
            bi.MfrSales              = (RCDouble[])Global.CloneArray(this.MfrSales             , typeof(RCDouble));
            bi.MfrTechCosts          = (RCDouble[])Global.CloneArray(this.MfrTechCosts         , typeof(RCDouble));
            bi.MfrFines              = (RCDouble[])Global.CloneArray(this.MfrFines             , typeof(RCDouble));
            bi.MfrRegCosts           = (RCDouble[])Global.CloneArray(this.MfrRegCosts          , typeof(RCDouble));
            bi.MfrFuelConsumption    = (RCDouble[])Global.CloneArray(this.MfrFuelConsumption   , typeof(RCDouble));
            bi.MfrDiscSocialBenefits = (RCDouble[])Global.CloneArray(this.MfrDiscSocialBenefits, typeof(RCDouble));
            return bi;
        }
        #endregion
        public bool IsEmpty()
        {
            return (
                this.ModelYear   == null && this.FinalFuelEconomy   == null &&
                this.MfrSales    == null && this.MfrTechCosts       == null && this.MfrFines              == null &&
                this.MfrRegCosts == null && this.MfrFuelConsumption == null && this.MfrDiscSocialBenefits == null);
        }
        public ModelYear ModelYear;
        public double[][] FinalFuelEconomy;
        public RCDouble[] MfrSales;
        public RCDouble[] MfrTechCosts;
        public RCDouble[] MfrFines;
        public RCDouble[] MfrRegCosts;
        public RCDouble[] MfrFuelConsumption;
        public RCDouble[] MfrDiscSocialBenefits;
    }
}

