using System;
using Volpe.Cafe;
using Volpe.Cafe.Collections;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public class Engine : Component, ICloneable
    {
        #region 
        private Engine()
            : base()
        {
        }
        public Engine(EngineDescription description)
            : base()
        {
            this._description = description;
            this._modelingData = new ComponentModelingData();
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public Engine Clone()
        {
            Engine eng = new Engine();
            eng._description = (EngineDescription)this._description.Clone();
            this.CopyTo(eng);
            return eng;
        }
        #endregion
        internal void SetParent(int parentCode)
        {
            if (parentCode != -1)
            {
                Engine[] engs = this._manufacturer.Engines.ToArray();
                for (int i = 0; i < engs.Length; i++)
                {
                    if (parentCode == engs[i]._description.Code)
                    {
                        this._parent = engs[i];
                        break;
                    }
                }
            }
        }
        internal void SetParent(Engine value)
        {
            this._parent = value;
        }
        public Engine Split(VehicleCollection vehicles, int newCode)
        {
            Engine eng = (Engine)this.Clone();
            newCode = Math.Max(newCode, eng._manufacturer.GetNextEngineCode());;
            eng._description.Code = newCode;
            eng._manufacturer.LastEngCode = newCode;
            for (int i = 0, vehCount = vehicles.Count; i < vehCount; i++)
            {
                vehicles[i].SetEngine(eng);
            }
            this.SplitTo(vehicles, eng);
            return eng;
        }
        #endregion
        #region 
        public EngineDescription Description
        {
            get { return this._description; }
        }
        public Engine Parent
        {
            get { return (Engine)this._parent; }
        }
        #endregion
        #region 
        private EngineDescription _description;
        #endregion
    }
}

