using System;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public struct M6Double
    {
        #region 
        static M6Double()
        {
            M6Double.Zero = new M6Double(0);
            M6Double.Zero = new M6Double(1);
        }
        M6Double(double value)
            : this(value, value, value, value, value, value, value, value)
        {
        }
        M6Double(double ldgv, double lddv, double ldgt1, double lddt1, double ldgt2, double lddt2, double hdgv2b, double hddv2b)
        {
            this.Ldgv   = ldgv;
            this.Lddv   = lddv;
            this.Ldgt1  = ldgt1;
            this.Lddt1  = lddt1;
            this.Ldgt2  = ldgt2;
            this.Lddt2  = lddt2;
            this.Hdgv2b = hdgv2b;
            this.Hddv2b = hddv2b;
        }
        #endregion
        #region 
        #region 
        public static M6Double operator +(M6Double value1, M6Double value2)
        {
            return new M6Double(
                value1.Ldgv   + value2.Ldgv  , value1.Lddv   + value2.Lddv,
                value1.Ldgt1  + value2.Ldgt1 , value1.Lddt1  + value2.Lddt1,
                value1.Ldgt2  + value2.Ldgt2 , value1.Lddt2  + value2.Lddt2,
                value1.Hdgv2b + value2.Hdgv2b, value1.Hddv2b + value2.Hddv2b);
        }
        public static M6Double operator +(M6Double value1, double value2)
        {
            return value1 + new M6Double(value2);
        }
        public static M6Double operator +(double value1, M6Double value2)
        {
            return new M6Double(value1) + value2;
        }
        public static M6Double operator +(M6Double value1, int value2)
        {
            return value1 + new M6Double(value2);
        }
        public static M6Double operator +(int value1, M6Double value2)
        {
            return new M6Double(value1) + value2;
        }
        public static M6Double operator -(M6Double value1, M6Double value2)
        {
            return new M6Double(
                value1.Ldgv   - value2.Ldgv  , value1.Lddv   - value2.Lddv,
                value1.Ldgt1  - value2.Ldgt1 , value1.Lddt1  - value2.Lddt1,
                value1.Ldgt2  - value2.Ldgt2 , value1.Lddt2  - value2.Lddt2,
                value1.Hdgv2b - value2.Hdgv2b, value1.Hddv2b - value2.Hddv2b);
        }
        public static M6Double operator -(M6Double value1, double value2)
        {
            return value1 - new M6Double(value2);
        }
        public static M6Double operator -(double value1, M6Double value2)
        {
            return new M6Double(value1) - value2;
        }
        public static M6Double operator -(M6Double value1, int value2)
        {
            return value1 - new M6Double(value2);
        }
        public static M6Double operator -(int value1, M6Double value2)
        {
            return new M6Double(value1) - value2;
        }
        public static M6Double operator *(M6Double value1, M6Double value2)
        {
            return new M6Double(
                value1.Ldgv   * value2.Ldgv  , value1.Lddv   * value2.Lddv,
                value1.Ldgt1  * value2.Ldgt1 , value1.Lddt1  * value2.Lddt1,
                value1.Ldgt2  * value2.Ldgt2 , value1.Lddt2  * value2.Lddt2,
                value1.Hdgv2b * value2.Hdgv2b, value1.Hddv2b * value2.Hddv2b);
        }
        public static M6Double operator *(M6Double value1, double value2)
        {
            return value1 * new M6Double(value2);
        }
        public static M6Double operator *(double value1, M6Double value2)
        {
            return new M6Double(value1) * value2;
        }
        public static M6Double operator *(M6Double value1, int value2)
        {
            return value1 * new M6Double(value2);
        }
        public static M6Double operator *(int value1, M6Double value2)
        {
            return new M6Double(value1) * value2;
        }
        public static M6Double operator /(M6Double value1, M6Double value2)
        {
            return new M6Double(
                value1.Ldgv   / value2.Ldgv  , value1.Lddv   / value2.Lddv,
                value1.Ldgt1  / value2.Ldgt1 , value1.Lddt1  / value2.Lddt1,
                value1.Ldgt2  / value2.Ldgt2 , value1.Lddt2  / value2.Lddt2,
                value1.Hdgv2b / value2.Hdgv2b, value1.Hddv2b / value2.Hddv2b);
        }
        public static M6Double operator /(M6Double value1, double value2)
        {
            return value1 / new M6Double(value2);
        }
        public static M6Double operator /(double value1, M6Double value2)
        {
            return new M6Double(value1) / value2;
        }
        public static M6Double operator /(M6Double value1, int value2)
        {
            return value1 / new M6Double(value2);
        }
        public static M6Double operator /(int value1, M6Double value2)
        {
            return new M6Double(value1) / value2;
        }
        public static M6Double operator +(M6Double value)
        {
            return M6Double.Zero + value;
        }
        public static M6Double operator -(M6Double value)
        {
            return M6Double.Zero - value;
        }
        public static M6Double operator ++(M6Double value)
        {
            return value + M6Double.One;
        }
        public static M6Double operator --(M6Double value)
        {
            return value - M6Double.One;
        }
        public static bool operator ==(M6Double value1, M6Double value2)
        {
            return value1.Equals(value2);
        }
        public static bool operator !=(M6Double value1, M6Double value2)
        {
            return !value1.Equals(value2);
        }
        #endregion
        public override string ToString()
        {
            return
                "{Gasoline=" + this.Gasoline.ToString() +
                " (Ldgv="    + this.Ldgv    .ToString() +
                ", Ldgt1="   + this.Ldgt1   .ToString() +
                ", Ldgt2="   + this.Ldgt2   .ToString() +
                ", Hdgv2b="  + this.Hdgv2b  .ToString() +
                "), Diesel=" + this.Diesel  .ToString() +
                " (Lddv="    + this.Lddv    .ToString() +
                ", Lddt1="   + this.Lddt1   .ToString() +
                ", Lddt2="   + this.Lddt2   .ToString() +
                ", Hddv2b="  + this.Hddv2b  .ToString() +
                "), Total="  + this.Total   .ToString() + "}";
        }
        public override int GetHashCode()
        {
            return (
                this.Ldgv  .GetHashCode() ^ this.Lddv  .GetHashCode() ^
                this.Ldgt1 .GetHashCode() ^ this.Lddt1 .GetHashCode() ^
                this.Ldgt2 .GetHashCode() ^ this.Lddt2 .GetHashCode() ^
                this.Hdgv2b.GetHashCode() ^ this.Hddv2b.GetHashCode());
        }
        public override bool Equals(object obj)
        {
            if (obj is M6Double) { return this.Equals((M6Double)obj); }
            else                 { return base.Equals(obj); }
        }
        public bool Equals(M6Double value)
        {
            return (
                this.Ldgv   == value.Ldgv   && this.Lddv   == value.Lddv  &&
                this.Ldgt1  == value.Ldgt1  && this.Lddt1  == value.Lddt1 &&
                this.Ldgt2  == value.Ldgt2  && this.Lddt2  == value.Lddt2 &&
                this.Hdgv2b == value.Hdgv2b && this.Hddv2b == value.Hddv2b);
        }
        public double Value(Mobile6Class mobile6Class)
        {
            return
                (mobile6Class == Mobile6Class.Ldgv  ) ? this.Ldgv   :
                (mobile6Class == Mobile6Class.Lddv  ) ? this.Lddv   :
                (mobile6Class == Mobile6Class.Ldgt1 ) ? this.Ldgt1  :
                (mobile6Class == Mobile6Class.Lddt1 ) ? this.Lddt1  :
                (mobile6Class == Mobile6Class.Ldgt2 ) ? this.Ldgt2  :
                (mobile6Class == Mobile6Class.Lddt2 ) ? this.Lddt2  :
                (mobile6Class == Mobile6Class.Hdgv2b) ? this.Hdgv2b :
                (mobile6Class == Mobile6Class.Hddv2b) ? this.Hddv2b : 0;
        }
        public void ZeroNaNs()
        {
            if (double.IsNaN(this.Ldgv  )) { this.Ldgv   = 0.0; }
            if (double.IsNaN(this.Lddv  )) { this.Lddv   = 0.0; }
            if (double.IsNaN(this.Ldgt1 )) { this.Ldgt1  = 0.0; }
            if (double.IsNaN(this.Lddt1 )) { this.Lddt1  = 0.0; }
            if (double.IsNaN(this.Ldgt2 )) { this.Ldgt2  = 0.0; }
            if (double.IsNaN(this.Lddt2 )) { this.Lddt2  = 0.0; }
            if (double.IsNaN(this.Hdgv2b)) { this.Hdgv2b = 0.0; }
            if (double.IsNaN(this.Hddv2b)) { this.Hddv2b = 0.0; }
        }
        public void Clear()
        {
            this.Ldgv = 0.0;    this.Ldgt1 = 0.0;    this.Ldgt2 = 0.0;    this.Hdgv2b = 0.0;
            this.Lddv = 0.0;    this.Lddt1 = 0.0;    this.Lddt2 = 0.0;    this.Hddv2b = 0.0;
        }
        #endregion
        #region 
        public double this[Mobile6Class mobile6Class]
        {
            get { return this.Value(mobile6Class); }
            set
            {
                if      (mobile6Class == Mobile6Class.Ldgv  ) { this.Ldgv   = value; }
                else if (mobile6Class == Mobile6Class.Lddv  ) { this.Lddv   = value; }
                else if (mobile6Class == Mobile6Class.Ldgt1 ) { this.Ldgt1  = value; }
                else if (mobile6Class == Mobile6Class.Lddt1 ) { this.Lddt1  = value; }
                else if (mobile6Class == Mobile6Class.Ldgt2 ) { this.Ldgt2  = value; }
                else if (mobile6Class == Mobile6Class.Lddt2 ) { this.Lddt2  = value; }
                else if (mobile6Class == Mobile6Class.Hdgv2b) { this.Hdgv2b = value; }
                else if (mobile6Class == Mobile6Class.Hddv2b) { this.Hddv2b = value; }
            }
        }
        public double Gasoline
        {
            get
            {
                if (double.IsNaN(this.Ldgv) && double.IsNaN(this.Ldgt1) && double.IsNaN(this.Ldgt2) && double.IsNaN(this.Hdgv2b))
                {
                    return double.NaN;
                }
                else
                {
                    return (double.IsNaN(this.Ldgv  ) ? 0 : this.Ldgv  ) +
                           (double.IsNaN(this.Ldgt1 ) ? 0 : this.Ldgt1 ) +
                           (double.IsNaN(this.Ldgt2 ) ? 0 : this.Ldgt2 ) +
                           (double.IsNaN(this.Hdgv2b) ? 0 : this.Hdgv2b);
                }
            }
        }
        public double Diesel
        {
            get
            {
                if (double.IsNaN(this.Lddv) && double.IsNaN(this.Lddt1) && double.IsNaN(this.Lddt2) && double.IsNaN(this.Hddv2b))
                {
                    return double.NaN;
                }
                else
                {
                    return (double.IsNaN(this.Lddv  ) ? 0 : this.Lddv  ) +
                           (double.IsNaN(this.Lddt1 ) ? 0 : this.Lddt1 ) +
                           (double.IsNaN(this.Lddt2 ) ? 0 : this.Lddt2 ) +
                           (double.IsNaN(this.Hddv2b) ? 0 : this.Hddv2b);
                }
            }
        }
        public double Total
        {
            get
            {
                double g = this.Gasoline, d = this.Diesel;
                if (double.IsNaN(g) && double.IsNaN(d))
                {
                    return double.NaN;
                }
                else
                {
                    return (double.IsNaN(g) ? 0 : g) + (double.IsNaN(d) ? 0 : d);
                }
            }
        }
        #endregion
        #region 
        public static readonly M6Double Zero;
        public static readonly M6Double One;
        public double Ldgv;
        public double Lddv;
        public double Ldgt1;
        public double Lddt1;
        public double Ldgt2;
        public double Lddt2;
        public double Hdgv2b;
        public double Hddv2b;
        #endregion
    }
}

