using System;
namespace Volpe.Cafe.Data
{
    [Serializable]
    public class VehicleModelingData : ICloneable
    {
        #region 
        public VehicleModelingData()
        {
        }
        #endregion
        #region 
        #region 
        object ICloneable.Clone()
        {
            return this.Clone();
        }
        public VehicleModelingData Clone()
        {
            VehicleModelingData cv   = new VehicleModelingData();
            cv.TechCost              = this.TechCost;
            cv.RegCost               = this.RegCost;
            cv.SalesOverFe           = this.SalesOverFe;
            cv.TechAvailable         = (bool[])Global.CloneArray(this.TechAvailable        , typeof(bool));
            cv.TechEnabled           = (bool[])Global.CloneArray(this.TechEnabled          , typeof(bool));
            cv.TechUsed              = (bool[])Global.CloneArray(this.TechUsed             , typeof(bool));
            cv.TechApplied           = (bool[])Global.CloneArray(this.TechApplied          , typeof(bool));
            cv.TechSuperseded        = (bool[])Global.CloneArray(this.TechSuperseded       , typeof(bool));
            cv.TechBackfilled        = (bool[])Global.CloneArray(this.TechBackfilled       , typeof(bool));
            cv.TechPhaseInBackfilled = (bool[])Global.CloneArray(this.TechPhaseInBackfilled, typeof(bool));
            cv.TechIgnored           = (bool[])Global.CloneArray(this.TechIgnored          , typeof(bool));
            cv.TechReserved          = (bool[])Global.CloneArray(this.TechReserved         , typeof(bool));
            cv.TechLingering         = (bool[])Global.CloneArray(this.TechLingering        , typeof(bool));
            if (this.TechLingerYear != null)
            {
                cv.TechLingerYear = new ModelYear(this.TechLingerYear.Year);
            }
            return cv;
        }
        #endregion
        #endregion
        #region 
        public double TechCost;
        public double RegCost;
        public double SalesOverFe;
        public bool[] TechAvailable;
        public bool[] TechEnabled;
        public bool[] TechUsed;
        public bool[] TechApplied;
        public bool[] TechSuperseded;
        public bool[] TechBackfilled;
        public bool[] TechPhaseInBackfilled;
        public bool[] TechIgnored;
        public bool[] TechReserved;
        public bool[] TechLingering;
        public ModelYear TechLingerYear;
        #endregion
    }
}

