using System;
using System.Drawing;
using Volpe.Cafe;
using Volpe.Cafe.Collections;
using Volpe.Utils;
namespace Volpe.Cafe.IO
{
    public class Scenarios : Input
    {
        #region 
        public Scenarios(string path)
            : this(path, null)
        {
        }
        public Scenarios(string path, string password)
            : base(path, password)
        {
            try
            {   
                this.ParseFile();
            }
            catch (Exception ex)
            {   
                throw new InputException("Errors were encountered while parsing file: " + ex.Message, path, ex);
            }
            finally
            {   
                this.Close();
            }
        }
        #endregion
        #region 
        private void ParseFile()
        {
            this._data = new ScenarioCollection();
            string[] sheets = this.SheetNames;
            for (int i = 0; i < sheets.Length; i++)
            {
                string sheet = sheets[i];
                if (sheet.ToUpper().StartsWith("SCEN_"))
                {
                    this.ActivateWorksheet(sheets[i], new XlCell(1, 1), this._xlu.GetLastCell(sheet));
                    Scenario sn = new Scenario(this, this._data.Count);
                    this._data.Add(sn);
                }
            }
        }
        #endregion
        #region 
        public ScenarioCollection Data { get { return this._data; } }
        #endregion
        #region 
        private ScenarioCollection _data;
        #endregion
    }
}

