using System;
using Volpe.Cafe.IO;
namespace Volpe.Cafe.Settings
{
    [Serializable]
    public struct EISSettings
    {
        #region 
        internal void WriteSummaryLog(LogWriter writer)
        {
            if (writer.Summary == null) { return; }
            string outStr = "--- EIS Settings ---"                           +
                "\n  RunEISModelFlatCAFE="      + this.RunEISModelFlatCAFE +
                "\n  RunEISModelGrowCAFE="      + this.RunEISModelGrowCAFE +
                "\n  EISParametersFile="        + this.EISParametersFile   +
                "\n  EISTailpipeEmissionsFile=" + this.EISTailpipeEmissionsFile;
            writer.Summary.WriteLine(outStr + "\n");
        }
        #endregion
        #region 
        public bool RunEISModelFlatCAFE;
        public bool RunEISModelGrowCAFE;
        public string EISParametersFile;
        public string EISTailpipeEmissionsFile;
        #endregion
    }
}

