using Microsoft.Win32;
using System;
using System.Reflection;
using System.Windows.Forms;
namespace Volpe.Utils
{
    [Serializable]
    public class RegEdit
    {
        #region 
        [Serializable]
        public class CurrentUser : RegEdit
        {
            #region 
            public CurrentUser(string path) : this(path, false)
            {
            }
            public CurrentUser(string path, bool writable) : base(Registry.CurrentUser, path, writable)
            {
            }
            ~CurrentUser()
            {
                this.Close();
            }
            #endregion
        }
        [Serializable]
        public class LocalMachine : RegEdit
        {
            #region 
            public LocalMachine(string path) : this(path, false)
            {
            }
            public LocalMachine(string path, bool writable) : base(Registry.CurrentUser, path, writable)
            {
            }
            ~LocalMachine()
            {
                this.Close();
            }
            #endregion
        }
        #endregion
        #region 
        public RegEdit(RegistryKey baseKey, string path) : this(baseKey, path, false)
        {
        }
        public RegEdit(RegistryKey baseKey, string path, bool writable)
        {
            this._key = this.Open(baseKey, path, writable);
        }
        ~RegEdit()
        {
            this.Close();
        }
        #endregion
        #region 
        protected RegistryKey Open(RegistryKey baseKey, string path, bool writable)
        {
            if (baseKey.OpenSubKey(path) == null) { baseKey.CreateSubKey(path); }
            return baseKey.OpenSubKey(path, writable);;
        }
        protected void Close()
        {
            this._key.Close();
        }
        public void CreateSubKey(string subkey)
        {
            this._key.CreateSubKey(subkey);
        }
        public void LoadData(object obj)
        {
            this.LoadData(this._key, obj);
        }
        public void LoadData(string subkey, object obj)
        {
            this.LoadData(this._key.OpenSubKey(subkey), obj);
        }
        public void SaveData(object obj)
        {
            this.SaveData(this._key, obj);
        }
        public void SaveData(string subkey, object obj)
        {
            this.SaveData(this._key.CreateSubKey(subkey), obj);
        }
        private void LoadData(RegistryKey key, object obj)
        {
            if (obj == null)
            {
                throw new System.ArgumentNullException("obj", "Value cannot be null.");
            }
            if (key != null)
            {
                FieldInfo[] fields = this.GetFields(obj);
                for (int i = 0; i < fields.Length; i++)
                {
                    if (!fields[i].IsStatic && !fields[i].IsInitOnly)
                    {
                        object value = key.GetValue(fields[i].Name, fields[i].GetValue(obj));
                        switch (fields[i].FieldType.Name)
                        {
                            case "Boolean":
                                fields[i].SetValue(obj, Boolean.Parse(value.ToString()));
                                break;
                            case "Int64":
                                fields[i].SetValue(obj, Int64.Parse(value.ToString()));
                                break;
                            case "UInt64":
                                fields[i].SetValue(obj, UInt64.Parse(value.ToString()));
                                break;
                            default:
                                fields[i].SetValue(obj, value);
                                break;
                        }
                    }
                } 
            } 
        }
        private void SaveData(RegistryKey key, object obj)
        {
            if (obj == null)
            {
                throw new System.ArgumentNullException("obj", "Value cannot be null.");
            }
            if (key != null)
            {
                FieldInfo[] fields = this.GetFields(obj);
                for (int i = 0; i < fields.Length; i++)
                {
                    if (!fields[i].IsStatic && !fields[i].IsInitOnly)
                    {
                        key.SetValue(fields[i].Name, fields[i].GetValue(obj));
                    }
                }
            } 
        }
        private FieldInfo[] GetFields(object obj)
        {
            return obj.GetType().GetFields();
        }
        #endregion
        #region 
        public static string DefaultKeyPath
        {
            get { return "Software\\" + Application.CompanyName + "\\" + Application.ProductName; }
        }
        public RegistryKey Key { get { return this._key; } }
        #endregion
        #region 
        private RegistryKey _key;
        #endregion
    }
}

