using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using Volpe.Cafe;
using Volpe.Cafe.Ui.Panels;
namespace Volpe.Cafe.Ui
{
    public class ManageInput : System.Windows.Forms.Form
    {
        #region 
        public ManageInput(InputSettings inputSettings, string inputPassword)
        {
            this.InitializeComponent();
            this._inputSettings = inputSettings;
            this._inputPassword = inputPassword;
            this._settingsChanged = false;
        }
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }
        #endregion
        #region 
        #region 
        private void InitializeComponent()
        {
            this.ux_introLabel = new System.Windows.Forms.Label();
            this.ux_statusTextBox = new System.Windows.Forms.RichTextBox();
            this.ux_statusContextMenu = new System.Windows.Forms.ContextMenu();
            this.ux_statusMenu_CopyMessages = new System.Windows.Forms.MenuItem();
            this.ux_statusMenu_ClearMessages = new System.Windows.Forms.MenuItem();
            this.ux_closeLabelButton = new Volpe.Cafe.Ui.LabelButton();
            this.ux_saveLabelButton = new Volpe.Cafe.Ui.LabelButton();
            this.ux_inputPanel = new Volpe.Cafe.Ui.Panels.InputPanel();
            this.SuspendLayout();
            this.ux_introLabel.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_introLabel.Location = new System.Drawing.Point(8, 8);
            this.ux_introLabel.Name = "ux_introLabel";
            this.ux_introLabel.Size = new System.Drawing.Size(360, 48);
            this.ux_introLabel.TabIndex = 1;
            this.ux_introLabel.Text = "The Manage Input window allows you to load data from Excel workbooks.  To begin, " +
                "drag and drop an Excel workbook in to this window, or click the Browse button fo" +
                "r the file you want to load.";
            this.ux_statusTextBox.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_statusTextBox.BackColor = System.Drawing.SystemColors.Control;
            this.ux_statusTextBox.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.ux_statusTextBox.ContextMenu = this.ux_statusContextMenu;
            this.ux_statusTextBox.ForeColor = System.Drawing.Color.Black;
            this.ux_statusTextBox.Location = new System.Drawing.Point(8, 288);
            this.ux_statusTextBox.Name = "ux_statusTextBox";
            this.ux_statusTextBox.ReadOnly = true;
            this.ux_statusTextBox.ScrollBars = System.Windows.Forms.RichTextBoxScrollBars.Vertical;
            this.ux_statusTextBox.Size = new System.Drawing.Size(272, 64);
            this.ux_statusTextBox.TabIndex = 2;
            this.ux_statusTextBox.TabStop = false;
            this.ux_statusTextBox.Text = "Ready.";
            this.ux_statusContextMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                                 this.ux_statusMenu_CopyMessages,
                                                                                                 this.ux_statusMenu_ClearMessages});
            this.ux_statusMenu_CopyMessages.Index = 0;
            this.ux_statusMenu_CopyMessages.Text = "Copy Messages";
            this.ux_statusMenu_CopyMessages.Click += new System.EventHandler(this.StatusMenu_CopyMessages_Click);
            this.ux_statusMenu_ClearMessages.Index = 1;
            this.ux_statusMenu_ClearMessages.Text = "Clear Messages";
            this.ux_statusMenu_ClearMessages.Click += new System.EventHandler(this.StatusMenu_ClearMessages_Click);
            this.ux_closeLabelButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_closeLabelButton.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_closeLabelButton.Location = new System.Drawing.Point(328, 312);
            this.ux_closeLabelButton.Name = "ux_closeLabelButton";
            this.ux_closeLabelButton.Size = new System.Drawing.Size(32, 32);
            this.ux_closeLabelButton.TabIndex = 4;
            this.ux_closeLabelButton.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.ux_closeLabelButton.Click += new System.EventHandler(this.CloseLabelButton_Click);
            this.ux_saveLabelButton.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_saveLabelButton.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_saveLabelButton.Location = new System.Drawing.Point(288, 312);
            this.ux_saveLabelButton.Name = "ux_saveLabelButton";
            this.ux_saveLabelButton.Size = new System.Drawing.Size(32, 32);
            this.ux_saveLabelButton.TabIndex = 3;
            this.ux_saveLabelButton.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.ux_saveLabelButton.Click += new System.EventHandler(this.SaveLabelButton_Click);
            this.ux_inputPanel.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
                | System.Windows.Forms.AnchorStyles.Right)));
            this.ux_inputPanel.Location = new System.Drawing.Point(0, 56);
            this.ux_inputPanel.Name = "ux_inputPanel";
            this.ux_inputPanel.ShowEmissions = false;
            this.ux_inputPanel.ShowMarketData = false;
            this.ux_inputPanel.ShowParameters = false;
            this.ux_inputPanel.ShowScenarios = false;
            this.ux_inputPanel.ShowTechnologies = false;
            this.ux_inputPanel.Size = new System.Drawing.Size(376, 232);
            this.ux_inputPanel.TabIndex = 1;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 14);
            this.ClientSize = new System.Drawing.Size(378, 359);
            this.Controls.Add(this.ux_statusTextBox);
            this.Controls.Add(this.ux_inputPanel);
            this.Controls.Add(this.ux_closeLabelButton);
            this.Controls.Add(this.ux_saveLabelButton);
            this.Controls.Add(this.ux_introLabel);
            this.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.HelpButton = true;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "ManageInput";
            this.ShowInTaskbar = false;
            this.Text = "Manage Input";
            this.Load += new System.EventHandler(this.ManageInput_Load);
            this.ResumeLayout(false);
        }
        #endregion
        #region 
        private void ManageInput_Idle(object sender, EventArgs e)
        {
            this.ux_saveLabelButton.Enabled = this.ux_inputPanel.SettingsChanged;
        }
        private void ManageInput_Load(object sender, System.EventArgs e)
        {
            this.Font = Cafe2d.DefaultFont;
            this.ux_saveLabelButton.ThemeInitialize("ok", true);
            this.ux_closeLabelButton.ThemeInitialize("cancel", true);
            this.ux_inputPanel.InputStateChanged += new InputStateChangedEventHandler(this.InputPanel_InputStateChanged);
            this.ux_inputPanel.Messages.MessagesChanged += new EventHandler(this.Messages_MessagesChanged);
            this.ux_inputPanel.SetInitialState(this._inputSettings, this._inputPassword);
            Application.Idle += new EventHandler(this.ManageInput_Idle);
            this.Closing += new CancelEventHandler(this.ManageInput_Closing);
        }
        private void ManageInput_Closing(object sender, CancelEventArgs e)
        {
            Application.Idle -= new EventHandler(this.ManageInput_Idle);
        }
        private void InputPanel_InputStateChanged(object sender, bool enabled)
        {
            this.ux_saveLabelButton.Enabled = enabled;
            this.ux_closeLabelButton.Enabled = enabled;
        }
        private void Messages_MessagesChanged(object sender, EventArgs e)
        {
            this.Messages_MessagesChanged_InvokeHelper();
        }
        private void Messages_MessagesChanged_InvokeHelper()
        {
            if (this.ux_statusTextBox.InvokeRequired)
            {
                this.ux_statusTextBox.Invoke(new EmptyEventHandler(this.Messages_MessagesChanged_InvokeHelper));
            }
            else
            {
                this.ux_statusTextBox.Rtf = this.ux_inputPanel.Messages.ToString();
                this.ux_statusTextBox.Enabled = this.ux_statusTextBox.Text != "";
            }
        }
        private void StatusMenu_CopyMessages_Click(object sender, System.EventArgs e)
        {
            Clipboard.SetDataObject(this.ux_statusTextBox.Text, true);
        }
        private void StatusMenu_ClearMessages_Click(object sender, System.EventArgs e)
        {
            this.ux_inputPanel.Messages.ClearMessages();
        }
        private void SaveLabelButton_Click(object sender, System.EventArgs e)
        {
            if (this.ux_inputPanel.SettingsChanged)
            {
                this._settingsChanged = true;
                this.ux_inputPanel.SaveChanges();
            }
        }
        private void CloseLabelButton_Click(object sender, System.EventArgs e)
        {
            this.DialogResult = DialogResult.OK;
        }
        #endregion
        #endregion
        #region 
        public bool ShowMarketData
        {
            get { return this.ux_inputPanel.ShowMarketData; }
            set { this.ux_inputPanel.ShowMarketData = value; }
        }
        public bool ShowTechnologies
        {
            get { return this.ux_inputPanel.ShowTechnologies; }
            set { this.ux_inputPanel.ShowTechnologies = value; }
        }
        public bool ShowParameters
        {
            get { return this.ux_inputPanel.ShowParameters; }
            set { this.ux_inputPanel.ShowParameters = value; }
        }
        public bool ShowEmissions
        {
            get { return this.ux_inputPanel.ShowEmissions; }
            set { this.ux_inputPanel.ShowEmissions = value; }        
        }
        public bool ShowScenarios
        {
            get { return this.ux_inputPanel.ShowScenarios; }
            set { this.ux_inputPanel.ShowScenarios = value; }        
        }
        public InputPanel InputPanel
        {
            get
            {
                return this.ux_inputPanel;
            }
        }
        public bool SettingsChanged
        {
            get
            {
                return this._settingsChanged;
            }
        }
        #endregion
        #region 
        #region 
        private System.Windows.Forms.Label ux_introLabel;
        private Volpe.Cafe.Ui.LabelButton ux_closeLabelButton;
        private Volpe.Cafe.Ui.LabelButton ux_saveLabelButton;
        private Volpe.Cafe.Ui.Panels.InputPanel ux_inputPanel;
        private System.Windows.Forms.RichTextBox ux_statusTextBox;
        private System.Windows.Forms.ContextMenu ux_statusContextMenu;
        private System.Windows.Forms.MenuItem ux_statusMenu_CopyMessages;
        private System.Windows.Forms.MenuItem ux_statusMenu_ClearMessages;
        private System.ComponentModel.Container components = null;
        #endregion
        private InputSettings _inputSettings;
        private string _inputPassword;
        private bool _settingsChanged;
        #endregion
    }
}

