using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using Volpe.Cafe;
namespace Volpe.Cafe.Ui.Panels
{
    public class EncryptionPanel : CafeUiPanel
    {
        #region 
        public EncryptionPanel()
        {
            this.InitializeComponent();
            this.InitializeControls();
            this.InitializeEventHandlers();
            this.SaveTextChanges();
        }
        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }
        #endregion
        #region 
        #region 
        private void InitializeComponent()
        {
            this.ux_encryptInputCheckBox = new System.Windows.Forms.CheckBox();
            this.ux_encryptInputGroupBox = new System.Windows.Forms.GroupBox();
            this.ux_inputPasswordLabel = new System.Windows.Forms.Label();
            this.ux_inputPasswordTextBox = new System.Windows.Forms.TextBox();
            this.ux_verifyInputPasswordLabel = new System.Windows.Forms.Label();
            this.ux_verifyInputPasswordTextBox = new System.Windows.Forms.TextBox();
            this.ux_encryptOutputCheckBox = new System.Windows.Forms.CheckBox();
            this.ux_encryptOutputGroupBox = new System.Windows.Forms.GroupBox();
            this.ux_encryptionTypeLabel = new System.Windows.Forms.Label();
            this.ux_encryptionTypeComboBox = new System.Windows.Forms.ComboBox();
            this.ux_encryptionKeyLengthLabel = new System.Windows.Forms.Label();
            this.ux_encryptionKeyLengthNumericUpDown = new System.Windows.Forms.NumericUpDown();
            this.ux_encryptDocumentPropertiesCheckBox = new System.Windows.Forms.CheckBox();
            this.ux_outputPasswordToModifyLabel = new System.Windows.Forms.Label();
            this.ux_outputPasswordToModifyTextBox = new System.Windows.Forms.TextBox();
            this.ux_verifyOutputPasswordToModifyLabel = new System.Windows.Forms.Label();
            this.ux_verifyOutputPasswordToModifyTextBox = new System.Windows.Forms.TextBox();
            this.ux_outputPasswordToOpenLabel = new System.Windows.Forms.Label();
            this.ux_outputPasswordToOpenTextBox = new System.Windows.Forms.TextBox();
            this.ux_verifyOutputPasswordToOpenLabel = new System.Windows.Forms.Label();
            this.ux_verifyOutputPasswordToOpenTextBox = new System.Windows.Forms.TextBox();
            this.ux_encryptInputGroupBox.SuspendLayout();
            this.ux_encryptOutputGroupBox.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)
                (this.ux_encryptionKeyLengthNumericUpDown)).BeginInit();
            this.SuspendLayout();
            this.ux_encryptInputCheckBox.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_encryptInputCheckBox.Location = new System.Drawing.Point(8, 8);
            this.ux_encryptInputCheckBox.Name = "ux_encryptInputCheckBox";
            this.ux_encryptInputCheckBox.Size = new System.Drawing.Size(200, 16);
            this.ux_encryptInputCheckBox.TabIndex = 0;
            this.ux_encryptInputCheckBox.Text = "Input files are password protected";
            this.ux_encryptInputGroupBox.Anchor = AnchorStyles.Top | AnchorStyles.Left | AnchorStyles.Right;
            this.ux_encryptInputGroupBox.Controls.Add(this.ux_inputPasswordTextBox);
            this.ux_encryptInputGroupBox.Controls.Add(this.ux_inputPasswordLabel);
            this.ux_encryptInputGroupBox.Controls.Add(this.ux_verifyInputPasswordTextBox);
            this.ux_encryptInputGroupBox.Controls.Add(this.ux_verifyInputPasswordLabel);
            this.ux_encryptInputGroupBox.Location = new System.Drawing.Point(0, 8);
            this.ux_encryptInputGroupBox.Name = "ux_encryptInputGroupBox";
            this.ux_encryptInputGroupBox.Size = new System.Drawing.Size(352, 64);
            this.ux_encryptInputGroupBox.TabIndex = 1;
            this.ux_encryptInputGroupBox.TabStop = false;
            this.ux_encryptInputGroupBox.Text = "Encrypt Input";
            this.ux_inputPasswordLabel.AutoSize = true;
            this.ux_inputPasswordLabel.Location = new System.Drawing.Point(8, 16);
            this.ux_inputPasswordLabel.Name = "ux_inputPasswordLabel";
            this.ux_inputPasswordLabel.Size = new System.Drawing.Size(86, 17);
            this.ux_inputPasswordLabel.TabIndex = 0;
            this.ux_inputPasswordLabel.Text = "Input password:";
            this.ux_inputPasswordTextBox.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_inputPasswordTextBox.Location = new System.Drawing.Point(8, 32);
            this.ux_inputPasswordTextBox.MaxLength = 64;
            this.ux_inputPasswordTextBox.Name = "ux_inputPasswordTextBox";
            this.ux_inputPasswordTextBox.PasswordChar = '*';
            this.ux_inputPasswordTextBox.Size = new System.Drawing.Size(128, 21);
            this.ux_inputPasswordTextBox.TabIndex = 1;
            this.ux_inputPasswordTextBox.Text = "";
            this.ux_verifyInputPasswordLabel.AutoSize = true;
            this.ux_verifyInputPasswordLabel.Location = new System.Drawing.Point(144, 16);
            this.ux_verifyInputPasswordLabel.Name = "ux_verifyInputPasswordLabel";
            this.ux_verifyInputPasswordLabel.Size = new System.Drawing.Size(116, 17);
            this.ux_verifyInputPasswordLabel.TabIndex = 2;
            this.ux_verifyInputPasswordLabel.Text = "Verify input password:";
            this.ux_verifyInputPasswordTextBox.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_verifyInputPasswordTextBox.Location = new System.Drawing.Point(144, 32);
            this.ux_verifyInputPasswordTextBox.MaxLength = 64;
            this.ux_verifyInputPasswordTextBox.Name = "ux_verifyInputPasswordTextBox";
            this.ux_verifyInputPasswordTextBox.PasswordChar = '*';
            this.ux_verifyInputPasswordTextBox.Size = new System.Drawing.Size(128, 21);
            this.ux_verifyInputPasswordTextBox.TabIndex = 3;
            this.ux_verifyInputPasswordTextBox.Text = "";
            this.ux_encryptOutputCheckBox.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_encryptOutputCheckBox.Location = new System.Drawing.Point(8, 72);
            this.ux_encryptOutputCheckBox.Name = "ux_encryptOutputCheckBox";
            this.ux_encryptOutputCheckBox.Size = new System.Drawing.Size(200, 16);
            this.ux_encryptOutputCheckBox.TabIndex = 2;
            this.ux_encryptOutputCheckBox.Text = "Password protect modeling reports";
            this.ux_encryptOutputGroupBox.Anchor = AnchorStyles.Top | AnchorStyles.Left | AnchorStyles.Right;
            this.ux_encryptOutputGroupBox.Controls.Add(this.ux_encryptionTypeComboBox);
            this.ux_encryptOutputGroupBox.Controls.Add(this.ux_encryptionTypeLabel);
            this.ux_encryptOutputGroupBox.Controls.Add(this.ux_encryptionKeyLengthNumericUpDown);
            this.ux_encryptOutputGroupBox.Controls.Add(this.ux_encryptionKeyLengthLabel);
            this.ux_encryptOutputGroupBox.Controls.Add(this.ux_encryptDocumentPropertiesCheckBox);
            this.ux_encryptOutputGroupBox.Controls.Add(this.ux_outputPasswordToOpenTextBox);
            this.ux_encryptOutputGroupBox.Controls.Add(this.ux_outputPasswordToOpenLabel);
            this.ux_encryptOutputGroupBox.Controls.Add(this.ux_verifyOutputPasswordToOpenTextBox);
            this.ux_encryptOutputGroupBox.Controls.Add(this.ux_verifyOutputPasswordToOpenLabel);
            this.ux_encryptOutputGroupBox.Controls.Add(this.ux_outputPasswordToModifyTextBox);
            this.ux_encryptOutputGroupBox.Controls.Add(this.ux_outputPasswordToModifyLabel);
            this.ux_encryptOutputGroupBox.Controls.Add(this.ux_verifyOutputPasswordToModifyTextBox);
            this.ux_encryptOutputGroupBox.Controls.Add(this.ux_verifyOutputPasswordToModifyLabel);
            this.ux_encryptOutputGroupBox.Location = new System.Drawing.Point(0, 72);
            this.ux_encryptOutputGroupBox.Name = "ux_encryptOutputGroupBox";
            this.ux_encryptOutputGroupBox.Size = new System.Drawing.Size(352, 160);
            this.ux_encryptOutputGroupBox.TabIndex = 3;
            this.ux_encryptOutputGroupBox.TabStop = false;
            this.ux_encryptOutputGroupBox.Text = "Encrypt Output";
            this.ux_encryptionTypeLabel.AutoSize = true;
            this.ux_encryptionTypeLabel.Location = new System.Drawing.Point(8, 16);
            this.ux_encryptionTypeLabel.Name = "ux_encryptionTypeLabel";
            this.ux_encryptionTypeLabel.Size = new System.Drawing.Size(85, 17);
            this.ux_encryptionTypeLabel.TabIndex = 0;
            this.ux_encryptionTypeLabel.Text = "Encryption Type";
            this.ux_encryptionTypeLabel.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
            this.ux_encryptionTypeComboBox.Anchor = AnchorStyles.Top | AnchorStyles.Left | AnchorStyles.Right;
            this.ux_encryptionTypeComboBox.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.ux_encryptionTypeComboBox.DropDownWidth = 336;
            this.ux_encryptionTypeComboBox.Location = new System.Drawing.Point(8, 32);
            this.ux_encryptionTypeComboBox.MaxDropDownItems = 7;
            this.ux_encryptionTypeComboBox.Name = "ux_encryptionTypeComboBox";
            this.ux_encryptionTypeComboBox.Size = new System.Drawing.Size(264, 21);
            this.ux_encryptionTypeComboBox.TabIndex = 1;
            this.ux_encryptionKeyLengthLabel.Anchor = AnchorStyles.Top | AnchorStyles.Right;
            this.ux_encryptionKeyLengthLabel.AutoSize = true;
            this.ux_encryptionKeyLengthLabel.Location = new System.Drawing.Point(280, 16);
            this.ux_encryptionKeyLengthLabel.Name = "ux_encryptionKeyLengthLabel";
            this.ux_encryptionKeyLengthLabel.Size = new System.Drawing.Size(60, 17);
            this.ux_encryptionKeyLengthLabel.TabIndex = 2;
            this.ux_encryptionKeyLengthLabel.Text = "Key Length";
            this.ux_encryptionKeyLengthLabel.TextAlign = System.Drawing.ContentAlignment.BottomLeft;
            this.ux_encryptionKeyLengthNumericUpDown.Anchor = AnchorStyles.Top | AnchorStyles.Right;
            this.ux_encryptionKeyLengthNumericUpDown.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_encryptionKeyLengthNumericUpDown.Location = new System.Drawing.Point(280, 32);
            this.ux_encryptionKeyLengthNumericUpDown.Name = "ux_encryptionKeyLengthNumericUpDown";
            this.ux_encryptionKeyLengthNumericUpDown.Size = new System.Drawing.Size(64, 21);
            this.ux_encryptionKeyLengthNumericUpDown.TabIndex = 3;
            this.ux_encryptionKeyLengthNumericUpDown.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
            this.ux_encryptDocumentPropertiesCheckBox.CheckAlign = System.Drawing.ContentAlignment.TopLeft;
            this.ux_encryptDocumentPropertiesCheckBox.Location = new System.Drawing.Point(8, 56);
            this.ux_encryptDocumentPropertiesCheckBox.Name = "ux_encryptDocumentPropertiesCheckBox";
            this.ux_encryptDocumentPropertiesCheckBox.Size = new System.Drawing.Size(176, 16);
            this.ux_encryptDocumentPropertiesCheckBox.TabIndex = 4;
            this.ux_encryptDocumentPropertiesCheckBox.Text = "Encrypt Document Properties";
            this.ux_outputPasswordToOpenLabel.AutoSize = true;
            this.ux_outputPasswordToOpenLabel.Location = new System.Drawing.Point(8, 72);
            this.ux_outputPasswordToOpenLabel.Name = "ux_outputPasswordToOpenLabel";
            this.ux_outputPasswordToOpenLabel.Size = new System.Drawing.Size(97, 17);
            this.ux_outputPasswordToOpenLabel.TabIndex = 5;
            this.ux_outputPasswordToOpenLabel.Text = "Password to open:";
            this.ux_outputPasswordToOpenTextBox.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_outputPasswordToOpenTextBox.Location = new System.Drawing.Point(8, 88);
            this.ux_outputPasswordToOpenTextBox.MaxLength = 64;
            this.ux_outputPasswordToOpenTextBox.Name = "ux_outputPasswordToOpenTextBox";
            this.ux_outputPasswordToOpenTextBox.PasswordChar = '*';
            this.ux_outputPasswordToOpenTextBox.Size = new System.Drawing.Size(128, 21);
            this.ux_outputPasswordToOpenTextBox.TabIndex = 6;
            this.ux_outputPasswordToOpenTextBox.Text = "";
            this.ux_verifyOutputPasswordToOpenLabel.AutoSize = true;
            this.ux_verifyOutputPasswordToOpenLabel.Location = new System.Drawing.Point(144, 72);
            this.ux_verifyOutputPasswordToOpenLabel.Name = "ux_verifyOutputPasswordToOpenLabel";
            this.ux_verifyOutputPasswordToOpenLabel.Size = new System.Drawing.Size(88, 17);
            this.ux_verifyOutputPasswordToOpenLabel.TabIndex = 7;
            this.ux_verifyOutputPasswordToOpenLabel.Text = "Verify password:";
            this.ux_verifyOutputPasswordToOpenTextBox.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_verifyOutputPasswordToOpenTextBox.Location = new System.Drawing.Point(144, 88);
            this.ux_verifyOutputPasswordToOpenTextBox.MaxLength = 64;
            this.ux_verifyOutputPasswordToOpenTextBox.Name = "ux_verifyOutputPasswordToOpenTextBox";
            this.ux_verifyOutputPasswordToOpenTextBox.PasswordChar = '*';
            this.ux_verifyOutputPasswordToOpenTextBox.Size = new System.Drawing.Size(128, 21);
            this.ux_verifyOutputPasswordToOpenTextBox.TabIndex = 8;
            this.ux_verifyOutputPasswordToOpenTextBox.Text = "";
            this.ux_outputPasswordToModifyLabel.AutoSize = true;
            this.ux_outputPasswordToModifyLabel.Location = new System.Drawing.Point(8, 112);
            this.ux_outputPasswordToModifyLabel.Name = "ux_outputPasswordToModifyLabel";
            this.ux_outputPasswordToModifyLabel.Size = new System.Drawing.Size(106, 17);
            this.ux_outputPasswordToModifyLabel.TabIndex = 9;
            this.ux_outputPasswordToModifyLabel.Text = "Password to modify:";
            this.ux_outputPasswordToModifyTextBox.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_outputPasswordToModifyTextBox.Location = new System.Drawing.Point(8, 128);
            this.ux_outputPasswordToModifyTextBox.MaxLength = 64;
            this.ux_outputPasswordToModifyTextBox.Name = "ux_outputPasswordToModifyTextBox";
            this.ux_outputPasswordToModifyTextBox.PasswordChar = '*';
            this.ux_outputPasswordToModifyTextBox.Size = new System.Drawing.Size(128, 21);
            this.ux_outputPasswordToModifyTextBox.TabIndex = 10;
            this.ux_outputPasswordToModifyTextBox.Text = "";
            this.ux_verifyOutputPasswordToModifyLabel.AutoSize = true;
            this.ux_verifyOutputPasswordToModifyLabel.Location = new System.Drawing.Point(144, 112);
            this.ux_verifyOutputPasswordToModifyLabel.Name = "ux_verifyOutputPasswordToModifyLabel";
            this.ux_verifyOutputPasswordToModifyLabel.Size = new System.Drawing.Size(88, 17);
            this.ux_verifyOutputPasswordToModifyLabel.TabIndex = 11;
            this.ux_verifyOutputPasswordToModifyLabel.Text = "Verify password:";
            this.ux_verifyOutputPasswordToModifyTextBox.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.ux_verifyOutputPasswordToModifyTextBox.Location = new System.Drawing.Point(144, 128);
            this.ux_verifyOutputPasswordToModifyTextBox.MaxLength = 64;
            this.ux_verifyOutputPasswordToModifyTextBox.Name = "ux_verifyOutputPasswordToModifyTextBox";
            this.ux_verifyOutputPasswordToModifyTextBox.PasswordChar = '*';
            this.ux_verifyOutputPasswordToModifyTextBox.Size = new System.Drawing.Size(128, 21);
            this.ux_verifyOutputPasswordToModifyTextBox.TabIndex = 12;
            this.ux_verifyOutputPasswordToModifyTextBox.Text = "";
            this.Controls.AddRange(
                new Control[] {
                                  this.ux_encryptInputCheckBox,
                                  this.ux_encryptInputGroupBox,
                                  this.ux_encryptOutputCheckBox,
                                  this.ux_encryptOutputGroupBox
                              });
            this.Location = new Point(0, 0);
            this.Name = "EncryptionPanel";
            this.Size = new Size(352, 240);
            this.ux_encryptInputGroupBox.ResumeLayout(false);
            this.ux_encryptOutputGroupBox.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)
                (this.ux_encryptionKeyLengthNumericUpDown)).EndInit();
            this.ResumeLayout(false);
        }
        #endregion
        #region 
        private void InitializeControls()
        {
            this.ux_encryptInputCheckBox.Checked = true;
            this.ux_encryptOutputCheckBox.Checked = true;
            this.ux_encryptDocumentPropertiesCheckBox.Checked = true;
            EncryptionSettings.EncryptionTypeInfo[] encrTypes =
                Volpe.Cafe.EncryptionSettings.EncryptionTypes;
            for (int i = 0; i < encrTypes.Length; i++)
            {
                this.ux_encryptionTypeComboBox.Items.Add(encrTypes[i]);
            }
            this.InitializePwTextBoxes(this.ux_inputPasswordTextBox,
                this.ux_verifyInputPasswordTextBox, "input passwords");
            this.InitializePwTextBoxes(this.ux_outputPasswordToOpenTextBox,
                this.ux_verifyOutputPasswordToOpenTextBox, "output passwords to open");
            this.InitializePwTextBoxes(this.ux_outputPasswordToModifyTextBox,
                this.ux_verifyOutputPasswordToModifyTextBox, "output passwords to modify");
        }
        private void InitializeEventHandlers()
        {
            this.ux_encryptInputCheckBox.CheckedChanged += new EventHandler(this.CheckChangesDetector);
            this.ux_encryptOutputCheckBox.CheckedChanged += new EventHandler(this.CheckChangesDetector);
            this.ux_encryptDocumentPropertiesCheckBox.CheckedChanged += new EventHandler(this.CheckChangesDetector);
            this.ux_encryptInputCheckBox.CheckedChanged += new EventHandler(this.EncryptInputCheckBox_CheckedChanged);
            this.ux_encryptOutputCheckBox.CheckedChanged += new EventHandler(this.EncryptOutputCheckBox_CheckedChanged);
            this.ux_encryptionTypeComboBox.SelectedIndexChanged += new EventHandler(this.EncryptionTypeComboBox_SelectedIndexChanged);
            this.ux_encryptionTypeComboBox.SelectedIndex = 6;
            this.ux_encryptionKeyLengthNumericUpDown.ValueChanged += new EventHandler(this.EncryptionKeyLengthNumericUpDown_ValueChanged);
        }
        private void InitializePwTextBoxes(TextBox pw, TextBox verify, string message)
        {
            pw.Tag = new object[] {verify, pw, message};
            verify.Tag = new object[] {pw, pw};
            pw.TextChanged += new EventHandler(this.VerifyPasswordTextBox_TextChanged);
            verify.TextChanged += new EventHandler(this.VerifyPasswordTextBox_TextChanged);
        }
        private void SaveTextChanges()
        {
            this._textChanges = new object[5];
            this._textChanges[0] = (string)this.ux_inputPasswordTextBox.Text;
            this._textChanges[1] = (EncryptionSettings.EncryptionTypeInfo)this.ux_encryptionTypeComboBox.SelectedItem;
            this._textChanges[2] = (int)this.ux_encryptionKeyLengthNumericUpDown.Value;
            this._textChanges[3] = (string)this.ux_outputPasswordToOpenTextBox.Text;
            this._textChanges[4] = (string)this.ux_outputPasswordToModifyTextBox.Text;
        }
        #endregion
        #region 
        private void EncryptInputCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            bool expand = this.ux_encryptInputCheckBox.Checked;
            int increment = (expand) ? 1 : -1;
            int height = this.ux_encryptInputGroupBox.Height;
            if (expand)
            {
                this.ux_encryptInputGroupBox.Height = 0;
                this.ux_encryptInputGroupBox.Visible = true;
                this.ux_encryptOutputCheckBox.Top = 32;
                this.ux_encryptOutputGroupBox.Top = 32;
            }
            for (int i = 0; i < height; i++)
            {
                this.ux_encryptInputGroupBox.Height += increment;
                if ((!expand && this.ux_encryptOutputCheckBox.Top > 32) ||
                    (expand && this.ux_encryptInputGroupBox.Height >= 24))
                {
                    this.ux_encryptOutputCheckBox.Top += increment;
                    this.ux_encryptOutputGroupBox.Top += increment;
                }
            }
            if (!expand)
            {
                this.ux_encryptInputGroupBox.Visible = false;
                this.ux_encryptInputGroupBox.Height = height;
                if (this.ux_inputPasswordTextBox.Text !=
                    this.ux_verifyInputPasswordTextBox.Text)
                {
                    this.ux_inputPasswordTextBox.Text = (string)this._textChanges[0];
                    this.ux_verifyInputPasswordTextBox.Text = (string)this._textChanges[0];
                }
            }
        }
        private void EncryptOutputCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            bool expand = this.ux_encryptOutputCheckBox.Checked;
            int increment = (expand) ? 1 : -1;
            int height = this.ux_encryptOutputGroupBox.Height;
            if (expand)
            {
                this.ux_encryptOutputGroupBox.Height = 0;
                this.ux_encryptOutputGroupBox.Visible = true;
            }
            for (int i = 0; i < height; i++)
            {
                this.ux_encryptOutputGroupBox.Height += increment;
            }
            if (!expand)
            {
                this.ux_encryptOutputGroupBox.Visible = false;
                this.ux_encryptOutputGroupBox.Height = height;
                if (this.ux_outputPasswordToOpenTextBox.Text !=
                    this.ux_verifyOutputPasswordToOpenTextBox.Text)
                {
                    this.ux_outputPasswordToOpenTextBox.Text = (string)this._textChanges[3];
                    this.ux_verifyOutputPasswordToOpenTextBox.Text = (string)this._textChanges[3];
                }
                if (this.ux_outputPasswordToModifyTextBox.Text !=
                    this.ux_verifyOutputPasswordToModifyTextBox.Text)
                {
                    this.ux_outputPasswordToModifyTextBox.Text = (string)this._textChanges[4];
                    this.ux_verifyOutputPasswordToModifyTextBox.Text = (string)this._textChanges[4];
                }
            }
        }
        private void EncryptionTypeComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            EncryptionSettings.EncryptionTypeInfo crypto =
                (EncryptionSettings.EncryptionTypeInfo)this.ux_encryptionTypeComboBox.SelectedItem;
            if (this._textChanges != null)
            {
                bool textChanged = (!this._textChanges[1].Equals(crypto));
                Color color = Color.Black;
                Font font = this.Font;
                if (this._visualTracking && textChanged)
                {
                    color = this._visualTrackingColor;
                }
                this.ux_encryptionTypeComboBox.ForeColor = color;
                this.ux_encryptionTypeComboBox.Font = font;
            }
            if (crypto.DefaultKey == -1)
            {
                this.ux_encryptionKeyLengthNumericUpDown.Minimum = 0;
                this.ux_encryptionKeyLengthNumericUpDown.Maximum = 0;
            }
            else
            {
                this.ux_encryptionKeyLengthNumericUpDown.Minimum = crypto.MinKey;
                this.ux_encryptionKeyLengthNumericUpDown.Maximum = crypto.MaxKey;
                this.ux_encryptionKeyLengthNumericUpDown.Value = crypto.DefaultKey;
                this.ux_encryptionKeyLengthNumericUpDown.Increment = 8;
            }
            this.ux_encryptionKeyLengthNumericUpDown.Enabled = (crypto.DefaultKey != -1);
            this.ux_encryptDocumentPropertiesCheckBox.Enabled = crypto.EncryptDocProperties;
        }
        private void EncryptionKeyLengthNumericUpDown_ValueChanged(object sender, EventArgs e)
        {
            bool textChanged = ((int)this._textChanges[2] !=
                (int)this.ux_encryptionKeyLengthNumericUpDown.Value);
            Color color = Color.Black;
            Font font = this.Font;
            if (this._visualTracking && textChanged)
            {
                color = this._visualTrackingColor;
            }
            this.ux_encryptionKeyLengthNumericUpDown.ForeColor = color;
            this.ux_encryptionKeyLengthNumericUpDown.Font = font;
        }
        private void VerifyPasswordTextBox_TextChanged(object sender, EventArgs e)
        {
            TextBox tb1 = (TextBox)sender;
            TextBox tb2 = (TextBox)((object[])tb1.Tag)[0];
            TextBox key = (TextBox)((object[])tb1.Tag)[1];
            string message = (string)((object[])key.Tag)[2];
            if (tb1.Text != tb2.Text)
            {
                this._messages.AddMessage("The " + message + " do not match.",
                    Color.Red, key);
                tb1.BackColor = Color.LightYellow;
                tb1.ForeColor = Color.Red;
                tb1.Font = this.Font;
                tb2.BackColor = Color.LightYellow;
                tb2.ForeColor = Color.Red;
                tb2.Font = this.Font;
            }
            else
            {
                this._messages.RemoveMessage(key);
                tb1.BackColor = Color.White;
                tb2.BackColor = Color.White;
                bool textChanged = false;
                if (message.StartsWith("input"))
                {
                    textChanged = (tb1.Text != (string)this._textChanges[0]);
                }
                else if (message.EndsWith("open"))
                {
                    textChanged = (tb1.Text != (string)this._textChanges[3]);
                }
                else if (message.EndsWith("modify"))
                {
                    textChanged = (tb1.Text != (string)this._textChanges[4]);
                }
                if (this._visualTracking && textChanged)
                {
                    tb1.ForeColor = this._visualTrackingColor;
                    tb2.ForeColor = this._visualTrackingColor;
                }
                else
                {
                    tb1.ForeColor = Color.Black;
                    tb1.Font = this.Font;
                    tb2.ForeColor = Color.Black;
                    tb2.Font = this.Font;
                }
            }
        }
        #endregion
        public void SetInitialState(EncryptionSettings encryptionSettings)
        {
            this._encryptionSettings = encryptionSettings;
            bool vt = this._visualTracking;
            this._visualTracking = false;
            this.EncryptInput = encryptionSettings.EncryptInput;
            this.ux_inputPasswordTextBox.Text = encryptionSettings.InputPassword;
            this.ux_verifyInputPasswordTextBox.Text = encryptionSettings.InputPassword;
            this.EncryptOutput = encryptionSettings.EncryptOutput;
            this.ux_encryptionTypeComboBox.SelectedItem = encryptionSettings.EncryptionType;
            this.ux_encryptionKeyLengthNumericUpDown.Value = encryptionSettings.EncryptionKeyLength;
            this.ux_encryptDocumentPropertiesCheckBox.Checked = encryptionSettings.EncryptDocumentProperties;
            this.ux_outputPasswordToOpenTextBox.Text = encryptionSettings.OutputPasswordToOpen;
            this.ux_verifyOutputPasswordToOpenTextBox.Text = encryptionSettings.OutputPasswordToOpen;
            this.ux_outputPasswordToModifyTextBox.Text = encryptionSettings.OutputPasswordToModify;
            this.ux_verifyOutputPasswordToModifyTextBox.Text = encryptionSettings.OutputPasswordToModify;
            this._visualTracking = vt;
            this.SaveTextChanges();
            this._checkChanges.Clear();
        }
        public override void SaveChanges()
        {
            if (this.SettingsChanged)
            {
                this._encryptionSettings.EncryptInput = this.EncryptInput;
                this._encryptionSettings.InputPassword = this.ux_inputPasswordTextBox.Text;
                this._encryptionSettings.EncryptOutput = this.EncryptOutput;
                this._encryptionSettings.EncryptionType =
                    (EncryptionSettings.EncryptionTypeInfo)
                    this.ux_encryptionTypeComboBox.SelectedItem;
                this._encryptionSettings.EncryptionKeyLength =
                    (int)this.ux_encryptionKeyLengthNumericUpDown.Value;
                this._encryptionSettings.EncryptDocumentProperties =
                    this.ux_encryptDocumentPropertiesCheckBox.Checked;
                this._encryptionSettings.OutputPasswordToOpen =
                    this.ux_outputPasswordToOpenTextBox.Text;
                this._encryptionSettings.OutputPasswordToModify =
                    this.ux_outputPasswordToModifyTextBox.Text;
                if (this._visualTracking)
                {   
                    Color color = Control.DefaultForeColor;
                    this.ux_encryptInputCheckBox.ForeColor = color;
                    this.ux_inputPasswordTextBox.ForeColor = color;
                    this.ux_verifyInputPasswordTextBox.ForeColor = color;
                    this.ux_encryptOutputCheckBox.ForeColor = color;
                    this.ux_encryptionTypeComboBox.ForeColor = color;
                    this.ux_encryptionKeyLengthNumericUpDown.ForeColor = color;
                    this.ux_encryptDocumentPropertiesCheckBox.ForeColor = color;
                    this.ux_outputPasswordToOpenTextBox.ForeColor = color;
                    this.ux_verifyOutputPasswordToOpenTextBox.ForeColor = color;
                    this.ux_outputPasswordToModifyTextBox.ForeColor = color;
                    this.ux_verifyOutputPasswordToModifyTextBox.ForeColor = color;
                }
                this.SaveTextChanges();
                this._checkChanges.Clear();
            }
        }
        #endregion
        #region 
        [Browsable(false)]
        public override bool SettingsChanged
        {
            get
            {
                bool pwMatch =
                    (this.ux_inputPasswordTextBox.Text == this.ux_verifyInputPasswordTextBox.Text) &&
                    (this.ux_outputPasswordToOpenTextBox.Text == this.ux_verifyOutputPasswordToOpenTextBox.Text) &&
                    (this.ux_outputPasswordToModifyTextBox.Text == this.ux_verifyOutputPasswordToModifyTextBox.Text);
                bool textChanged =
                    !this._textChanges[0].Equals(this.ux_inputPasswordTextBox.Text) ||
                    !this._textChanges[1].Equals(this.ux_encryptionTypeComboBox.SelectedItem) ||
                    !this._textChanges[2].Equals((int)this.ux_encryptionKeyLengthNumericUpDown.Value) ||
                    !this._textChanges[3].Equals(this.ux_outputPasswordToOpenTextBox.Text) ||
                    !this._textChanges[4].Equals(this.ux_outputPasswordToModifyTextBox.Text);
                return pwMatch && (textChanged || base.SettingsChanged);
            }
        }
        [Browsable(false)]
        public EncryptionSettings EncryptionSettings
        {
            get
            {
                return this._encryptionSettings;
            }
        }
        [Browsable(true)]
        [Category("Configurations")]
        [Description("Specifies whether the input files are password protected.")]
        [DefaultValue(true)]
        public bool EncryptInput
        {
            get
            {
                return this.ux_encryptInputCheckBox.Checked;
            }
            set
            {
                bool vt = this._visualTracking;
                this._visualTracking = false;
                this.ux_encryptInputCheckBox.Checked = value;
                this._visualTracking = vt;
            }
        }
        [Browsable(true)]
        [Category("Configurations")]
        [Description("Specifies whether to password protect modeling reports.")]
        [DefaultValue(true)]
        public bool EncryptOutput
        {
            get
            {
                return this.ux_encryptOutputCheckBox.Checked;
            }
            set
            {
                bool vt = this._visualTracking;
                this._visualTracking = false;
                this.ux_encryptOutputCheckBox.Checked = value;
                this._visualTracking = vt;
            }
        }
        #endregion
        #region 
        #region 
        private System.Windows.Forms.CheckBox ux_encryptInputCheckBox;
        private System.Windows.Forms.GroupBox ux_encryptInputGroupBox;
        private System.Windows.Forms.Label ux_inputPasswordLabel;
        private System.Windows.Forms.TextBox ux_inputPasswordTextBox;
        private System.Windows.Forms.Label ux_verifyInputPasswordLabel;
        private System.Windows.Forms.TextBox ux_verifyInputPasswordTextBox;
        private System.Windows.Forms.CheckBox ux_encryptOutputCheckBox;
        private System.Windows.Forms.GroupBox ux_encryptOutputGroupBox;
        private System.Windows.Forms.Label ux_encryptionTypeLabel;
        private System.Windows.Forms.ComboBox ux_encryptionTypeComboBox;
        private System.Windows.Forms.Label ux_encryptionKeyLengthLabel;
        private System.Windows.Forms.NumericUpDown ux_encryptionKeyLengthNumericUpDown;
        private System.Windows.Forms.CheckBox ux_encryptDocumentPropertiesCheckBox;
        private System.Windows.Forms.Label ux_outputPasswordToOpenLabel;
        private System.Windows.Forms.TextBox ux_outputPasswordToOpenTextBox;
        private System.Windows.Forms.Label ux_verifyOutputPasswordToOpenLabel;
        private System.Windows.Forms.TextBox ux_verifyOutputPasswordToOpenTextBox;
        private System.Windows.Forms.Label ux_outputPasswordToModifyLabel;
        private System.Windows.Forms.TextBox ux_outputPasswordToModifyTextBox;
        private System.Windows.Forms.Label ux_verifyOutputPasswordToModifyLabel;
        private System.Windows.Forms.TextBox ux_verifyOutputPasswordToModifyTextBox;
        #endregion
        private EncryptionSettings _encryptionSettings;
        private object[] _textChanges;
        #endregion
    }
}

