using System;
using System.Drawing;
namespace Volpe.Cafe.Ui
{
    public sealed class Theme
    {
        #region 
        public class ImageSet
        {
            #region 
            public Image GetImage(int index)
            {
                return this.GetImage(ImageSet.ImageNames[index][0]);
            }
            public Image GetImage(string index)
            {
                index = index.ToLower();
                if (index == ImageSet.ImageNames[0][0])
                {
                    return this.SessionNew;
                }
                else if (index == ImageSet.ImageNames[1][0])
                {
                    return this.SessionOpen;
                }
                else if (index == ImageSet.ImageNames[2][0])
                {
                    return this.SessionSave;
                }
                else if (index == ImageSet.ImageNames[3][0])
                {
                    return this.ConfigFiles;
                }
                else if (index == ImageSet.ImageNames[4][0])
                {
                    return this.ConfigSettings;
                }
                else if (index == ImageSet.ImageNames[5][0])
                {
                    return this.ModelStart;
                }
                else if (index == ImageSet.ImageNames[6][0] ||
                    index == ImageSet.ImageNames[6][1])
                {
                    return this.ModelCancel;
                }
                else if (index == ImageSet.ImageNames[7][0] ||
                    index == ImageSet.ImageNames[7][1])
                {
                    return this.Back;
                }
                else if (index == ImageSet.ImageNames[8][0] ||
                    index == ImageSet.ImageNames[8][1])
                {
                    return this.Forward;
                }
                else if (index == ImageSet.ImageNames[9][0] ||
                    index == ImageSet.ImageNames[9][1])
                {
                    return this.Ok;
                }
                else if (index == ImageSet.ImageNames[10][0] ||
                    index == ImageSet.ImageNames[10][1])
                {
                    return this.Cancel;
                }
                else
                {
                    return null;
                }
            }
            #endregion
            #region 
            private static readonly string[][] ImageNames =
                new string[][] {
                                   new string[] {"session-new"},
                                   new string[] {"session-open"},
                                   new string[] {"session-save"},
                                   new string[] {"config-files"},
                                   new string[] {"config-settings"},
                                   new string[] {"model-start"},
                                   new string[] {"model-cancel", "model-stop"},
                                   new string[] {"back",    "previous"},
                                   new string[] {"forward", "next"},
                                   new string[] {"ok",     "save"},
                                   new string[] {"cancel", "close"}
                             };
            public Image SessionNew = null;
            public Image SessionOpen = null;
            public Image SessionSave = null;
            public Image ConfigFiles = null;
            public Image ConfigSettings = null;
            public Image ModelStart = null;
            public Image ModelCancel = null;
            public Image Back = null;
            public Image Forward = null;
            public Image Ok = null;
            public Image Cancel = null;
            #endregion
        }
        #endregion
        #region 
        public Theme(ThemeDescription description)
        {
            bool has22 = description.x22 != "";
            bool has32 = description.x32 != "";
            bool hasB0 = description.BaseSmall != "";
            bool hasB1 = description.BaseLarge != "";
            bool hasA0 = description.AltSmall != "";
            bool hasA1 = description.AltLarge != "";
            this._descr = description;
            this._alternatives = this.CalcNumAlts(description);
            this._scaling = (has22 && has32);
            this._rollover = (hasB0 && hasA0);
            this._x22 = (has22) ? new ImageSet[this._alternatives] : null;
            this._x32 = (has32) ? new ImageSet[this._alternatives] : null;
            this._base0 = (hasB0) ? new ImageSet[this._alternatives] : null;
            this._base1 = (hasB1) ? new ImageSet[this._alternatives] : null;
            this._alt0 = (hasA0) ? new ImageSet[this._alternatives] : null;
            this._alt1 = (hasA1) ? new ImageSet[this._alternatives] : null;
            for (int i = 0; i < this._alternatives; i++)
            {
                if (has22) this.LoadImageSet(this._x22, description.x22, description, i);
                if (has32) this.LoadImageSet(this._x32, description.x32, description, i);
                if (hasB0) this.LoadImageSet(this._base0, description.BaseSmall, description, i);
                if (hasB1) this.LoadImageSet(this._base1, description.BaseLarge, description, i);
                if (hasA0) this.LoadImageSet(this._alt0, description.AltSmall, description, i);
                if (hasA1) this.LoadImageSet(this._alt1, description.AltLarge, description, i);
            }
        }
        #endregion
        #region 
        private int CalcNumAlts(ThemeDescription descr)
        {
            int max = descr.SessionNew.Length;
            if (max < descr.SessionOpen.Length) max = descr.SessionOpen.Length;
            if (max < descr.SessionSave.Length) max = descr.SessionSave.Length;
            if (max < descr.ConfigFiles.Length) max = descr.ConfigFiles.Length;
            if (max < descr.ConfigSettings.Length) max = descr.ConfigSettings.Length;
            if (max < descr.ModelStart.Length) max = descr.ModelStart.Length;
            if (max < descr.ModelCancel.Length) max = descr.ModelCancel.Length;
            if (max < descr.Back.Length) max = descr.Back.Length;
            if (max < descr.Forward.Length) max = descr.Forward.Length;
            if (max < descr.Ok.Length) max = descr.Ok.Length;
            if (max < descr.Cancel.Length) max = descr.Cancel.Length;
            return max;
        }
        private void LoadImageSet(ImageSet[] imageSet, string path, ThemeDescription descr, int i)
        {
            imageSet[i] = new ImageSet();
            imageSet[i].SessionNew = (i < descr.SessionNew.Length) ?
                new Bitmap(path + "\\" + descr.SessionNew[i]) : imageSet[i - 1].SessionNew;
            imageSet[i].SessionOpen = (i < descr.SessionOpen.Length) ?
                new Bitmap(path + "\\" + descr.SessionOpen[i]) : imageSet[i - 1].SessionOpen;
            imageSet[i].SessionSave = (i < descr.SessionSave.Length) ?
                new Bitmap(path + "\\" + descr.SessionSave[i]) : imageSet[i - 1].SessionSave;
            imageSet[i].ConfigFiles = (i < descr.ConfigFiles.Length) ?
                new Bitmap(path + "\\" + descr.ConfigFiles[i]) : imageSet[i - 1].ConfigFiles;
            imageSet[i].ConfigSettings = (i < descr.ConfigSettings.Length) ?
                new Bitmap(path + "\\" + descr.ConfigSettings[i]) : imageSet[i - 1].ConfigSettings;
            imageSet[i].ModelStart = (i < descr.ModelStart.Length) ?
                new Bitmap(path + "\\" + descr.ModelStart[i]) : imageSet[i - 1].ModelStart;
            imageSet[i].ModelCancel = (i < descr.ModelCancel.Length) ?
                new Bitmap(path + "\\" + descr.ModelCancel[i]) : imageSet[i - 1].ModelCancel;
            imageSet[i].Back = (i < descr.Back.Length) ?
                new Bitmap(path + "\\" + descr.Back[i]) : imageSet[i - 1].Back;
            imageSet[i].Forward = (i < descr.Forward.Length) ?
                new Bitmap(path + "\\" + descr.Forward[i]) : imageSet[i - 1].Forward;
            imageSet[i].Ok = (i < descr.Ok.Length) ?
                new Bitmap(path + "\\" + descr.Ok[i]) : imageSet[i - 1].Ok;
            imageSet[i].Cancel = (i < descr.Cancel.Length) ?
                new Bitmap(path + "\\" + descr.Cancel[i]) : imageSet[i - 1].Cancel;
        }
        #endregion
        #region 
        public string Name
        {
            get
            {
                return this._descr.Name;
            }
        }
        public string Description
        {
            get
            {
                return this._descr.Description;
            }
        }
        public int Alternatives
        {
            get
            {
                return this._alternatives;
            }
        }
        public bool Scaling
        {
            get
            {
                return this._scaling;
            }
        }
        public bool Rollover
        {
            get
            {
                return this._rollover;
            }
        }
        public Theme.ImageSet[] X22
        {
            get
            {
                return this._x22;
            }
        }
        public Theme.ImageSet[] X32
        {
            get
            {
                return this._x32;
            }
        }
        public Theme.ImageSet[] BaseSmall
        {
            get
            {
                return this._base0;
            }
        }
        public Theme.ImageSet[] BaseLarge
        {
            get
            {
                return this._base1;
            }
        }
        public Theme.ImageSet[] AltSmall
        {
            get
            {
                return this._alt0;
            }
        }
        public Theme.ImageSet[] AltLarge
        {
            get
            {
                return this._alt1;
            }
        }
        #endregion
        #region 
        private ThemeDescription _descr;
        private int _alternatives;
        private bool _scaling;
        private bool _rollover;
        private Theme.ImageSet[] _x22, _x32, _base0, _base1, _alt0, _alt1;
        #endregion
    }
}

