using System;
using System.Collections;
using System.Collections.Specialized;
using System.Runtime.Serialization;
using System.IO;
using Volpe.Cafe.IO;
namespace Volpe.Cafe
{
    [Serializable]
    public struct InputSettings : ISerializable 
    {
        #region 
        public InputSettings(string dataPath)
        {
            this._dataPath                = dataPath;
            this.MarketDataFile           = "";
            this.TechnologiesFile         = "";
            this.ParametersFile           = "";
            this.EmissionsRatesFile       = "";
            this.ScenariosFile            = "";
            this.MarketDataFileLoaded     = false;
            this.TechnologiesFileLoaded   = false;
            this.ParametersFileLoaded     = false;
            this.EmissionsRatesFileLoaded = false;
            this.ScenariosFileLoaded      = false;
        }
        private InputSettings(SerializationInfo info, StreamingContext context)
            : this("")
        {
            this.MarketDataFile           = info.GetString ("MarketDataFile"          );
            this.TechnologiesFile         = info.GetString ("TechnologiesFile"        );
            this.ParametersFile           = info.GetString ("ParametersFile"          );
            this.EmissionsRatesFile       = info.GetString ("EmissionsRatesFile"      );
            this.ScenariosFile            = info.GetString ("ScenariosFile"           );
            this.MarketDataFileLoaded     = info.GetBoolean("MarketDataFileLoaded"    );
            this.TechnologiesFileLoaded   = info.GetBoolean("TechnologiesFileLoaded"  );
            this.ParametersFileLoaded     = info.GetBoolean("ParametersFileLoaded"    );
            this.EmissionsRatesFileLoaded = info.GetBoolean("EmissionsRatesFileLoaded");
            this.ScenariosFileLoaded      = info.GetBoolean("ScenariosFileLoaded"     );
            this._dataPath = info.GetString("_dataPath");
        }
        #endregion
        #region 
        #region 
        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            info.AddValue("MarketDataFile"          , this.MarketDataFile          );
            info.AddValue("TechnologiesFile"        , this.TechnologiesFile        );
            info.AddValue("ParametersFile"          , this.ParametersFile          );
            info.AddValue("EmissionsRatesFile"      , this.EmissionsRatesFile      );
            info.AddValue("ScenariosFile"           , this.ScenariosFile           );
            info.AddValue("MarketDataFileLoaded"    , this.MarketDataFileLoaded    );
            info.AddValue("TechnologiesFileLoaded"  , this.TechnologiesFileLoaded  );
            info.AddValue("ParametersFileLoaded"    , this.ParametersFileLoaded    );
            info.AddValue("EmissionsRatesFileLoaded", this.EmissionsRatesFileLoaded);
            info.AddValue("ScenariosFileLoaded"     , this.ScenariosFileLoaded     );
            info.AddValue("_dataPath"               , this._dataPath               );
        }
        #endregion
        internal void WriteSummaryLog(LogWriter writer)
        {
            if (writer.Summary == null) { return; }
            string outStr = "--- Input Settings ---"                    +
                "\r\n  Data Path="            + this._dataPath          +
                "\r\n  Market-Data File="     + this.MarketDataFile     +
                "\r\n  Technologies File="    + this.TechnologiesFile   +
                "\r\n  Parameters File="      + this.ParametersFile     +
                "\r\n  Emissions-Rates File=" + this.EmissionsRatesFile +
                "\r\n  Scenarios File="       + this.ScenariosFile;
            writer.Summary.WriteLine(outStr + "\r\n");
        }
        #endregion
        #region 
        public string DataPath { get { return this._dataPath; } }
        #endregion
        #region 
        public string MarketDataFile;
        public string TechnologiesFile;
        public string ParametersFile;
        public string EmissionsRatesFile;
        public string ScenariosFile;
        public bool MarketDataFileLoaded;
        public bool TechnologiesFileLoaded;
        public bool ParametersFileLoaded;
        public bool EmissionsRatesFileLoaded;
        public bool ScenariosFileLoaded;
        private string _dataPath;
        #endregion
    }
}

